/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.aduitlog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;

public class AduitRulesTreeListPlugin
extends StandardTreeListPlugin
implements RowClickEventListener,
ItemClickListener {
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndel";
    private static final String PREFIX_APP = "app_";
    private static final String PREFIX_CLOUD = "cloud_";
    private static final String KEY_BIZOBJ = "bizobj";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        List<TreeNode> childNodes = this.getChildNodes(nodeId);
        e.setChildNodes(childNodes);
    }

    private List<TreeNode> getChildNodes(String parentId) {
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode parent = root.getTreeNode(parentId, 20);
        if (parent == null || parent.getChildren() == null || parent.getChildren().isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        return parent.getChildren();
    }

    public void initializeTree(EventObject e) {
        this.initTree();
    }

    private void initTree() {
        List<TreeNode> cloudNodes = this.getCloudNodes();
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"AduitRulesTreeListPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        root.setChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setBarItemEnable(false, true);
    }

    private List<TreeNode> getCloudNodes() {
        List clouds = null;
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>();
        }
        Map<String, String> originExtendAppRelMap = this.getOriginExtendAppRelMap();
        Map<String, List<TreeNode>> billNodesMap = this.getBillNodesMap(originExtendAppRelMap);
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            String cloudNodeId = PREFIX_CLOUD + cloud.getId();
            cloud.setId(cloudNodeId);
            cloud.setData((Object)"cloud");
            List apps = cloud.getChildren();
            if (apps == null) {
                cloudIterator.remove();
                continue;
            }
            Iterator appIterator = apps.iterator();
            while (appIterator.hasNext()) {
                TreeNode app = (TreeNode)appIterator.next();
                String appNodeId = PREFIX_APP + app.getId();
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData((Object)"app");
                String masterId = originExtendAppRelMap.get(appNodeId);
                List<TreeNode> billNodes = billNodesMap.get(masterId);
                if (billNodes == null || billNodes.isEmpty()) {
                    appIterator.remove();
                    continue;
                }
                app.setChildren(billNodes);
            }
            if (!apps.isEmpty()) continue;
            cloudIterator.remove();
        }
        return clouds;
    }

    private Map<String, String> getOriginExtendAppRelMap() {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        HashMap<String, String> originExtendAppRelMap = new HashMap<String, String>();
        for (DynamicObject app : allApps) {
            String type = app.getString("type");
            String nodeId = PREFIX_APP + app.getString("id");
            if ("0".equals(type)) {
                originExtendAppRelMap.put(nodeId, nodeId);
                continue;
            }
            String masterId = PREFIX_APP + app.getString("masterid");
            originExtendAppRelMap.put(nodeId, masterId);
        }
        return originExtendAppRelMap;
    }

    private Map<String, List<TreeNode>> getBillNodesMap(Map<String, String> originExtendAppRelMap) {
        DynamicObject[] objects;
        HashMap<String, List<TreeNode>> billNodesMap = new HashMap<String, List<TreeNode>>();
        String fields = "id, number, name, bizappid.id ";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter enableImport = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{modelTypeFilter, isTemplateFilter, enableImport};
        filters = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])filters, (String)"dentityid");
        for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)fields, (QFilter[])filters)) {
            String nodeId = object.getString("id");
            String name = object.getLocaleString("name").toString();
            String parentId = PREFIX_APP + object.getString("bizappid.id");
            String data = object.getString("number");
            TreeNode node = this.createTreeNode(nodeId, name, parentId, data);
            String masterId = originExtendAppRelMap.get(parentId);
            if (StringUtils.isBlank((CharSequence)masterId)) continue;
            ArrayList<TreeNode> nodes = (ArrayList<TreeNode>)billNodesMap.get(masterId);
            if (nodes == null) {
                nodes = new ArrayList<TreeNode>();
                billNodesMap.put(masterId, nodes);
            }
            nodes.add(node);
        }
        return billNodesMap;
    }

    private TreeNode createTreeNode(String nodeId, String name, String parentId, String data) {
        TreeNode node = new TreeNode();
        node.setText(name);
        node.setParentid(parentId);
        node.setId(nodeId);
        node.setData((Object)data);
        return node;
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        String nodeId = treenodeevent.getNodeId().toString();
        this.getPageCache().put("nodeId", nodeId);
        super.treeNodeClick(treenodeevent);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        QFilter filter = null;
        if (this.isTopNodeId(nodeId)) {
            return;
        }
        if (nodeId.contains(PREFIX_CLOUD)) {
            String cloudId = StringUtils.substringAfter((String)nodeId, (String)"_");
            filter = new QFilter(KEY_BIZOBJ, "in", this.getBillIdInCloud(cloudId));
        } else if (nodeId.contains(PREFIX_APP)) {
            String appId = StringUtils.substringAfter((String)nodeId, (String)"_");
            filter = new QFilter(KEY_BIZOBJ, "in", this.getBillIdInApp(appId));
        } else {
            filter = new QFilter(KEY_BIZOBJ, "=", (Object)nodeId);
        }
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private List<String> getBillIdInApp(String appId) {
        Object[] param = new SqlParameter[]{new SqlParameter(":FBIZAPPID", 12, (Object)appId)};
        String strSQL = "SELECT FID FROM t_meta_mainentityinfo WHERE FBIZAPPID = ? AND\u3000(FMODELTYPE = 'BillFormModel' OR FMODELTYPE = 'BaseFormModel') ";
        ResultSetHandler action = rs -> {
            ArrayList<String> tempIdList = new ArrayList<String>(10);
            while (rs.next()) {
                tempIdList.add(rs.getString("FID"));
            }
            return tempIdList;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)strSQL, (Object[])param, (ResultSetHandler)action);
    }

    private List<String> getBillIdInCloud(String cloudId) {
        Object[] param = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)cloudId)};
        String strSQL = "SELECT C.FID FROM t_meta_bizcloud A LEFT JOIN t_meta_bizapp B ON A.FID = B.FBIZCLOUDID LEFT JOIN t_meta_mainentityinfo C  ON C.FBIZAPPID = B.FID WHERE A.FID = ?";
        ResultSetHandler action = rs -> {
            ArrayList<String> tempIdList = new ArrayList<String>(10);
            while (rs.next()) {
                tempIdList.add(rs.getString("FID"));
            }
            return tempIdList;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)strSQL, (Object[])param, (ResultSetHandler)action);
    }

    private boolean isTopNodeId(String currNodeId) {
        return currNodeId.equals(this.getTreeModel().getRoot().getId());
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW});
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{BTN_EDIT, BTN_DELETE});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
            this.getTreeListView().focusRootNode();
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter param = e.getParameter();
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        String rootId = this.getTreeModel().getRoot().getId();
        if (currentNodeId.contains(PREFIX_CLOUD) || currentNodeId.contains(PREFIX_APP) || rootId.equals(currentNodeId)) {
            return;
        }
        param.setCustomParam("nodeId", (Object)currentNodeId);
    }
}

