/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.aduitlog;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICreateTimeProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IModifyTimeProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TimeLineStyle;
import kd.bos.form.control.Timeline;
import kd.bos.form.control.TimelineContentOption;
import kd.bos.form.control.TimelineLabelOption;
import kd.bos.form.control.TimelineOption;
import kd.bos.form.control.TimelineOptionClickArg;
import kd.bos.form.control.TimelineOptionKey;
import kd.bos.form.control.TimelineText;
import kd.bos.form.control.events.TimelineEvent;
import kd.bos.form.control.events.TimelineListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OperationAuditLogPlugin
extends AbstractFormPlugin {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String ADUITLOG = "aduitLog";
    private static final String ESADUITLOG = "esAduitLog";
    private static final String MODIFYBILLID = "modifybillid";
    private static final String C = "c";
    private static final String K = "k";
    private static final String POINT = ".";
    private static final String KEY_WORKFLOW_INFO = "workflowinfo";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Timeline timeline = (Timeline)this.getView().getControl("timelineap");
        timeline.addTimelineListener(new TimelineListener(){

            public void update(TimelineEvent timelineEvent) {
            }

            public void optionClick(TimelineOptionClickArg e) {
                String[] strs = e.getOptionKey().split("\\$");
                String pkId = strs[1];
                Long opdate = null;
                if (strs.length > 2) {
                    opdate = Long.parseLong(strs[2]);
                }
                OperationAuditLogPlugin.this.viewDetails(pkId, opdate);
            }
        });
    }

    private void viewDetails(Object pkId, Long opdate) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bos_aduit_log_detail");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("pkId", pkId);
        fsp.setCustomParam("opdate", (Object)opdate);
        Object esAduitLog = this.getView().getFormShowParameter().getCustomParam(ADUITLOG);
        if (esAduitLog != null && ESADUITLOG.equals(esAduitLog)) {
            fsp.setCustomParam(ADUITLOG, (Object)ESADUITLOG);
        }
        this.getView().showForm(fsp);
    }

    public void afterBindData(EventObject e) {
        this.loadData();
        super.afterBindData(e);
    }

    private void parseModifyFields(JSONObject mJsonObject, List<String> logSteps, String parentC) {
        String mType = mJsonObject.getString("f");
        String bizobj = (String)this.getView().getFormShowParameter().getCustomParam("bizobj");
        MainEntityType entityType = null;
        if (StringUtils.isNotEmpty((CharSequence)bizobj)) {
            entityType = EntityMetadataCache.getDataEntityType((String)bizobj);
        }
        for (Map.Entry entry : mJsonObject.entrySet()) {
            String s2;
            String s1;
            String entryKey = (String)entry.getKey();
            if (C.equals(entryKey) || K.equals(entryKey) || KEY_WORKFLOW_INFO.equals(entryKey)) continue;
            String fieldName = this.getLocaleFieldName(entityType, entryKey);
            if (entry.getValue() instanceof List) {
                List jsonObjects = (List)entry.getValue();
                if (jsonObjects.isEmpty()) continue;
                this.addEntryLogStep(logSteps, jsonObjects, fieldName);
                continue;
            }
            if (!(entry.getValue() instanceof JSONObject)) continue;
            JSONObject jsonObject = (JSONObject)entry.getValue();
            if ("+".equals(mType)) {
                s1 = ResManager.loadKDString((String)"\u65b0\u589e\u503c\u4e3a", (String)"OperationAuditLogPlugin_9", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
                s2 = ResManager.loadKDString((String)"<\u7a7a>", (String)"OperationAuditLogPlugin_10", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
                logSteps.add(String.format("%s %s %s", this.bettyContent(fieldName, s2), s1, this.bettyContent(jsonObject.get((Object)"o"), s2)));
                continue;
            }
            s1 = ResManager.loadKDString((String)"\u4ece", (String)"OperationAuditLogPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
            s2 = ResManager.loadKDString((String)"\u66f4\u65b0\u4e3a", (String)"OperationAuditLogPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
            String s3 = ResManager.loadKDString((String)"<\u7a7a>", (String)"OperationAuditLogPlugin_10", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
            logSteps.add(String.format("%s %s %s%s %s %s", parentC, this.bettyContent(fieldName, s3), s1, this.bettyContent(jsonObject.get((Object)"o"), s3), s2, this.bettyContent(jsonObject.get((Object)"n"), s3)));
        }
    }

    private String getLocaleFieldName(MainEntityType dataEntityType, String nextKey) {
        if (dataEntityType == null) {
            return "";
        }
        IDataEntityProperty findProperty = dataEntityType.findProperty(nextKey);
        String fieldName = null;
        if (findProperty != null) {
            fieldName = findProperty.getDisplayName().toString();
        }
        return fieldName;
    }

    private Object bettyContent(Object content, String s3) {
        return StringUtils.isBlank((Object)content) ? s3 : content;
    }

    private boolean isNotNullOrZero(Integer integer) {
        return integer != null && integer != 0;
    }

    private void addEntryLogStep(List<String> logSteps, List<JSONObject> jsonObjects, String fieldName) {
        LinkedHashMap<String, Integer> entityNameAddedContents = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> entityNameDeletedContents = new LinkedHashMap<String, Integer>();
        LinkedHashMap entityNameModifiedContents = new LinkedHashMap();
        LinkedHashSet<String> entityNames = new LinkedHashSet<String>(10);
        for (JSONObject jsonObject : jsonObjects) {
            String f = jsonObject.getString("f");
            String[] c = jsonObject.getString(C).split("\\.");
            entityNames.add(fieldName);
            if ("+".equals(f)) {
                Integer added = (Integer)entityNameAddedContents.get(fieldName);
                if (added == null) {
                    added = 0;
                }
                added = added + 1;
                entityNameAddedContents.put(fieldName, added);
                continue;
            }
            if ("-".equals(f)) {
                Integer deleted = (Integer)entityNameDeletedContents.get(fieldName);
                if (deleted == null) {
                    deleted = 0;
                }
                deleted = deleted + 1;
                entityNameDeletedContents.put(fieldName, deleted);
                continue;
            }
            String parentC = fieldName;
            if (c.length > 1) {
                parentC = fieldName + POINT + c[1];
            }
            this.parseModifyFields(jsonObject, logSteps, parentC);
        }
        StringBuilder logStep = new StringBuilder();
        String s1 = ResManager.loadKDString((String)"\u6dfb\u52a0\u4e86", (String)"OperationAuditLogPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        String s2 = ResManager.loadKDString((String)"\u4fee\u6539\u4e86", (String)"OperationAuditLogPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        String s3 = ResManager.loadKDString((String)"\u5220\u9664\u4e86", (String)"OperationAuditLogPlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        String s4 = ResManager.loadKDString((String)"\u884c\u6570\u636e", (String)"OperationAuditLogPlugin_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        for (String entityName : entityNames) {
            Integer added = (Integer)entityNameAddedContents.get(entityName);
            Integer deleted = (Integer)entityNameDeletedContents.get(entityName);
            Integer modified = (Integer)entityNameModifiedContents.get(entityName);
            if (this.isNotNullOrZero(added) || this.isNotNullOrZero(modified) || this.isNotNullOrZero(deleted)) {
                logStep.append(entityName);
                logStep.append(" ");
            }
            if (this.isNotNullOrZero(added)) {
                logStep.append(String.format("%s %s %s ", s1, added, s4));
            }
            if (this.isNotNullOrZero(modified)) {
                logStep.append(String.format("%s %s %s ", s2, modified, s4));
            }
            if (this.isNotNullOrZero(deleted)) {
                logStep.append(String.format("%s %s %s ", s3, deleted, s4));
            }
            if (!StringUtils.isNotBlank((CharSequence)logStep)) continue;
            logSteps.add(logStep.toString());
        }
    }

    private void loadData() {
        String bizobj = (String)this.getView().getFormShowParameter().getCustomParam("bizobj");
        String modifybillid = (String)this.getView().getFormShowParameter().getCustomParam(MODIFYBILLID);
        Object esAduitLog = this.getView().getFormShowParameter().getCustomParam(ADUITLOG);
        DynamicObject[] dynamicObjects = null;
        String optime = "optime";
        if (esAduitLog != null && ESADUITLOG.equals(esAduitLog)) {
            MainEntityType entityType;
            optime = "opdate";
            LogORM logOrm = LogORM.create();
            DynamicObject[] qFilterList = new ArrayList(8);
            qFilterList.add(new QFilter("bizobjnumber", "=", (Object)bizobj));
            qFilterList.add(new QFilter(MODIFYBILLID, "in", (Object)new String[]{modifybillid, modifybillid + "+", modifybillid + "-"}));
            if (StringUtils.isNotEmpty((CharSequence)bizobj) && StringUtils.isNotEmpty((CharSequence)modifybillid) && (entityType = EntityMetadataCache.getDataEntityType((String)bizobj)) != null) {
                String selector;
                DynamicObject dObj;
                ICreateTimeProperty createTimeProperty = entityType.getCreateTimeProperty();
                IModifyTimeProperty modifyTimeProperty = entityType.getModifyTimeProperty();
                if (createTimeProperty != null && modifyTimeProperty != null && (dObj = BusinessDataServiceHelper.loadSingle((Object)modifybillid, (String)bizobj, (String)(selector = createTimeProperty.getName() + "," + modifyTimeProperty.getName()))) != null) {
                    Object valMod;
                    Object val = createTimeProperty.getValue((Object)dObj);
                    if (val instanceof Date) {
                        Date val2 = new Date(((Date)val).getTime() - 10000L);
                        qFilterList.add(new QFilter("opdate", ">=", (Object)val2));
                    }
                    if ((valMod = modifyTimeProperty.getValue((Object)dObj)) instanceof Date) {
                        Date val2 = new Date(((Date)valMod).getTime() + 10000L);
                        qFilterList.add(new QFilter("opdate", "<=", (Object)val2));
                    }
                }
            }
            DynamicObjectCollection col = logOrm.query("bos_aduit_log_new", "id,username,opdate,modifybillid,modifycontent_tag", qFilterList.toArray(new QFilter[0]), 10000, 0);
            dynamicObjects = (DynamicObject[])col.toArray((Object[])new DynamicObject[0]);
        } else {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("bizobj", "=", (Object)bizobj));
            qFilters.add(new QFilter(MODIFYBILLID, "in", (Object)new String[]{modifybillid, modifybillid + "+", modifybillid + "-"}));
            dynamicObjects = BusinessDataServiceHelper.load((String)"bos_aduit_log_view", (String)"username,optime,modifybillid,modifycontent_tag", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"optime desc");
        }
        ArrayList<TimelineOption> timelineOptions = new ArrayList<TimelineOption>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date date = dynamicObject.getDate(optime);
            SimpleDateFormat parseDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            LocaleString title = new LocaleString(String.format("%s  %s", date == null ? "" : parseDateFormat.format(date), dynamicObject.getString("username")));
            String modifycontentTag = dynamicObject.getString("modifycontent_tag");
            ArrayList<String> logSteps = new ArrayList<String>();
            JSONObject jsonObject = (JSONObject)JSONObject.parse((String)modifycontentTag);
            String dbmodifybillid = dynamicObject.getString(MODIFYBILLID);
            logSteps.add(this.getModifyOpDesc(dbmodifybillid));
            if (!dbmodifybillid.endsWith("+") && !dbmodifybillid.endsWith("-")) {
                this.parseModifyFields(jsonObject, logSteps, "");
            }
            ArrayList<TimelineText> timelineTexts = new ArrayList<TimelineText>(10);
            for (String logStep : logSteps) {
                TimelineText timelineText = new TimelineText();
                timelineText.setText(new LocaleString(logStep));
                TimeLineStyle style = new TimeLineStyle();
                style.setMaxHeight("50px !important");
                style.setDisplay("-webkit-box");
                style.setWebKidBoxOrient("vertical");
                style.setWebKitLineClamp("3");
                timelineText.setStyle(style);
                timelineTexts.add(timelineText);
            }
            TimelineContentOption timelineContentOption = new TimelineContentOption(title, timelineTexts);
            TimelineOption timelineOption = new TimelineOption(new TimelineLabelOption(), timelineContentOption);
            ArrayList<TimelineOptionKey> optionKeys = new ArrayList<TimelineOptionKey>();
            String operaKey = "viewdetail$" + dynamicObject.getString("id");
            if (date != null) {
                operaKey = operaKey + "$" + date.getTime();
            }
            optionKeys.add(new TimelineOptionKey(new LocaleString(ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"OperationAuditLogPlugin_11", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])), operaKey));
            timelineOption.setOptionKeys(optionKeys);
            timelineOptions.add(timelineOption);
        }
        Timeline timeline = (Timeline)this.getControl("timelineap");
        timeline.setClientTimelineOptions(timelineOptions);
    }

    private String getModifyOpDesc(String modifybillid) {
        if (modifybillid.endsWith("+")) {
            return ResManager.loadKDString((String)"\u65b0\u589e\u4e86\u5355\u636e", (String)"OperationAuditLogPlugin_6", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        }
        if (modifybillid.endsWith("-")) {
            return ResManager.loadKDString((String)"\u5220\u9664\u4e86\u5355\u636e", (String)"OperationAuditLogPlugin_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        }
        return "";
    }
}

