/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.billtype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillTypeControlInfo;
import kd.bos.entity.DifferentialControlInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.FieldApInfoUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.billtype.BillTypeServiceHelper;

public class BillTypeControlEntryMobWidget {
    public static final String FIELD_KEY = "mob_fieldkey";
    public static final String FIELD_MUST_INPUT = "mob_mustinput";
    public static final String FIELD_DEFAULT_VALUE = "mob_defaultvalue";
    protected static final String FIELD_CONTROL_ENTRY_DISPLAY = "mob_fieldcontrolentry_d";
    protected static final String FIELD_CONTROL_ENTRY = "mob_fieldcontrolentry";
    private static final String MAIN_ENTITY_NUMBER = "bos_billtype";
    private static final String COL_NAME_D = "mob_fieldname_d";
    private static final String COL_KEY_D = "mob_fieldkey_d";
    private static final String KEY_ENTITYFIELDKEY = "mob_entityfieldkey_d";
    private static final String COL_DEFAULT_VALUE_D = "mob_defaultvalue_d";
    private static final String COL_MUST_INPUT_D = "mob_mustinput_d";
    private static final String COL_DEFAULT_FUNC_PARAM_D = "mob_defaultfuncparam_d";
    private static final String KEY_LAYOUT_SCHEME = "mob_layoutsolution";
    private static final String CACHE_KEY_LAYOUTS = "mob_cache_layouts";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_BILLFORMID = "billformid";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final List<String> SIMPLE_FIELDS = Arrays.asList("TextField", "BillNoField", "LargeTextField", "MuliLangTextField", "TextAreaField", "IconField", "PictureField", "CheckBoxField", "DecimalField", "AmountField", "QtyField", "IntegerField", "PriceField", "AttachmentCountField", "PrintCountFIeld", "BigIntField");
    private static final List<String> UNSUPPORTED_FIELDS = Arrays.asList("BasedataPropField", "UserAvatarField", "BillTypeField", "CreateDateField", "CreaterField", "ModifierField", "ModifyDateField", "ItemClassField", "ItemClassTypeField", "ParentBasedataField", "FlexField", "FormulaField", "FilterField", "PeriodField", "OrgField", "MulBasedataField", "TimeField", "TimeRangeField");
    private static final List<String> UNSUPPORTED_MUST_INPUT_FIELDS = Arrays.asList("BasedataPropField", "FlexField", "BillTypeField");
    private static final Map<String, String> VISIBLE2STATUS = new HashMap<String, String>();
    private static final Map<String, String> LOCK2STATUS = new HashMap<String, String>();
    private static final Map<String, String> DISPLAY2STORE = new HashMap<String, String>();
    private IFormView view;
    private IDataModel model;

    protected BillTypeControlEntryMobWidget(IFormView view, IDataModel model) {
        this.view = view;
        this.model = model;
    }

    protected void init(String formId, String layoutId, boolean fromDb) {
        this.model.deleteEntryData(FIELD_CONTROL_ENTRY_DISPLAY);
        if (StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)layoutId)) {
            return;
        }
        Map ctrlInfos = FieldApInfoUtils.getFullControlInfos((String)layoutId, (String)formId, (boolean)true);
        if (ctrlInfos.isEmpty()) {
            return;
        }
        Object pkId = ((BillShowParameter)this.view.getFormShowParameter()).getPkId();
        if (pkId == null || pkId.equals(0L)) {
            pkId = this.model.getDataEntity().getPkValue();
        }
        this.initDisplayEntry(ctrlInfos, fromDb, pkId);
        this.lockDisplayFields(ctrlInfos);
        this.view.updateView(FIELD_CONTROL_ENTRY_DISPLAY);
    }

    protected String bindLayout(String formId) {
        Optional<Map> op;
        String PC_STR = "isPC";
        List pcLayouts = BillTypeServiceHelper.getBillLayoutByFormId((String)formId);
        List layouts = BillTypeServiceHelper.getMobileBillLayoutByFormId((String)formId);
        if (!CollectionUtils.isEmpty((Collection)pcLayouts)) {
            pcLayouts.remove(0);
            for (Map item2 : pcLayouts) {
                item2.put(PC_STR, true);
            }
            layouts.addAll(pcLayouts);
        }
        ComboEdit edit = (ComboEdit)this.view.getControl(KEY_LAYOUT_SCHEME);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(layouts.size());
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9", (String)"BillTypeControlEntryMobWidget_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])), "0"));
        for (int i = 0; i < layouts.size(); ++i) {
            boolean isPC;
            String id;
            Map item3 = (Map)layouts.get(i);
            String string = id = item3.get("id") == null ? "" : (String)item3.get("id");
            if (i == 0) {
                item3.put(PC_STR, true);
            }
            boolean bl = isPC = item3.get(PC_STR) == null ? false : (Boolean)item3.get(PC_STR);
            if (isPC) {
                FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
                if (formMeta == null || !(formMeta.getRootAp() instanceof BillFormAp) || ((BillFormAp)formMeta.getRootAp()).getMobMeta() == null) continue;
                if (StringUtils.isNotBlank((Object)((BillFormAp)formMeta.getRootAp()).getMobMeta().getName())) {
                    item3.put("name", ((BillFormAp)formMeta.getRootAp()).getMobMeta().getName());
                }
            }
            ILocaleString v = (ILocaleString)item3.get("name");
            items.add(new ComboItem(new LocaleString(v.getLocaleValue()), id));
        }
        this.view.getPageCache().put(CACHE_KEY_LAYOUTS, SerializationUtils.toJsonString((Object)layouts));
        edit.setComboItems(items);
        Object val = this.view.getModel().getValue(KEY_LAYOUT_SCHEME);
        if (StringUtils.isBlank((Object)val) || "null".equalsIgnoreCase(String.valueOf(val))) {
            this.view.getModel().setValue(KEY_LAYOUT_SCHEME, (Object)"0");
        }
        return (op = layouts.stream().filter(item -> item.get("id").equals(this.view.getModel().getValue(KEY_LAYOUT_SCHEME))).findFirst()).isPresent() ? (String)op.get().get(KEY_NUMBER) : "";
    }

    private void initDisplayEntry(Map<String, BillTypeControlInfo> ctlInfos, boolean fromDb, Object pkId) {
        this.model.beginInit();
        this.model.batchCreateNewEntryRow(FIELD_CONTROL_ENTRY_DISPLAY, ctlInfos.size());
        DynamicObjectCollection list = fromDb ? this.loadFromDb(pkId) : this.model.getEntryEntity(FIELD_CONTROL_ENTRY);
        List<DifferentialControlInfo> diffInfos = this.resolveDifferentialControlInfos(ctlInfos, list);
        HashMap<String, DifferentialControlInfo> diffInfoMap = new HashMap<String, DifferentialControlInfo>(diffInfos.size());
        for (DifferentialControlInfo info : diffInfos) {
            diffInfoMap.put(info.getFieldKey(), info);
        }
        int index = 0;
        for (Map.Entry<String, BillTypeControlInfo> entry : ctlInfos.entrySet()) {
            boolean flag;
            BillTypeControlInfo ctrlInfo = entry.getValue();
            this.model.setValue(KEY_ENTITYFIELDKEY, (Object)ctrlInfo.getEntityFieldKey(), index);
            this.model.setValue(COL_KEY_D, (Object)ctrlInfo.getFieldKey(), index);
            this.model.setValue(COL_NAME_D, (Object)ctrlInfo.getFieldName(), index);
            this.model.setValue(COL_DEFAULT_FUNC_PARAM_D, (Object)ctrlInfo.getFieldType(), index);
            DifferentialControlInfo diffInfo = (DifferentialControlInfo)diffInfoMap.get(ctrlInfo.getFieldKey());
            if (null != diffInfo && StringUtils.isNotBlank((CharSequence)diffInfo.getDefaultValue())) {
                this.model.setValue(COL_DEFAULT_VALUE_D, (Object)diffInfo.getDefaultValue(), index);
            }
            boolean mustInput = diffInfo != null ? diffInfo.isMustInput().booleanValue() : ctrlInfo.isMustInput();
            this.model.setValue(COL_MUST_INPUT_D, (Object)mustInput, index);
            for (Map.Entry<String, String> lockEntry : LOCK2STATUS.entrySet()) {
                flag = diffInfo != null ? diffInfo.isLock(lockEntry.getValue()).booleanValue() : ctrlInfo.isLock(lockEntry.getValue());
                this.model.setValue(lockEntry.getKey(), (Object)flag, index);
            }
            for (Map.Entry<String, String> visibleEntry : VISIBLE2STATUS.entrySet()) {
                flag = diffInfo != null ? diffInfo.isVisible(visibleEntry.getValue()).booleanValue() : ctrlInfo.isVisible(visibleEntry.getValue());
                this.model.setValue(visibleEntry.getKey(), (Object)flag, index);
            }
            ++index;
        }
        this.model.endInit();
    }

    protected void lockDisplayFields() {
        String formId = this.getCurrentFormId();
        String layoutId = this.getCurrentLayoutFormId();
        if (StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)layoutId)) {
            return;
        }
        Map ctrlInfos = FieldApInfoUtils.getFullControlInfos((String)(layoutId = StringUtils.isBlank((CharSequence)layoutId) ? formId : layoutId), (String)formId, (boolean)true);
        if (ctrlInfos.isEmpty()) {
            return;
        }
        this.lockDisplayFields(ctrlInfos);
    }

    protected void lockDisplayFields(Map<String, BillTypeControlInfo> ctlInfos) {
        int i = 0;
        for (Map.Entry<String, BillTypeControlInfo> entry : ctlInfos.entrySet()) {
            BillTypeControlInfo ctlInfo = entry.getValue();
            int rowIndex = i++;
            this.lockCell(COL_KEY_D, rowIndex);
            this.lockCell(COL_NAME_D, rowIndex);
            if (UNSUPPORTED_FIELDS.contains(ctlInfo.getFieldType())) {
                this.lockCell(COL_DEFAULT_VALUE_D, rowIndex);
            }
            if (ctlInfo.isMustInput() || UNSUPPORTED_MUST_INPUT_FIELDS.contains(ctlInfo.getFieldType())) {
                this.lockCell(COL_MUST_INPUT_D, rowIndex);
            }
            VISIBLE2STATUS.forEach((statusKey, status) -> {
                if (!ctlInfo.isVisible(status)) {
                    this.lockCell((String)statusKey, rowIndex);
                }
            });
            LOCK2STATUS.forEach((statusKey, status) -> {
                if (ctlInfo.isLock(status)) {
                    this.lockCell((String)statusKey, rowIndex);
                }
            });
        }
    }

    private void lockCell(String key, int row) {
        FieldEdit cellEdit = (FieldEdit)this.view.getControl(key);
        cellEdit.setEntryKey(FIELD_CONTROL_ENTRY_DISPLAY);
        cellEdit.setEnable("", false, row);
    }

    protected void changeLayout(String formId, String layoutId) {
        this.model.deleteEntryData(FIELD_CONTROL_ENTRY);
        this.init(formId, layoutId, false);
    }

    private DynamicObjectCollection loadFromDb(Object id) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)MAIN_ENTITY_NUMBER);
        DynamicObject[] arr = BusinessDataReader.load((Object[])new Object[]{id}, (DynamicObjectType)mainEntityType, (Boolean)true);
        if (null == arr || arr.length == 0) {
            return null;
        }
        DynamicObject layoutConfig = arr[0];
        return layoutConfig.getDynamicObjectCollection(FIELD_CONTROL_ENTRY);
    }

    private List<DifferentialControlInfo> resolveDifferentialControlInfos(Map<String, BillTypeControlInfo> fullInfo, DynamicObjectCollection storeInfos) {
        ArrayList<DifferentialControlInfo> diffInfos = new ArrayList<DifferentialControlInfo>();
        HashMap<String, DifferentialControlInfo> finishedFields = new HashMap<String, DifferentialControlInfo>();
        if (null == storeInfos || storeInfos.isEmpty()) {
            return diffInfos;
        }
        for (DynamicObject storeInfo : storeInfos) {
            String fieldKey = storeInfo.getString(FIELD_KEY);
            BillTypeControlInfo fieldInfo = fullInfo.get(fieldKey);
            if (fieldInfo == null) continue;
            DifferentialControlInfo differentialControlInfo = (DifferentialControlInfo)finishedFields.get(fieldKey);
            if (differentialControlInfo == null) {
                differentialControlInfo = new DifferentialControlInfo();
                diffInfos.add(differentialControlInfo);
                finishedFields.put(fieldKey, differentialControlInfo);
            }
            differentialControlInfo.setFieldKey(fieldKey);
            differentialControlInfo.setFieldId(fieldInfo.getFieldId());
            differentialControlInfo.setEntityFieldKey(fieldInfo.getEntityFieldKey());
            if (!Objects.equals(storeInfo.getBoolean(FIELD_MUST_INPUT), fieldInfo.isMustInput())) {
                differentialControlInfo.setMustInput(true);
            } else {
                differentialControlInfo.setMustInput(fieldInfo.isMustInput());
            }
            for (Map.Entry<String, String> entry : VISIBLE2STATUS.entrySet()) {
                if (!Objects.equals(storeInfo.get(DISPLAY2STORE.get(entry.getKey())), fieldInfo.isVisible(entry.getValue()))) {
                    differentialControlInfo.addVisible(entry.getValue(), false);
                    continue;
                }
                differentialControlInfo.addVisible(entry.getValue(), fieldInfo.isVisible(entry.getValue()));
            }
            for (Map.Entry<String, String> entry : LOCK2STATUS.entrySet()) {
                if (!Objects.equals(storeInfo.get(DISPLAY2STORE.get(entry.getKey())), fieldInfo.isLock(entry.getValue()))) {
                    differentialControlInfo.addLock(entry.getValue(), true);
                    continue;
                }
                differentialControlInfo.addLock(entry.getValue(), fieldInfo.isLock(entry.getValue()));
            }
            if (!StringUtils.isNotBlank((CharSequence)storeInfo.getString(FIELD_DEFAULT_VALUE))) continue;
            differentialControlInfo.setDefaultValue(storeInfo.getString(FIELD_DEFAULT_VALUE));
        }
        return diffInfos;
    }

    private String getCurrentFormId() {
        DynamicObject curBill = (DynamicObject)this.model.getValue(KEY_BILLFORMID);
        if (curBill == null) {
            return null;
        }
        RefEntityType rdType = (RefEntityType)curBill.getDataEntityType();
        return curBill.get(rdType.getNumberProperty()).toString();
    }

    private String getCurrentLayoutFormId() {
        String id = (String)this.model.getValue(KEY_LAYOUT_SCHEME);
        if (StringUtils.isBlank((CharSequence)id) || "0".equals(id)) {
            return null;
        }
        String layoutCache = this.view.getPageCache().get(CACHE_KEY_LAYOUTS);
        List layouts = SerializationUtils.fromJsonStringToList((String)layoutCache, Map.class);
        Optional<Map> op = layouts.stream().filter(item -> item.get("id").equals(id)).findFirst();
        return op.isPresent() ? (String)op.get().get(KEY_NUMBER) : null;
    }

    protected void buildDifferentialControlInfo() {
        String formId = this.getCurrentFormId();
        String layoutId = this.getCurrentLayoutFormId();
        this.buildDifferentialControlInfo(formId, layoutId);
    }

    protected void buildDifferentialControlInfo(String formId, String layoutId) {
        int i;
        if (StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)layoutId)) {
            return;
        }
        Map ctrlInfos = FieldApInfoUtils.getFullControlInfos((String)layoutId, (String)formId, (boolean)true);
        DynamicObjectCollection displayEntry = this.model.getEntryEntity(FIELD_CONTROL_ENTRY_DISPLAY);
        HashSet<Integer> changeFields = new HashSet<Integer>();
        block0: for (i = 0; i < displayEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)displayEntry.get(i);
            String fieldKey = row.getString(COL_KEY_D);
            String defaultValue = row.getString(COL_DEFAULT_VALUE_D);
            Boolean mustInput = row.getBoolean(COL_MUST_INPUT_D);
            BillTypeControlInfo ctrlInfo = (BillTypeControlInfo)ctrlInfos.get(fieldKey);
            if (StringUtils.isNotBlank((CharSequence)defaultValue) || !Objects.equals(mustInput, ctrlInfo.isMustInput())) {
                changeFields.add(i);
                continue;
            }
            for (Map.Entry<String, String> entry : VISIBLE2STATUS.entrySet()) {
                if (Objects.equals(row.get(entry.getKey()), ctrlInfo.isVisible(entry.getValue()))) continue;
                changeFields.add(i);
                break;
            }
            for (Map.Entry<String, String> entry : LOCK2STATUS.entrySet()) {
                if (Objects.equals(row.get(entry.getKey()), ctrlInfo.isLock(entry.getValue()))) continue;
                changeFields.add(i);
                continue block0;
            }
        }
        this.model.deleteEntryData(FIELD_CONTROL_ENTRY);
        if (changeFields.isEmpty()) {
            return;
        }
        this.model.batchCreateNewEntryRow(FIELD_CONTROL_ENTRY, changeFields.size());
        i = 0;
        Iterator iterator = changeFields.iterator();
        while (iterator.hasNext()) {
            int changeFieldIdx = (Integer)iterator.next();
            DynamicObject displayRowObj = (DynamicObject)displayEntry.get(changeFieldIdx);
            for (Map.Entry<String, String> entry : DISPLAY2STORE.entrySet()) {
                this.model.setValue(entry.getValue(), displayRowObj.get(entry.getKey()), i);
            }
            ++i;
        }
    }

    protected void showDefaultValueEditForm(String formId, CloseCallBack callback) {
        formId = this.getCurrentFormId();
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        int currentRow = this.model.getEntryCurrentRowIndex(FIELD_CONTROL_ENTRY_DISPLAY);
        String fieldType = (String)this.model.getValue(COL_DEFAULT_FUNC_PARAM_D, currentRow);
        if (StringUtils.isBlank((CharSequence)fieldType) || SIMPLE_FIELDS.contains(fieldType) || UNSUPPORTED_FIELDS.contains(fieldType)) {
            return;
        }
        String fieldKey = (String)this.model.getValue(COL_KEY_D, currentRow);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_defaultvalueedit");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> mockContext = new HashMap<String, String>();
        mockContext.put("FormId", formId);
        mockContext.put("_Type_", fieldType);
        mockContext.put("Key", fieldKey);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        IDataEntityProperty prop = mainEntityType.findProperty(fieldKey);
        if (prop instanceof MulBasedataProp) {
            mockContext.put("BaseEntityId", ((MulBasedataProp)prop).getBaseEntityId());
        } else if (prop instanceof BasedataProp) {
            String id = MetadataDao.getIdByNumber((String)((BasedataProp)prop).getBaseEntityId(), (MetaCategory)MetaCategory.Entity);
            mockContext.put("BaseEntityId", id);
        }
        if (prop instanceof AssistantProp) {
            mockContext.put("AsstTypeId", ((AssistantProp)prop).getAsstTypeId());
        }
        parameter.setCustomParam("context", Collections.singletonList(mockContext));
        parameter.setCustomParam("formLayoutScheme", (Object)"true");
        parameter.setCloseCallBack(callback);
        this.view.showForm(parameter);
    }

    protected void postBackDefaultValue(Object value) {
        int currentRow = this.model.getEntryCurrentRowIndex(FIELD_CONTROL_ENTRY_DISPLAY);
        this.model.setValue(COL_DEFAULT_VALUE_D, value, currentRow);
    }

    protected void syncPCSetting() {
        DynamicObjectCollection displayEntry = this.model.getEntryEntity("fieldcontrolentry_d");
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(displayEntry.size());
        for (DynamicObject object : displayEntry) {
            map.put(object.get("entityfieldkey_d"), object);
        }
        String formId = this.getCurrentFormId();
        String layoutId = this.getCurrentLayoutFormId();
        if (StringUtils.isBlank((CharSequence)layoutId)) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u79fb\u52a8\u7aef\u5e03\u5c40\u3002", (String)"BillTypeControlEntryMobWidget_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        Map ctrlInfos = FieldApInfoUtils.getFullControlInfos((String)layoutId, (String)formId, (boolean)true);
        if (ctrlInfos.isEmpty()) {
            return;
        }
        DynamicObjectCollection mobDisplayEntry = this.model.getEntryEntity(FIELD_CONTROL_ENTRY_DISPLAY);
        for (DynamicObject object : mobDisplayEntry) {
            int index = object.getInt("seq") - 1;
            Object mob_entityfieldkey_d = object.get(KEY_ENTITYFIELDKEY);
            DynamicObject dynamicObject = (DynamicObject)map.get(mob_entityfieldkey_d);
            if (dynamicObject == null) continue;
            BillTypeControlInfo ctlInfo = (BillTypeControlInfo)ctrlInfos.get(mob_entityfieldkey_d);
            if (ctlInfo.getDefValueType() != 0) {
                this.model.setValue(COL_DEFAULT_VALUE_D, dynamicObject.get(COL_DEFAULT_VALUE_D.replaceAll("mob_", "")), index);
            }
            if (!ctlInfo.isMustInput() || ctlInfo.getMustInputType() == 0) {
                this.model.setValue(COL_MUST_INPUT_D, dynamicObject.get(COL_MUST_INPUT_D.replaceAll("mob_", "")), index);
            }
            for (Map.Entry<String, String> lockEntry : LOCK2STATUS.entrySet()) {
                if (ctlInfo.isLock(lockEntry.getValue())) continue;
                this.model.setValue(lockEntry.getKey(), dynamicObject.get(lockEntry.getKey().replaceAll("mob_", "")), index);
            }
            for (Map.Entry<String, String> visibleEntry : VISIBLE2STATUS.entrySet()) {
                if (!ctlInfo.isVisible(visibleEntry.getValue())) continue;
                this.model.setValue(visibleEntry.getKey(), dynamicObject.get(visibleEntry.getKey().replaceAll("mob_", "")), index);
            }
        }
    }

    static {
        VISIBLE2STATUS.put("mob_vinit_d", "init");
        VISIBLE2STATUS.put("mob_vnew_d", "new");
        VISIBLE2STATUS.put("mob_vedit_d", "edit");
        VISIBLE2STATUS.put("mob_vview_d", "view");
        VISIBLE2STATUS.put("mob_vsubmit_d", "submit");
        VISIBLE2STATUS.put("mob_vaudit_d", "audit");
        LOCK2STATUS.put("mob_enabled_d", "new");
        LOCK2STATUS.put("mob_editenabled_d", "edit");
        LOCK2STATUS.put("mob_submitenabled_d", "submit");
        LOCK2STATUS.put("mob_auditenabled_d", "audit");
        DISPLAY2STORE.put(COL_KEY_D, FIELD_KEY);
        DISPLAY2STORE.put(KEY_ENTITYFIELDKEY, "mob_entityfieldkey");
        DISPLAY2STORE.put("mob_vinit_d", "mob_vinit");
        DISPLAY2STORE.put("mob_vnew_d", "mob_vnew");
        DISPLAY2STORE.put("mob_vedit_d", "mob_vedit");
        DISPLAY2STORE.put("mob_vview_d", "mob_vview");
        DISPLAY2STORE.put("mob_vsubmit_d", "mob_vsubmit");
        DISPLAY2STORE.put("mob_vaudit_d", "mob_vaudit");
        DISPLAY2STORE.put("mob_enabled_d", "mob_enabled");
        DISPLAY2STORE.put("mob_editenabled_d", "mob_editenabled");
        DISPLAY2STORE.put("mob_submitenabled_d", "mob_submitenabled");
        DISPLAY2STORE.put("mob_auditenabled_d", "mob_auditenabled");
        DISPLAY2STORE.put(COL_MUST_INPUT_D, FIELD_MUST_INPUT);
        DISPLAY2STORE.put(COL_DEFAULT_VALUE_D, FIELD_DEFAULT_VALUE);
    }
}

