/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.billtype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IParameterModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.parameter.ParameterShowParameter;

public class BillTypeEdit
extends AbstractBillPlugIn
implements ICloseCallBack {
    private static final String VINIT = "vinit";
    private static final String VNEW = "vnew";
    private static final String VEDIT = "vedit";
    private static final String VVIEW = "vview";
    private static final String VSUBMIT = "vsubmit";
    private static final String VAUDIT = "vaudit";
    private static final String EDITENABLED = "editenabled";
    private static final String ENABLED = "enabled";
    private static final String MUSTINPUT = "mustinput";
    private static final String AUDITENABLED = "auditenabled";
    private static final String SUBMITENABLED = "submitenabled";
    private static final String SUBMIT = "submit";
    private static final String AUDIT = "audit";
    private static final String PARAMETER_PAGE_ID = "parameterPageId";
    private static final Log log = LogFactory.getLog(BillTypeEdit.class);
    private static final String KEY_DEFAULTVALUE = "defaultvalue";
    private static final String KEY_DEFAULTFUNCPARAM = "defaultfuncparam";
    private static final String FORMID_BOS_BILLTYPE = "bos_billtype";
    private static final String KEY_FIELDKEY = "fieldkey";
    private static final String KEY_ISDELETED = "isdeleted";
    private static final String LOCK_CELL_INFO = "billinitsetting";
    private static final String KEY_FIELD_NAME = "fieldname";
    private static final String KEY_BILLFORMID = "billformid";
    private static final String KEY_FIELD_CONTROL_ENTRY = "fieldcontrolentry";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private String DELETED_FIELD = ResManager.loadKDString((String)"\u5e9f\u5f03", (String)"BillTypeEdit_0", (String)"bos-form-business", (Object[])new Object[0]);
    private static final List<String> NEED_LOCK_CELL_WHEN_FALSE = Arrays.asList("vinit", "vnew", "vedit", "vview", "vsubmit", "vaudit");
    private static final List<String> NEED_LOCK_CELL_WHEN_TRUE = Arrays.asList("mustinput", "enabled", "editenabled", "submitenabled", "auditenabled");
    private static final List<String> SIMPLE_FIELDS = Arrays.asList("TextField", "BillNoField", "LargeTextField", "MuliLangTextField", "TextAreaField", "IconField", "PictureField", "DecimalField", "AmountField", "QtyField", "IntegerField", "PriceField", "AttachmentCountField", "PrintCountFIeld", "BigIntField");
    private static final List<String> UNSUPPORT_FIELDS = Arrays.asList("BasedataPropField", "UserAvatarField", "DateRangeField", "BillTypeField", "CreateDateField", "CreaterField", "ModifierField", "ModifyDateField", "ItemClassField", "ItemClassTypeField", "ParentBasedataField", "FlexField", "FormulaField", "FilterField", "PeriodField", "RadioField");
    private EntryCellLocker cellLocker = new EntryCellLocker();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_DEFAULTVALUE});
    }

    public void initialize() {
        log.info(this.getView().getFormShowParameter().toString());
    }

    public void click(EventObject evt) {
        String btnKey = ((Control)evt.getSource()).getKey();
        if (KEY_DEFAULTVALUE.equals(btnKey)) {
            int row = this.getModel().getEntryCurrentRowIndex(KEY_FIELD_CONTROL_ENTRY);
            String fieldType = (String)this.getModel().getValue(KEY_DEFAULTFUNCPARAM, row);
            if (!SIMPLE_FIELDS.contains(fieldType) && !UNSUPPORT_FIELDS.contains(fieldType)) {
                FormShowParameter parameter = this.buildFormShowParameter(row, fieldType);
                this.getView().showForm(parameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        if (KEY_DEFAULTVALUE.equals(closedCallBackEvent.getActionId()) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            Map data = (Map)returnData;
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_FIELD_CONTROL_ENTRY);
            this.getModel().setValue(KEY_DEFAULTVALUE, data.get("value"), entryCurrentRowIndex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Object billformid = baseShowParameter.getCustomParam(KEY_BILLFORMID);
        if (billformid != null && baseShowParameter.getBillStatus() == BillOperationStatus.ADDNEW) {
            this.getModel().setValue(KEY_BILLFORMID, billformid);
            this.refreshViewWhenBillChange(billformid.toString());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getValue(KEY_BILLFORMID) != null) {
            this.updatePrintTemplateComboItem();
            this.cellLocker.lockCell(this.getModel().getValue(LOCK_CELL_INFO).toString());
            this.showParameterSettingTab();
        }
    }

    public void afterLoadData(EventObject e) {
        int recordStartIndex;
        super.afterLoadData(e);
        DynamicObject billObj = (DynamicObject)this.getModel().getValue(KEY_BILLFORMID);
        String billNumber = billObj.getPkValue().toString();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)billNumber);
        Map allFields = dt.getAllFields();
        ArrayList<String> modelFldCtl = new ArrayList<String>();
        for (int i = 0; i < this.getModel().getEntryRowCount(KEY_FIELD_CONTROL_ENTRY); ++i) {
            if (((Boolean)this.getModel().getValue(KEY_ISDELETED, i)).booleanValue()) continue;
            modelFldCtl.add((String)this.getModel().getValue(KEY_FIELDKEY, i));
        }
        HashSet<String> tmpSet = new HashSet<String>();
        tmpSet.addAll(modelFldCtl);
        if (!allFields.keySet().equals(tmpSet) && (recordStartIndex = this.correctFieldControlsEntryInfo(allFields, modelFldCtl, billNumber)) != -1) {
            this.getModel().setValue(LOCK_CELL_INFO, (Object)this.cellLocker.getLockCellInfos(0));
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate source = (AbstractOperate)evt.getSource();
        if ("save".equals(source.getOperateKey()) || "saveandnew".equals(source.getOperateKey()) || SUBMIT.equals(source.getOperateKey())) {
            Boolean isDefault = (Boolean)this.getModel().getValue("isdefault");
            if (isDefault.booleanValue()) {
                DynamicObject billform = (DynamicObject)this.getModel().getValue(KEY_BILLFORMID);
                Object pkValue = billform.getPkValue();
                QFilter[] filters = new QFilter[]{new QFilter(KEY_BILLFORMID, "=", pkValue), new QFilter("isdefault", "=", (Object)Boolean.TRUE)};
                DynamicObjectCollection col = ORM.create().query(FORMID_BOS_BILLTYPE, "id", filters);
                if (!col.isEmpty()) {
                    Object modelPKId = this.getModel().getDataEntity().getPkValue();
                    for (DynamicObject billtypeObj : col) {
                        if (Objects.equals(billtypeObj.get("id"), modelPKId)) continue;
                        evt.setCancel(true);
                        evt.setCancelMessage(ResManager.loadKDString((String)"\u5bf9\u4e00\u5f20\u5355\u636e\u800c\u8a00\uff0c\u4e0d\u80fd\u5b58\u5728\u4e24\u4e2a\u9ed8\u8ba4\u5355\u636e\u7c7b\u578b,\u672c\u6b21\u64cd\u4f5c\u53d6\u6d88", (String)"BillTypeEdit_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e00\u5f20\u5355\u636e\u800c\u8a00\uff0c\u4e0d\u80fd\u5b58\u5728\u4e24\u4e2a\u9ed8\u8ba4\u5355\u636e\u7c7b\u578b,\u672c\u6b21\u64cd\u4f5c\u53d6\u6d88", (String)"BillTypeEdit_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), MessageBoxOptions.YesNo);
                    }
                }
            }
        } else if ("new".equals(source.getOperateKey())) {
            this.getView().getFormShowParameter().setCustomParam(KEY_BILLFORMID, null);
            this.getView().cacheFormShowParameter();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if ("save".equals(operateKey) || SUBMIT.equals(operateKey)) {
            String parameterPageId = this.getPageCache().get(PARAMETER_PAGE_ID);
            if (StringUtils.isNotBlank((CharSequence)parameterPageId)) {
                FormView parameterView = (FormView)this.getView().getView(parameterPageId);
                IParameterModel parameterModel = (IParameterModel)parameterView.getModel();
                parameterModel.setBindFormId(((DynamicObject)this.getModel().getValue(KEY_BILLFORMID)).getPkValue().toString());
                parameterModel.setBindBillTypeId((Long)this.getModel().getDataEntity().getPkValue());
                parameterView.invokeOperation("parametersave");
                this.getPageCache().remove(PARAMETER_PAGE_ID);
            }
            if (SUBMIT.equals(operateKey)) {
                billShowParameter.setBillStatus(BillOperationStatus.SUBMIT);
            }
        } else if (AUDIT.equals(operateKey)) {
            billShowParameter.setBillStatus(BillOperationStatus.AUDIT);
            this.lockParameterView(true);
        } else {
            this.lockParameterView(false);
        }
        this.getView().updateView();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (KEY_BILLFORMID.equals(e.getProperty().getName())) {
            Object billFormId = e.getChangeSet()[0].getNewValue();
            DynamicObject billObj = (DynamicObject)billFormId;
            RefEntityType rdType = (RefEntityType)billObj.getDataEntityType();
            String billNumber = billObj.get(rdType.getNumberProperty()).toString();
            this.refreshViewWhenBillChange(billNumber);
            this.updatePrintTemplateComboItem();
            this.cellLocker.lockCell(this.getModel().getValue(LOCK_CELL_INFO).toString());
            this.showParameterSettingTab();
        }
    }

    private void lockParameterView(boolean isLock) {
        String parameterPageId = this.getPageCache().get(PARAMETER_PAGE_ID);
        if (StringUtils.isNotBlank((CharSequence)parameterPageId)) {
            IFormView parameterView = this.getView().getView(parameterPageId);
            if (parameterView == null) {
                return;
            }
            if (isLock) {
                parameterView.setStatus(OperationStatus.VIEW);
            } else {
                parameterView.setStatus(OperationStatus.EDIT);
            }
            this.getView().sendFormAction(parameterView);
        }
    }

    private void showParameterSettingTab() {
        DynamicObject billObj = (DynamicObject)this.getModel().getValue(KEY_BILLFORMID);
        String formId = billObj.getPkValue().toString();
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)formId);
        String billTypePara = dt.getBillTypePara();
        if (StringUtils.isNotBlank((CharSequence)billTypePara) && StringUtils.isBlank((CharSequence)this.getPageCache().get(PARAMETER_PAGE_ID))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"parametercontainor"});
            ParameterShowParameter parameterShowParam = new ParameterShowParameter();
            parameterShowParam.getOpenStyle().setShowType(ShowType.InContainer);
            parameterShowParam.getOpenStyle().setTargetKey("parametercontainor");
            parameterShowParam.setFormId(billTypePara);
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            if (pkValue != null && !pkValue.equals(0L)) {
                parameterShowParam.setCustomParam("bindformid", (Object)formId);
                parameterShowParam.setCustomParam("bindbilltypeid", this.getModel().getDataEntity().getPkValue());
                BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
                if (formShowParameter.getBillStatus() == BillOperationStatus.SUBMIT || formShowParameter.getBillStatus() == BillOperationStatus.AUDIT) {
                    parameterShowParam.setStatus(OperationStatus.VIEW);
                }
            }
            this.getView().showForm((FormShowParameter)parameterShowParam);
            this.getPageCache().put(PARAMETER_PAGE_ID, parameterShowParam.getPageId());
        }
    }

    private void refreshViewWhenBillChange(String billFormId) {
        if (StringUtils.isNotBlank((CharSequence)billFormId)) {
            if (this.getModel().getEntryRowCount(KEY_FIELD_CONTROL_ENTRY) > 0) {
                this.getModel().deleteEntryData(KEY_FIELD_CONTROL_ENTRY);
            }
            this.initFieldControlEntry(billFormId);
            this.getModel().setValue("defprinttemplate", null);
            this.getModel().setValue(LOCK_CELL_INFO, (Object)this.cellLocker.getLockCellInfos(0));
        }
    }

    private FormShowParameter buildFormShowParameter(int row, String fieldType) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_defaultvalueedit");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> mockContext = new HashMap<String, Object>();
        mockContext.put("_Type_", fieldType);
        mockContext.put("Key", this.getModel().getValue(KEY_FIELDKEY, row));
        DynamicObject bizObj = (DynamicObject)this.getModel().getValue(KEY_BILLFORMID);
        String fieldKey = this.getModel().getValue(KEY_FIELDKEY, row).toString();
        mockContext.put("FormId", bizObj.getPkValue());
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)bizObj.getPkValue().toString());
        IDataEntityProperty prop = (IDataEntityProperty)dt.getAllFields().get(fieldKey);
        if (prop instanceof MulBasedataProp) {
            mockContext.put("BaseEntityId", ((MulBasedataProp)prop).getBaseEntityId());
        } else if (prop instanceof BasedataProp) {
            String id = MetadataDao.getIdByNumber((String)((BasedataProp)prop).getBaseEntityId(), (MetaCategory)MetaCategory.Entity);
            mockContext.put("BaseEntityId", id);
        }
        if (prop instanceof AssistantProp) {
            mockContext.put("AsstTypeId", ((AssistantProp)prop).getAsstTypeId());
        }
        parameter.setCustomParam("context", Collections.singletonList(mockContext));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_DEFAULTVALUE));
        return parameter;
    }

    private int correctFieldControlsEntryInfo(Map<String, IDataEntityProperty> metaFields, List<String> modelFldCtl, String billNumber) {
        int recordStartIndex = -1;
        for (int i = 0; i < modelFldCtl.size(); ++i) {
            String fieldKey = modelFldCtl.get(i);
            if (metaFields.containsKey(fieldKey)) continue;
            String name = this.getModel().getValue(KEY_FIELD_NAME, i).toString();
            this.getModel().setValue(KEY_FIELD_NAME, (Object)String.format("%s(%s)", name, this.DELETED_FIELD), i);
            this.getModel().setValue(KEY_ISDELETED, (Object)true, i);
        }
        HashMap<String, IDataEntityProperty> toAddFields = new HashMap<String, IDataEntityProperty>();
        Set<Map.Entry<String, IDataEntityProperty>> entrySet = metaFields.entrySet();
        for (Map.Entry<String, IDataEntityProperty> prop : entrySet) {
            if (modelFldCtl.contains(prop.getKey())) continue;
            toAddFields.put(prop.getKey(), prop.getValue());
        }
        if (!toAddFields.isEmpty()) {
            int entryRowCount;
            Map<String, FieldEntityInfo> toAddFieldsInfo = FieldPropertyProvider.getBillFieldsEntityInfo(toAddFields, this.getCurrentFormId());
            Map<String, List<List<Boolean>>> billFieldsLockAndVisibleStatus = FieldPropertyProvider.getLockAndVisible(billNumber);
            recordStartIndex = entryRowCount = this.getModel().getEntryRowCount(KEY_FIELD_CONTROL_ENTRY);
            int size = toAddFieldsInfo.size();
            this.getModel().batchCreateNewEntryRow(KEY_FIELD_CONTROL_ENTRY, size);
            for (Map.Entry<String, FieldEntityInfo> toAddFieldInfo : toAddFieldsInfo.entrySet()) {
                this.setFieldControlEntryRow(billFieldsLockAndVisibleStatus, toAddFieldInfo, recordStartIndex++);
            }
        }
        return recordStartIndex;
    }

    private void updatePrintTemplateComboItem() {
        String billNumber = this.getCurrentFormId();
        ComboEdit combo = (ComboEdit)this.getControl("defprinttemplate");
        ArrayList<ComboItem> templateList = new ArrayList<ComboItem>(10);
        List<Map<String, String>> templates = this.getTemplatesByNumber(billNumber);
        for (Map<String, String> template : templates) {
            templateList.add(new ComboItem(new LocaleString(template.get("tempalteName")), template.get("templateNumber")));
        }
        combo.setComboItems(templateList);
    }

    private String getCurrentFormId() {
        DynamicObject curBill = (DynamicObject)this.getModel().getValue(KEY_BILLFORMID);
        if (curBill == null) {
            return null;
        }
        RefEntityType rdType = (RefEntityType)curBill.getDataEntityType();
        return curBill.get(rdType.getNumberProperty()).toString();
    }

    private List<Map<String, String>> getTemplatesByNumber(String billNumber) {
        ORM orm = ORM.create();
        QFilter[] qFilters = new QFilter[]{new QFilter("basedatafield.number", "=", (Object)billNumber), new QFilter("modeltype", "=", (Object)"PrintModel")};
        DynamicObjectCollection templates = orm.query("bos_formmeta", qFilters);
        ArrayList<Map<String, String>> templateDatas = new ArrayList<Map<String, String>>();
        templates.forEach(template -> {
            HashMap<String, String> singleTemplate = new HashMap<String, String>();
            singleTemplate.put("templateNumber", template.getString("number"));
            String name = ((ILocaleString)template.get("name")).getLocaleValue();
            singleTemplate.put("tempalteName", name);
            templateDatas.add(singleTemplate);
        });
        return templateDatas;
    }

    private void initFieldControlEntry(String billNumber) {
        Map<String, FieldEntityInfo> billFieldsEntityInfo = FieldPropertyProvider.getNameAndMustInput(billNumber);
        Map<String, List<List<Boolean>>> billFieldsLockAndVisibleStatus = FieldPropertyProvider.getLockAndVisible(billNumber);
        int size = billFieldsEntityInfo.size();
        this.getModel().batchCreateNewEntryRow(KEY_FIELD_CONTROL_ENTRY, size);
        int i = 0;
        for (Map.Entry<String, FieldEntityInfo> fieldEntity : billFieldsEntityInfo.entrySet()) {
            this.setFieldControlEntryRow(billFieldsLockAndVisibleStatus, fieldEntity, i++);
        }
    }

    private void setFieldControlEntryRow(Map<String, List<List<Boolean>>> billFieldsLockAndVisibleStatus, Map.Entry<String, FieldEntityInfo> fieldEntity, int i) {
        IDataModel model = this.getModel();
        FieldEntityInfo fieldInfo = fieldEntity.getValue();
        List<List<Boolean>> lockAndVisibleStatus = billFieldsLockAndVisibleStatus.get(fieldEntity.getKey());
        if (lockAndVisibleStatus == null) {
            return;
        }
        List<Boolean> lockStatus = lockAndVisibleStatus.get(0);
        List<Boolean> visibleStatus = lockAndVisibleStatus.get(1);
        model.setValue(KEY_FIELDKEY, (Object)fieldInfo.fieldKey, i);
        model.setValue(KEY_FIELD_NAME, (Object)fieldInfo.disPlayName, i);
        model.setValue(KEY_DEFAULTFUNCPARAM, (Object)fieldInfo.getFieldType(), i);
        model.setValue(MUSTINPUT, (Object)fieldInfo.mustInput, i);
        model.setValue("sysmustinput", (Object)fieldInfo.mustInput, i);
        model.setValue(ENABLED, (Object)lockStatus.get(0), i);
        model.setValue(EDITENABLED, (Object)lockStatus.get(1), i);
        model.setValue(SUBMITENABLED, (Object)lockStatus.get(2), i);
        model.setValue(AUDITENABLED, (Object)lockStatus.get(3), i);
        model.setValue(VINIT, (Object)visibleStatus.get(0), i);
        model.setValue(VNEW, (Object)visibleStatus.get(1), i);
        model.setValue(VEDIT, (Object)visibleStatus.get(2), i);
        model.setValue(VVIEW, (Object)visibleStatus.get(3), i);
        model.setValue(VSUBMIT, (Object)visibleStatus.get(4), i);
        model.setValue(VAUDIT, (Object)visibleStatus.get(5), i);
    }

    static class FieldEntityInfo {
        String disPlayName;
        boolean mustInput;
        String typeName;
        String fieldKey;
        String baseEntityId;

        FieldEntityInfo(String disPlayName, boolean mustInput) {
            this.disPlayName = disPlayName;
            this.mustInput = mustInput;
            this.typeName = "";
        }

        FieldEntityInfo(String disPlayName, boolean mustInput, String fieldKey) {
            this.disPlayName = disPlayName;
            this.mustInput = mustInput;
            this.typeName = "";
            this.fieldKey = fieldKey;
        }

        FieldEntityInfo(String disPlayName, boolean mustInput, String fieldKey, String fieldType) {
            this.disPlayName = disPlayName;
            this.mustInput = mustInput;
            this.typeName = fieldType;
            this.fieldKey = fieldKey;
        }

        FieldEntityInfo(String disPlayName, boolean mustInput, String fieldKey, String fieldType, String baseEntityId) {
            this.disPlayName = disPlayName;
            this.mustInput = mustInput;
            this.typeName = fieldType;
            this.fieldKey = fieldKey;
            this.baseEntityId = baseEntityId;
        }

        public String toString() {
            return this.disPlayName + " " + this.mustInput + " " + this.typeName + " " + this.fieldKey;
        }

        public String getFieldType() {
            return this.typeName;
        }
    }

    private class EntryCellLocker {
        private EntryCellLocker() {
        }

        public String getLockCellInfos(int startFromIndex) {
            DynamicObjectCollection fldCtlEntry = BillTypeEdit.this.getModel().getEntryEntity(BillTypeEdit.KEY_FIELD_CONTROL_ENTRY);
            ArrayList<Integer> status = new ArrayList<Integer>(fldCtlEntry.size());
            for (int i = startFromIndex; i < fldCtlEntry.size(); ++i) {
                DynamicObject row = (DynamicObject)fldCtlEntry.get(i);
                int lockRecord = 0;
                ArrayList<Boolean> data = new ArrayList<Boolean>();
                data.add(row.getBoolean(BillTypeEdit.MUSTINPUT));
                data.add(row.getBoolean(BillTypeEdit.ENABLED));
                data.add(row.getBoolean(BillTypeEdit.EDITENABLED));
                data.add(row.getBoolean(BillTypeEdit.SUBMITENABLED));
                data.add(row.getBoolean(BillTypeEdit.AUDITENABLED));
                data.add(row.getBoolean(BillTypeEdit.VINIT));
                data.add(row.getBoolean(BillTypeEdit.VNEW));
                data.add(row.getBoolean(BillTypeEdit.VEDIT));
                data.add(row.getBoolean(BillTypeEdit.VVIEW));
                data.add(row.getBoolean(BillTypeEdit.VSUBMIT));
                data.add(row.getBoolean(BillTypeEdit.VAUDIT));
                for (int j = 0; j < data.size(); ++j) {
                    if (!((Boolean)data.get(j)).booleanValue()) continue;
                    lockRecord |= 1 << j;
                }
                status.add(lockRecord);
            }
            return SerializationUtils.toJsonString(status);
        }

        public void lockCell(String lockCellInfos) {
            if (StringUtils.isBlank((CharSequence)lockCellInfos)) {
                return;
            }
            List lockInfoList = (List)SerializationUtils.fromJsonString((String)lockCellInfos, List.class);
            List<List<Boolean>> initStatus = null;
            if (lockInfoList.get(0) instanceof List) {
                initStatus = lockInfoList.stream().map(info -> (List)info).collect(Collectors.toList());
            } else {
                Function<Object, List> mapper = lockInfo -> {
                    ArrayList<Boolean> list = new ArrayList<Boolean>();
                    int needLockCellCount = NEED_LOCK_CELL_WHEN_FALSE.size() + NEED_LOCK_CELL_WHEN_TRUE.size();
                    for (int i = 0; i <= needLockCellCount; ++i) {
                        Integer lockNum = (Integer)lockInfo;
                        list.add((lockNum & 1 << i) > 0);
                    }
                    return list;
                };
                initStatus = lockInfoList.stream().map(mapper).collect(Collectors.toList());
            }
            this.lockCellByDesignTimeStatus(initStatus);
        }

        public void lockCellByDesignTimeStatus(List<List<Boolean>> fromJsonString) {
            for (int rowIndex = 0; rowIndex < fromJsonString.size(); ++rowIndex) {
                FieldEdit cellEdit;
                String cellKey;
                int j;
                List<Boolean> cellLockInfos = fromJsonString.get(rowIndex);
                for (j = 0; j < NEED_LOCK_CELL_WHEN_TRUE.size(); ++j) {
                    cellKey = (String)NEED_LOCK_CELL_WHEN_TRUE.get(j);
                    cellEdit = (FieldEdit)BillTypeEdit.this.getView().getControl(cellKey);
                    cellEdit.setEntryKey(BillTypeEdit.KEY_FIELD_CONTROL_ENTRY);
                    cellEdit.setEnable("", cellLockInfos.get(j) == false, rowIndex);
                }
                for (j = 0; j < NEED_LOCK_CELL_WHEN_FALSE.size(); ++j) {
                    cellKey = (String)NEED_LOCK_CELL_WHEN_FALSE.get(j);
                    cellEdit = (FieldEdit)BillTypeEdit.this.getView().getControl(cellKey);
                    cellEdit.setEntryKey(BillTypeEdit.KEY_FIELD_CONTROL_ENTRY);
                    cellEdit.setEnable("", cellLockInfos.get(j + NEED_LOCK_CELL_WHEN_TRUE.size()).booleanValue(), rowIndex);
                }
                FieldEdit defaultValue = (FieldEdit)BillTypeEdit.this.getView().getControl(BillTypeEdit.KEY_DEFAULTVALUE);
                if (!UNSUPPORT_FIELDS.contains(BillTypeEdit.this.getModel().getValue(BillTypeEdit.KEY_DEFAULTFUNCPARAM, rowIndex)) && !Objects.equals(BillTypeEdit.this.getModel().getValue(BillTypeEdit.KEY_FIELDKEY, rowIndex), "auditor") && !Objects.equals(BillTypeEdit.this.getModel().getValue(BillTypeEdit.KEY_FIELDKEY, rowIndex), "auditdate")) continue;
                defaultValue.setEnable("", Boolean.FALSE.booleanValue(), rowIndex);
            }
        }
    }

    private static class FieldPropertyProvider {
        private static final List<String> LOCK_ALL_STATUS = Arrays.asList("new", "edit", "submit", "audit");
        private static final List<String> VISIBLE_ALL_STATUS = Arrays.asList("init", "new", "edit", "view", "submit", "audit");

        private FieldPropertyProvider() {
        }

        static Map<String, List<List<Boolean>>> getLockAndVisible(String billNumber) {
            HashMap<String, List<List<Boolean>>> maintainStateRecorder = new HashMap<String, List<List<Boolean>>>(50);
            String id = MetadataDao.getIdByNumber((String)billNumber, (MetaCategory)MetaCategory.Form);
            FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
            for (ControlAp ctlAp : formMeta.getItems()) {
                if (!(ctlAp instanceof FieldAp)) continue;
                List<Boolean> ctlLockStatus = FieldPropertyProvider.getCtlStatusSettingInAll(ctlAp.getLock(), LOCK_ALL_STATUS);
                List<Boolean> ctlVisibleStatus = FieldPropertyProvider.getCtlStatusSettingInAll(ctlAp.getVisible(), VISIBLE_ALL_STATUS);
                maintainStateRecorder.put(ctlAp.getKey(), Arrays.asList(ctlLockStatus, ctlVisibleStatus));
            }
            return maintainStateRecorder;
        }

        static List<Boolean> getCtlStatusSettingInAll(String ctlStatus, List<String> template) {
            ArrayList<Boolean> result = new ArrayList<Boolean>(10);
            for (String status : template) {
                result.add(ctlStatus.contains(status));
            }
            return result;
        }

        static Map<String, FieldEntityInfo> getBillFieldsEntityInfo(Map<String, IDataEntityProperty> tagFields, String billNumber) {
            LinkedHashMap<String, FieldEntityInfo> mustInput = new LinkedHashMap<String, FieldEntityInfo>(32);
            Map<String, FieldEntityInfo> allFieldInfo = FieldPropertyProvider.getBillFieldsEntityInfo(billNumber);
            tagFields.forEach((k, v) -> {
                if (allFieldInfo.containsKey(k)) {
                    mustInput.put((String)k, (FieldEntityInfo)allFieldInfo.get(k));
                }
            });
            return mustInput;
        }

        static Map<String, FieldEntityInfo> getBillFieldsEntityInfo(String billNumber) {
            LinkedHashMap<String, FieldEntityInfo> entityFieldInfos = new LinkedHashMap<String, FieldEntityInfo>(32);
            String id = MetadataDao.getIdByNumber((String)billNumber, (MetaCategory)MetaCategory.Entity);
            EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Entity);
            LinkedHashSet<Object> entityContainer = new LinkedHashSet<Object>();
            entityContainer.add(entityMeta.getRootEntity());
            Predicate<EntityItem> predicate = item -> item instanceof EntryEntity;
            boolean isChanged = false;
            do {
                isChanged = false;
                LinkedHashSet<Object> tmpContainer = new LinkedHashSet<Object>();
                tmpContainer.addAll(entityContainer);
                int curSize = entityContainer.size();
                entityContainer.forEach(entity -> entity.getItems().stream().filter(predicate).forEach(item -> tmpContainer.add((EntryEntity)item)));
                if (curSize == tmpContainer.size()) continue;
                isChanged = true;
                entityContainer.addAll(tmpContainer);
            } while (isChanged);
            entityContainer.forEach(entity -> entity.getItems().stream().filter(item -> item instanceof Field).forEach(item -> FieldPropertyProvider.put2Infos(entityFieldInfos, entity, item)));
            return entityFieldInfos;
        }

        private static void put2Infos(Map<String, FieldEntityInfo> entityFieldInfos, EntityItem<?> parentNode, EntityItem<?> currentNode) {
            String key = currentNode.getKey();
            String name = parentNode instanceof MainEntity ? String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934.%s", (String)"BillTypeEdit_2", (String)BillTypeEdit.BOS_FORM_BUSINESS, (Object[])new Object[0]), currentNode.getName().getLocaleValue()) : parentNode.getName().getLocaleValue() + "." + currentNode.getName().getLocaleValue();
            String type = currentNode.getClass().getSimpleName();
            boolean ismi = ((Field)currentNode).isMustInput();
            entityFieldInfos.put(key, new FieldEntityInfo(name, ismi, key, type));
        }

        static Map<String, FieldEntityInfo> getNameAndMustInput(String number) {
            return FieldPropertyProvider.getBillFieldsEntityInfo(number);
        }
    }
}

