/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.debug.cmd.AnalyseDebugCommand;
import kd.bos.form.plugin.debug.cmd.DebugCommand;
import kd.bos.form.plugin.debug.cmd.DebugCommandContext;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;

public class BosDebugPlugin
extends AbstractFormPlugin {
    private static final String TXT_COMMAND = "txt_command";
    private static final String TXT_INFO = "txt_info";
    private static final String BT_EXECUTE = "bt_execute";
    private static final String CODE_EDIT = "codeedit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BT_EXECUTE});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        if (!isSuperAdmin) {
            String tenantId = RequestContext.get().getTenantId();
            String isVisible = System.getProperty("metadata.debug");
            boolean adminUser = PermissionServiceHelper.isAdminUser((long)userId);
            if (!adminUser && StringUtils.equalsIgnoreCase((CharSequence)"false", (CharSequence)isVisible)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u8be5\u529f\u80fd\u3002", (String)"BosDebugPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
            }
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        this.getModel().updateCache();
        DebugCommandContext ctx = new DebugCommandContext(this.getPageCache());
        if (BT_EXECUTE.equals(c.getKey())) {
            String command = (String)this.getModel().getValue(TXT_COMMAND);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{command = command.trim()})) {
                String ret;
                try {
                    List<String> urls;
                    DebugCommand cmd = this.analyzeCommand(ctx, command);
                    ret = cmd.exec();
                    ctx.update();
                    if ("file".equals(cmd.getOutType()) && !(urls = cmd.getDownLoadUrls()).isEmpty() && urls.size() > 0) {
                        for (String url : urls) {
                            this.getView().openUrl(url);
                        }
                    }
                }
                catch (Exception e) {
                    ret = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                }
                CodeEdit c2 = (CodeEdit)this.getControl(CODE_EDIT);
                if (ret != null && ret.length() > 5000000) {
                    c2.setText("The content is truncated ..." + System.lineSeparator() + BosDebugPlugin.JsonFormart(ret).substring(0, 5000000) + "...");
                } else {
                    c2.setText(BosDebugPlugin.JsonFormart(ret));
                }
                if (StringUtils.isNotBlank((CharSequence)ctx.getStatusInfo())) {
                    this.getModel().setValue(TXT_INFO, (Object)ctx.getStatusInfo());
                }
            }
        }
    }

    private DebugCommand analyzeCommand(DebugCommandContext ctx, String command) {
        return AnalyseDebugCommand.analyseCommand(ctx, command);
    }

    private static String JsonFormart(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return "";
        }
        if (s.startsWith("::")) {
            return s;
        }
        int level = 0;
        StringBuilder jsonForMatStr = new StringBuilder();
        block5: for (int index = 0; index < s.length(); ++index) {
            char c = s.charAt(index);
            if (level > 0 && '\n' == jsonForMatStr.charAt(jsonForMatStr.length() - 1)) {
                jsonForMatStr.append(BosDebugPlugin.getLevelStr(level));
            }
            switch (c) {
                case '[': 
                case '{': {
                    jsonForMatStr.append(c).append("\n");
                    ++level;
                    continue block5;
                }
                case ',': {
                    jsonForMatStr.append(c).append("\n");
                    continue block5;
                }
                case ']': 
                case '}': {
                    jsonForMatStr.append("\n");
                    jsonForMatStr.append(BosDebugPlugin.getLevelStr(--level));
                    jsonForMatStr.append(c);
                    continue block5;
                }
                default: {
                    jsonForMatStr.append(c);
                }
            }
        }
        return jsonForMatStr.toString();
    }

    private static String getLevelStr(int level) {
        StringBuilder levelStr = new StringBuilder();
        for (int levelI = 0; levelI < level; ++levelI) {
            levelStr.append("\t");
        }
        return levelStr.toString();
    }
}

