/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.debug.Impl.ManagePlugInDebug;
import kd.bos.form.plugin.debug.executor.DMethodParam;
import kd.bos.form.plugin.debug.executor.MethodExpr;
import kd.bos.instance.Instance;
import kd.bos.ksql.exception.ParserException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.BuildFormDesignMeta;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.mservice.runmode.RunModeService;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.collections.map.CaseInsensitiveMap;

public class ManagePlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(ManagePlugin.class);
    private static final String REDISCACHE = "rediscache";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"clearcache", "getcache", "getvalue", "getappcache", "getsessionlesscache", "cmpfieldtype", "booleanisnull"});
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        this.getModel().updateCache();
        if ("clearcache".equals(c.getKey())) {
            Object cacheKey = this.getModel().getValue("cachekey");
            if (cacheKey == null) {
                this.getView().showMessage("key is null");
                return;
            }
            String cacheType = (String)this.getModel().getValue("combocache");
            if ("type".equals(cacheType)) {
                this.clearCacheByType((String)cacheKey);
            } else if ("number".equals(cacheType)) {
                this.clearCacheByNumber((String)cacheKey);
            } else if ("meta".equals(cacheType)) {
                this.clearMetaCacheByNumber((String)cacheKey);
            } else if ("app".equals(cacheType)) {
                this.clearAppCache((String)cacheKey);
            } else if ("appmeta".equals(cacheType)) {
                this.clearAppMetaCache();
            } else if ("appruntimemeta".equals(cacheType)) {
                this.clearAppRuntimeMetaCache((String)cacheKey);
            }
        } else if ("getcache".equals(c.getKey())) {
            String formNumber = (String)this.getModel().getValue("formnumber");
            String appid = (String)this.getModel().getValue("appid");
            if (StringUtils.isBlank((CharSequence)formNumber) || StringUtils.isBlank((CharSequence)appid)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8868\u5355\u7f16\u7801 \u6216 appid is null", (String)"ManagePlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
                return;
            }
            String type = (String)this.getModel().getValue("type");
            String localcache = "";
            String rediscache = "";
            String appName = Instance.getAppName();
            if ("1".equals(type)) {
                log.debug("kd.bos.form.plugin.ManagePlugin.getAppMetaByLocalCache:appName = " + appName);
                String appMethodName = (String)this.getModel().getValue("appmethodname");
                localcache = this.getAppMetaByLocalCache(appid, formNumber, appMethodName);
                rediscache = this.getAppMetaByRedisCache(appid, formNumber, appMethodName);
            } else {
                log.debug("kd.bos.form.plugin.ManagePlugin.getMetaByLocalCache:appName = " + appName);
                String methodName = (String)this.getModel().getValue("methodname");
                localcache = this.getMetaByLocalCache(appid, formNumber, methodName);
                rediscache = this.getMetaByRedisCache(appid, formNumber, methodName);
            }
            CodeEdit c1 = (CodeEdit)this.getControl("localcache");
            c1.setText(ManagePlugin.JsonFormart(localcache));
            CodeEdit c2 = (CodeEdit)this.getControl(REDISCACHE);
            c2.setText(ManagePlugin.JsonFormart(rediscache));
        } else if ("getappcache".equals(c.getKey())) {
            Object appid = this.getModel().getValue("cachetype");
            if (appid == null) {
                this.getView().showMessage("appnumber is null");
                return;
            }
            Object cacheparam = this.getModel().getValue("cacheparam");
            if (cacheparam == null) {
                this.getView().showMessage("cacheparam is null");
                return;
            }
            String val = this.getAppCache((String)appid, (String)cacheparam);
            CodeEdit c2 = (CodeEdit)this.getControl(REDISCACHE);
            c2.setText(ManagePlugin.JsonFormart(val));
        } else if ("getsessionlesscache".equals(c.getKey())) {
            Object region = this.getModel().getValue("region");
            Object cachetype = this.getModel().getValue("cachetype");
            if (cachetype == null) {
                this.getView().showMessage("cachetype is null");
                return;
            }
            Object cacheparam = this.getModel().getValue("cacheparam");
            String val = this.getSessionlessCache((String)region, (String)cachetype, cacheparam);
            CodeEdit c2 = (CodeEdit)this.getControl(REDISCACHE);
            c2.setText(ManagePlugin.JsonFormart(val));
        } else if ("getvalue".equals(c.getKey())) {
            this.debugMethod(2);
        } else if ("cmpfieldtype".equals(c.getKey())) {
            String val = this.getMetaDBTypeUnMatchFields();
            CodeEdit c2 = (CodeEdit)this.getControl(REDISCACHE);
            c2.setText(ManagePlugin.JsonFormart(val));
        } else if ("booleanisnull".equals(c.getKey())) {
            String val = this.getBooleanFieldDefaultIsBlank();
            CodeEdit c2 = (CodeEdit)this.getControl(REDISCACHE);
            c2.setText(ManagePlugin.JsonFormart(val));
        }
    }

    private void debugMethod(int ver) {
        String pageId = (String)this.getModel().getValue("pageid");
        String methodExpr = (String)this.getModel().getValue("methods");
        String classType = (String)this.getModel().getValue("classtype");
        Object obj = ver == 1 ? this.invokeMethod1(pageId, methodExpr, classType) : this.invokeMethod(pageId, methodExpr, classType);
        CodeEdit c2 = (CodeEdit)this.getControl(REDISCACHE);
        if (obj instanceof String) {
            c2.setText((String)obj);
        } else if (obj instanceof Map) {
            c2.setText(obj.toString());
        } else if (obj instanceof DynamicObject) {
            String oo = SerializationUtils.toJsonString((Object)obj);
            c2.setText(oo);
        } else {
            c2.setText(obj.toString());
        }
    }

    private String getMetaByLocalCache(String appId, String number, String methodName) {
        return (String)DispatchServiceHelper.invokeBOSService((String)appId, (String)"DebugMetadataService", (String)"getMetaByLocalCache", (Object[])new Object[]{methodName, new String[]{number}});
    }

    private String getMetaByRedisCache(String appId, String number, String methodName) {
        return (String)DispatchServiceHelper.invokeBOSService((String)appId, (String)"DebugMetadataService", (String)"getMetaByRedisCache", (Object[])new Object[]{methodName, new String[]{number}});
    }

    private String getAppMetaByLocalCache(String appId, String number, String methodName) {
        return (String)DispatchServiceHelper.invokeBOSService((String)appId, (String)"DebugMetadataService", (String)"getAppMetaByLocalCache", (Object[])new Object[]{methodName, new String[]{number}});
    }

    private String getAppMetaByRedisCache(String appId, String number, String methodName) {
        return (String)DispatchServiceHelper.invokeBOSService((String)appId, (String)"DebugMetadataService", (String)"getAppMetaByRedisCache", (Object[])new Object[]{methodName, new String[]{number}});
    }

    private String getAppCache(String appKey, String cacheparam) {
        return (String)AppCache.get((String)appKey).get(cacheparam, String.class);
    }

    private String getSessionlessCache(String region, String cacheKey, Object cacheparam) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(region, new DistributeCacheHAPolicy());
        if (cacheparam == null) {
            return (String)cache.get(cacheKey);
        }
        String[] params = cacheparam.toString().split(",");
        if (params.length == 1) {
            return SerializationUtils.toJsonString((Object)cache.get(cacheKey, params[0]));
        }
        return SerializationUtils.toJsonString((Object)cache.get(cacheKey, params));
    }

    private void clearCacheByNumber(String formNumber) {
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)formNumber);
        if (mt != null && !StringUtils.isBlank((CharSequence)mt.getAlias())) {
            DataEntityCacheManager cm = new DataEntityCacheManager(mt.getAlias());
            cm.removeByDt();
        }
    }

    private void clearMetaCacheByNumber(String formNumber) {
        String id = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Form);
        BuildFormDesignMeta meta = new BuildFormDesignMeta();
        meta.setId(id);
        meta.setNumber(formNumber);
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)formNumber);
        if (mt != null) {
            meta.setTableName(mt.getAlias());
        }
        ArrayList<BuildFormDesignMeta> list = new ArrayList<BuildFormDesignMeta>();
        list.add(meta);
        MetadataDao.clearCache(list);
    }

    private void clearCacheByType(String className) {
        Class<?> c1;
        try {
            c1 = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new KDException((Throwable)e, BosErrorCode.actionClassNotFound, new Object[]{"class not found"});
        }
        IDataEntityType type = OrmUtils.getDataEntityType(c1);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
        cacheManager.removeByDt();
        this.getView().showMessage(String.format("clear cache by type:%s", className));
    }

    private void clearAppCache(String appKey) {
        IAppCache appCache = AppCache.get((String)appKey);
        appCache.clear();
    }

    private void clearAppMetaCache() {
        this.clearCacheByNumber("bos_devportal_bizapp");
        AppReader.cleanAllAppNumberAndIdCache();
    }

    private void clearAppRuntimeMetaCache(String appNumber) {
        if (StringUtils.isNotEmpty((CharSequence)appNumber)) {
            MetaCacheUtils.removeAppmetaDistributeCache((String)appNumber);
            AppMetadataCache.removeAppmetaLocalCache((String)appNumber);
            RunModeService runModeService = (RunModeService)ServiceFactory.getService(RunModeService.class);
            runModeService.removeCache("all");
        }
    }

    private Object invokeMethod(String pageId, String methodExpr, String classType) {
        IFormView obj = this.getFormView(pageId);
        if (obj == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"getFormView(pageId) is null."});
        }
        try {
            MethodExpr expr = MethodExpr.parseMethod(methodExpr);
            return this.execMethodExpr(expr, obj);
        }
        catch (ParserException e1) {
            log.debug(e1.getMessage());
            return "";
        }
    }

    private Object execMethodExpr(MethodExpr expr, Object obj) {
        String retType = expr.getReturnType();
        if (StringUtils.isBlank((CharSequence)retType)) {
            retType = "kd.bos.mvc.form.FormView";
        }
        ManagePlugInDebug pd = ManagePlugInDebug.getType(retType);
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (expr.getParams() != null) {
            for (DMethodParam param : expr.getParams()) {
                if (param.getExpr() != null) {
                    paramList.add(this.execMethodExpr(param.getExpr(), obj));
                    continue;
                }
                if (!StringUtils.isNotBlank((Object)param.getValue())) continue;
                paramList.add(param.getValue());
            }
        }
        Object instance = obj;
        if (expr.getInstance() != null && expr.getInstance().getExpr() != null) {
            instance = this.execMethodExpr(expr.getInstance().getExpr(), instance);
            for (Class<?> instanceType = instance.getClass(); instanceType != null && (pd = ManagePlugInDebug.getType(instanceType.getName())) == null; instanceType = instanceType.getSuperclass()) {
            }
            if (pd == null || instance == null) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"instance is null."});
            }
        } else if (expr.getInstance() != null) {
            if (StringUtils.isNotBlank((CharSequence)expr.getInstance().getInstanceName())) {
                pd = ManagePlugInDebug.getType(expr.getInstance().getInstanceName());
                instance = null;
            }
            if (StringUtils.isBlank((CharSequence)expr.getInstance().getInstanceName())) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"expr.instance.instanceName is null."});
            }
        }
        AccessibleObject ao = pd.getAction(expr.getMethodName(), expr.getParams());
        return this.invokeMethod(paramList, instance, ao);
    }

    private Object invokeMethod(List<Object> paramList, Object instance, AccessibleObject ao) {
        Object obj = null;
        if (ao instanceof Method) {
            try {
                if (paramList.isEmpty()) {
                    obj = ((Method)ao).invoke(instance, new Object[0]);
                }
                Object[] pars = new Object[paramList.size()];
                for (int i = 0; i < paramList.size(); ++i) {
                    pars[i] = ((Method)ao).getParameterTypes()[i] == Boolean.TYPE ? Boolean.valueOf(Boolean.parseBoolean((String)paramList.get(i))) : ((Method)ao).getParameterTypes()[i].cast(paramList.get(i));
                }
                obj = ((Method)ao).invoke(instance, pars);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
            }
        } else {
            try {
                ((Field)ao).setAccessible(true);
                obj = ((Field)ao).get(instance);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
            }
        }
        return obj;
    }

    private boolean isClassName(String instanceName) {
        return false;
    }

    private IFormView getFormView(String pageId) {
        return SessionManager.getCurrent().getViewNoPlugin(pageId);
    }

    private static String JsonFormart(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return "";
        }
        int level = 0;
        StringBuilder jsonForMatStr = new StringBuilder();
        block5: for (int index = 0; index < s.length(); ++index) {
            char c = s.charAt(index);
            if (level > 0 && '\n' == jsonForMatStr.charAt(jsonForMatStr.length() - 1)) {
                jsonForMatStr.append(ManagePlugin.getLevelStr(level));
            }
            switch (c) {
                case '[': 
                case '{': {
                    jsonForMatStr.append(c).append("\n");
                    ++level;
                    continue block5;
                }
                case ',': {
                    jsonForMatStr.append(c).append("\n");
                    continue block5;
                }
                case ']': 
                case '}': {
                    jsonForMatStr.append("\n");
                    jsonForMatStr.append(ManagePlugin.getLevelStr(--level));
                    jsonForMatStr.append(c);
                    continue block5;
                }
                default: {
                    jsonForMatStr.append(c);
                }
            }
        }
        return jsonForMatStr.toString();
    }

    private static String getLevelStr(int level) {
        StringBuilder levelStr = new StringBuilder();
        for (int levelI = 0; levelI < level; ++levelI) {
            levelStr.append("\t");
        }
        return levelStr.toString();
    }

    private Object invokeMethod1(String pageId, String methodExpr, String classType) {
        Object obj = this.getFormView(pageId);
        if (obj == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"getFormView(pageId) is null."});
        }
        String[] currentMethods = methodExpr.contains(".") ? methodExpr.split("\\.") : new String[]{methodExpr};
        if (StringUtils.isBlank((CharSequence)classType)) {
            classType = "kd.bos.mvc.form.FormView";
        }
        ManagePlugInDebug pd = ManagePlugInDebug.getType(classType);
        String[] stringArray = currentMethods;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            AccessibleObject ao;
            String methodName;
            int idx = (methodName = stringArray[i]).indexOf("(");
            String actionName = methodName.substring(0, idx < 0 ? methodName.length() : idx);
            String paramStr = "";
            if (idx > 0) {
                paramStr = methodName.substring(methodName.indexOf("(") + 1, methodName.length() - 1);
            }
            if ((ao = pd.getAction(actionName)) instanceof Method) {
                try {
                    obj = StringUtils.isBlank((CharSequence)paramStr) ? ((Method)ao).invoke(obj, new Object[0]) : ((Method)ao).invoke(obj, paramStr);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    log.debug(e.getMessage());
                }
                pd = ManagePlugInDebug.getType(((Method)ao).getReturnType().getName());
                continue;
            }
            try {
                ((Field)ao).setAccessible(true);
                obj = ((Field)ao).get(obj);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.debug(e.getMessage());
            }
            pd = ManagePlugInDebug.getType(((Field)ao).getType().getName());
        }
        return obj;
    }

    /*
     * WARNING - void declaration
     */
    private String getMetaDBTypeUnMatchFields() {
        String dbRoute;
        String sql = "select fnumber from t_meta_entity where ftype = 11;";
        List list = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>(16);
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                return list;
            }
        });
        CaseInsensitiveMap metaNumberTableNameMap = new CaseInsensitiveMap();
        CaseInsensitiveMap errorMap = new CaseInsensitiveMap();
        CaseInsensitiveMap dbRouteMap = new CaseInsensitiveMap();
        CaseInsensitiveMap metaTabMap = new CaseInsensitiveMap();
        for (Object number : list) {
            void var13_18;
            Object tabName;
            String string;
            MainEntityType mainEntityType;
            try {
                mainEntityType = EntityMetadataCache.getDataEntityType((String)number);
            }
            catch (Exception e) {
                log.warn("kd.bos.form.plugin.ManagePlugin.getMetaDBTypeUnMatchFields: number = " + (String)number + " error =" + e.getMessage());
                continue;
            }
            dbRoute = mainEntityType.getDBRouteKey();
            Map dbTabMap = (Map)dbRouteMap.get(dbRoute);
            if (dbTabMap == null) {
                dbTabMap = new CaseInsensitiveMap();
                dbRouteMap.put(dbRoute, dbTabMap);
            }
            if (StringUtils.isBlank((CharSequence)(string = (String)metaNumberTableNameMap.get(tabName = mainEntityType.getAlias())))) {
                Object object = number;
            } else {
                String string2 = string + "|" + (String)number;
            }
            metaNumberTableNameMap.put(tabName, var13_18);
            dbTabMap.put(tabName, new ArrayList());
            Map fieldMap = (Map)metaTabMap.get(tabName);
            if (fieldMap == null) {
                fieldMap = new CaseInsensitiveMap();
                metaTabMap.put(tabName, fieldMap);
            }
            for (Map.Entry entry : mainEntityType.getAllFields().entrySet()) {
                IDataEntityProperty dep = (IDataEntityProperty)entry.getValue();
                try {
                    int type;
                    String fieldName;
                    if (dep instanceof BasedataProp) {
                        fieldName = dep.getAlias();
                        type = ((IFieldHandle)dep).getDbType();
                        fieldMap.put(fieldName, type);
                        continue;
                    }
                    if (dep instanceof IFieldHandle) {
                        fieldName = dep.getAlias();
                        type = ((IFieldHandle)dep).getDbType();
                        fieldMap.put(fieldName, type);
                        continue;
                    }
                    errorMap.put(tabName, dep.getAlias());
                }
                catch (Exception e) {
                    log.warn(String.format("kd.bos.form.plugin.ManagePlugin.getMetaDBTypeUnMatchFields: number='%s' fieldName='%s' error='%s'", number, dep.getAlias(), e.getMessage()));
                }
            }
        }
        CaseInsensitiveMap noMatch = new CaseInsensitiveMap();
        for (Map.Entry entry : dbRouteMap.entrySet()) {
            dbRoute = (String)entry.getKey();
            Object[] tableNames = ((Map)entry.getValue()).keySet().toArray();
            try {
                for (Map.Entry entry2 : this.getFieldInfo(DBRoute.of((String)dbRoute), tableNames).entrySet()) {
                    String tableName = (String)entry2.getKey();
                    Map dbFieldMap = (Map)entry2.getValue();
                    Map metaFieldMap = (Map)metaTabMap.get(tableName);
                    for (Map.Entry metaFieldEntry : metaFieldMap.entrySet()) {
                        String fieldName = (String)metaFieldEntry.getKey();
                        Integer metaFieldType = (Integer)metaFieldEntry.getValue();
                        Column col = (Column)dbFieldMap.get(fieldName);
                        if (col == null || !StringUtils.isNotBlank((CharSequence)col.type) || this.compareType(metaFieldType, col.type)) continue;
                        ArrayList<String> fieldlist = (ArrayList<String>)noMatch.get(tableName);
                        if (fieldlist == null) {
                            fieldlist = new ArrayList<String>();
                            noMatch.put(tableName, fieldlist);
                        }
                        fieldlist.add(fieldName);
                    }
                }
            }
            catch (Exception e) {
                log.warn(String.format("kd.bos.form.plugin.ManagePlugin.getMetaDBTypeUnMatchFields: error='%s'", e.getMessage()));
            }
        }
        CaseInsensitiveMap noDescMatch = new CaseInsensitiveMap();
        for (Map.Entry entry : noMatch.entrySet()) {
            String number = (String)metaNumberTableNameMap.get(entry.getKey());
            noDescMatch.put((String)entry.getKey() + "(" + number + ")", entry.getValue());
        }
        return SerializationUtils.toJsonString((Object)noDescMatch);
    }

    /*
     * WARNING - void declaration
     */
    private String getBooleanFieldDefaultIsBlank() {
        String sql = "select a.fnumber from t_meta_entity a where a.ftype = 11 ;";
        List list = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                return list;
            }
        });
        CaseInsensitiveMap metaNumberTableNameMap = new CaseInsensitiveMap();
        CaseInsensitiveMap errorMap = new CaseInsensitiveMap();
        CaseInsensitiveMap dbRouteMap = new CaseInsensitiveMap();
        CaseInsensitiveMap metaTabMap = new CaseInsensitiveMap();
        for (Object number : list) {
            void var13_18;
            String string;
            MainEntityType mainEntityType;
            try {
                mainEntityType = EntityMetadataCache.getDataEntityType((String)number);
            }
            catch (Exception e) {
                log.warn("kd.bos.form.plugin.ManagePlugin.getMetaDBTypeUnMatchFields: number = " + (String)number + " error =" + e.getMessage());
                continue;
            }
            String tabName = mainEntityType.getAlias();
            if (StringUtils.isBlank((CharSequence)tabName)) continue;
            String dbRoute = mainEntityType.getDBRouteKey();
            Object dbTabMap = (Map)dbRouteMap.get(dbRoute);
            if (dbTabMap == null) {
                dbTabMap = new CaseInsensitiveMap();
                dbRouteMap.put(dbRoute, dbTabMap);
            }
            if (StringUtils.isBlank((CharSequence)(string = (String)metaNumberTableNameMap.get(tabName)))) {
                Object object = number;
            } else {
                String string2 = string + "|" + (String)number;
            }
            metaNumberTableNameMap.put(tabName, var13_18);
            dbTabMap.put(tabName, new ArrayList());
            Map fieldMap = (Map)metaTabMap.get(tabName);
            if (fieldMap == null) {
                fieldMap = new CaseInsensitiveMap();
                metaTabMap.put(tabName, fieldMap);
            }
            for (Map.Entry entry : mainEntityType.getAllFields().entrySet()) {
                IDataEntityProperty dep = (IDataEntityProperty)entry.getValue();
                try {
                    if (!(dep instanceof BooleanProp)) continue;
                    String fieldName = dep.getAlias();
                    int type = ((IFieldHandle)dep).getDbType();
                    fieldMap.put(fieldName, type);
                }
                catch (Exception e) {
                    log.warn(String.format("kd.bos.form.plugin.ManagePlugin.getMetaDBTypeUnMatchFields: number='%s' fieldName='%s' error='%s'", number, dep.getAlias(), e.getMessage()));
                }
            }
        }
        CaseInsensitiveMap defaultIsNullFields = new CaseInsensitiveMap();
        for (Map.Entry entry : dbRouteMap.entrySet()) {
            String dbRoute = (String)entry.getKey();
            Object[] tableNames = ((Map)entry.getValue()).keySet().toArray();
            try {
                for (Map.Entry entry2 : this.getFieldInfo(DBRoute.of((String)dbRoute), tableNames).entrySet()) {
                    String tableName = (String)entry2.getKey();
                    Map dbFieldMap = (Map)entry2.getValue();
                    Map metaFieldMap = (Map)metaTabMap.get(tableName);
                    for (Map.Entry metaFieldEntry : metaFieldMap.entrySet()) {
                        String fieldName = (String)metaFieldEntry.getKey();
                        Integer metaFieldType = (Integer)metaFieldEntry.getValue();
                        Column col = (Column)dbFieldMap.get(fieldName);
                        if (!this.defaultIsNull(DBRoute.of((String)dbRoute), col.defaultValue)) continue;
                        ArrayList<String> fieldlist = (ArrayList<String>)defaultIsNullFields.get(tableName);
                        if (fieldlist == null) {
                            fieldlist = new ArrayList<String>();
                            defaultIsNullFields.put(tableName, fieldlist);
                        }
                        fieldlist.add(fieldName);
                    }
                }
            }
            catch (Exception e) {
                log.warn(String.format("kd.bos.form.plugin.ManagePlugin.getMetaDBTypeUnMatchFields: error='%s'", e.getMessage()));
            }
        }
        CaseInsensitiveMap noDescMatch = new CaseInsensitiveMap();
        for (Map.Entry entry : defaultIsNullFields.entrySet()) {
            String number = (String)metaNumberTableNameMap.get(entry.getKey());
            noDescMatch.put((String)entry.getKey() + "(" + number + ")", entry.getValue());
        }
        return SerializationUtils.toJsonString((Object)noDescMatch);
    }

    private boolean compareType(Integer metaFieldType, String dbFieldType) {
        boolean match = false;
        switch (dbFieldType) {
            case "NUMBER": {
                match = metaFieldType == -5 || metaFieldType == 4 || metaFieldType == 5 || metaFieldType == -6 || metaFieldType == 3;
                break;
            }
            case "NVARCHAR2": 
            case "VARCHAR2": 
            case "CHAR": 
            case "NCLOB": {
                match = metaFieldType == 12 || metaFieldType == -9 || metaFieldType == 1 || metaFieldType == -15 || metaFieldType == 2011;
                break;
            }
            case "DATE": {
                match = metaFieldType == 91 || metaFieldType == 92 || metaFieldType == 93;
                break;
            }
            case "BLOB": {
                match = metaFieldType == 2004;
                break;
            }
        }
        return match;
    }

    private boolean defaultIsNull(DBRoute dbRoute, String defaultValue) {
        DBType dbType = DB.getDBType((DBRoute)dbRoute);
        if (DBType.Oracle == dbType || DBType.DM == dbType) {
            return StringUtils.isBlank((CharSequence)defaultValue);
        }
        if (DBType.MySQL != dbType) {
            if (DBType.PostgreSQL == dbType) {
                if (StringUtils.isBlank((CharSequence)defaultValue)) {
                    return true;
                }
                String[] str = defaultValue.split("::");
                return StringUtils.isBlank((CharSequence)str[0].replace("'", ""));
            }
            throw new RuntimeException("dbType " + dbType.name() + " not supported yet!");
        }
        return false;
    }

    private Map<String, Map<String, Column>> getFieldInfo(DBRoute dbRoute, Object[] tableNames) {
        DBType dbType = DB.getDBType((DBRoute)dbRoute);
        SqlBuilder sql = new SqlBuilder();
        if (DBType.Oracle == dbType || DBType.DM == dbType) {
            Object[] obj = new Object[tableNames.length];
            for (int i = 0; i < tableNames.length; ++i) {
                obj[i] = StringUtils.upperCase((String)((String)tableNames[i]));
            }
            sql.append("/*dialect*/SELECT TABLE_NAME, COLUMN_NAME, DATA_TYPE, DATA_DEFAULT FROM USER_TAB_COLUMNS WHERE", new Object[0]).appendIn("TABLE_NAME", obj);
        } else if (DBType.MySQL == dbType) {
            sql.append("/*dialect*/SELECT TABLE_NAME, column_name,data_type, column_default FROM information_schema.COLUMNS WHERE table_schema = SCHEMA () and ", new Object[0]).appendIn("table_name", tableNames);
        } else if (DBType.PostgreSQL == dbType) {
            sql.append("/*dialect*/SELECT TABLE_NAME, column_name,data_type, column_default FROM information_schema.columns WHERE ", new Object[0]).appendIn("table_name", tableNames);
        } else {
            throw new RuntimeException("dbType " + dbType.name() + " not supported yet!");
        }
        Map map = (Map)DB.query((DBRoute)dbRoute, (SqlBuilder)sql, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Column>>>(){

            public Map<String, Map<String, Column>> handle(ResultSet rs) throws Exception {
                CaseInsensitiveMap map = new CaseInsensitiveMap();
                while (rs.next()) {
                    String tableName = rs.getString(1);
                    Map fieldMap = (Map)map.get(tableName);
                    if (fieldMap == null) {
                        fieldMap = new CaseInsensitiveMap();
                        map.put(tableName, fieldMap);
                    }
                    Column col = new Column(rs.getString(2), rs.getString(3));
                    col.setDefaultValue(rs.getString(4));
                    fieldMap.put(rs.getString(2), col);
                }
                return map;
            }
        });
        return map;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changeType();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("type".equals(propertyName)) {
            this.changeType();
        }
    }

    private void changeType() {
        String type;
        switch (type = (String)this.getModel().getValue("type")) {
            case "0": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"methodname"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"appmethodname"});
                break;
            }
            case "1": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"appmethodname"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"methodname"});
            }
        }
    }

    static class Column {
        String name;
        String type;
        String defaultValue;

        String getName() {
            return this.name;
        }

        String getType() {
            return this.type;
        }

        String getDefaultValue() {
            return this.defaultValue;
        }

        void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        Column(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }
}

