/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.cmd;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.debug.cmd.ClearCacheCommand;
import kd.bos.form.plugin.debug.cmd.DebugCommand;
import kd.bos.form.plugin.debug.cmd.DebugCommandContext;
import kd.bos.form.plugin.debug.cmd.GLangDDLCommand;
import kd.bos.form.plugin.debug.cmd.GenCommentSqlCommand;
import kd.bos.form.plugin.debug.cmd.GetCacheCommand;
import kd.bos.form.plugin.debug.cmd.GetValueCommand;
import kd.bos.form.plugin.debug.cmd.InitCommand;
import kd.bos.form.plugin.debug.cmd.LogCommand;
import kd.bos.form.plugin.debug.cmd.MulLangSqlCommand;
import kd.bos.form.plugin.debug.cmd.RebuildCommand;
import kd.bos.form.plugin.debug.cmd.VarCommand;

public class AnalyseDebugCommand {
    public static DebugCommand analyseCommand(DebugCommandContext ctx, String command) {
        DebugCommand dcmd;
        String[] cmdStrings = command.split(" ", 3);
        String cmdString = cmdStrings[0];
        if (cmdString.startsWith("init")) {
            dcmd = new InitCommand(ctx, cmdStrings);
        } else if (cmdString.startsWith("log")) {
            dcmd = new LogCommand(ctx, cmdStrings);
        } else if (cmdString.startsWith("var")) {
            dcmd = new VarCommand(ctx, cmdStrings);
        } else if (cmdString.equals("get")) {
            dcmd = new GetValueCommand(ctx, cmdStrings);
        } else if (cmdString.startsWith("getcache")) {
            dcmd = new GetCacheCommand(ctx, cmdStrings);
        } else if (cmdString.startsWith("clearcache")) {
            dcmd = new ClearCacheCommand(ctx, cmdStrings);
        } else if (cmdString.startsWith("rebuildmeta")) {
            dcmd = new RebuildCommand(ctx, cmdStrings);
        } else if (cmdString.startsWith("updateMulLangSql")) {
            dcmd = new MulLangSqlCommand(ctx, cmdStrings);
        } else if (cmdString.startsWith("genCommentSql")) {
            dcmd = new GenCommentSqlCommand(ctx, cmdStrings);
        } else if (cmdString.startsWith("glangddl")) {
            dcmd = new GLangDDLCommand(ctx, cmdStrings);
        } else {
            throw new KDException(BosErrorCode.bOS, new Object[]{"not implement"});
        }
        return dcmd;
    }
}

