/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.debug.cmd.DebugCommand;
import kd.bos.form.plugin.debug.cmd.DebugCommandContext;
import kd.bos.form.plugin.debug.cmd.MulLangSqlCommand;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

class GLangDDLCommand
extends DebugCommand {
    private static String[] cmdtoken = new String[]{"t", "a", "all", "ot", "oa", "oall"};
    private int start = 0;
    private int end = 0;
    private int dbStart = 0;
    private int dbEnd = 0;
    private String specifiedTable = "";
    private String appid = "";
    private String sqlType = "ksql";
    private static final Log log = LogFactory.getLog(MulLangSqlCommand.class);

    public GLangDDLCommand(DebugCommandContext ctx, String[] cmdStrings) {
        super(ctx);
        this.initCmd(cmdStrings);
    }

    @Override
    public String exec() {
        if ("?".equals(this.getCmdParam())) {
            ArrayList<String> list = new ArrayList<String>(16);
            list.add("glangddl -t table | -a appid | -all from to | -ot table | -oa appid | oall from to");
            list.add("-t    Generates a general-language DDL for the specified table. e.g. glangddl -t t_bos_user mysql ");
            list.add("-a    Generates a general-language DDL for all tables specified appid. e.g. glangddl -a sys ");
            list.add("-all   Generates a general-language DDL for all tables. e.g. glangddl -all db:1 db:1000 ");
            list.add("o    Open(enable) general-language. e.g. glangddl -oall 1 1000 ");
            return SerializationUtils.toJsonString(list);
        }
        return this.genGLangDDLSql();
    }

    @Override
    protected void initCmd(String[] cmdStrings) {
        super.initCmd(cmdStrings);
        this.checkCmd(cmdStrings);
    }

    private void checkCmd(String[] cmdStrings) {
        if (this.getCmdParam().equals("?")) {
            return;
        }
        if (cmdStrings.length < 3) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        String[] parameter = this.getParameter();
        if (parameter.length < 1) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command parameter error. e.g.'glangddl -t t_bos_user mysql'"});
        }
        String par1 = parameter[0];
        if (this.getCmdParam().equals("all") || this.getCmdParam().equals("oall")) {
            if (parameter.length < 2) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"debug command parameter error. e.g.'glangddl -all 1 1000'"});
            }
            String par2 = parameter[1];
            if (par1.startsWith("db:")) {
                this.dbStart = Integer.parseInt(par1.substring(3));
                this.dbEnd = Integer.parseInt(par2.substring(3));
            } else {
                this.start = Integer.parseInt(parameter[0]);
                this.end = Integer.parseInt(parameter[1]);
            }
            if (parameter.length > 2) {
                this.sqlType = "mysql";
            }
        } else if (this.getCmdParam().equals("t") || this.getCmdParam().equals("ot")) {
            this.specifiedTable = par1;
            if (parameter.length > 1) {
                String par2 = parameter[1];
                this.sqlType = "mysql".equalsIgnoreCase(par2) ? "mysql" : "ksql";
            }
        } else if (this.getCmdParam().equals("a") || this.getCmdParam().equals("oa")) {
            this.appid = par1;
            if (parameter.length > 1) {
                String par2 = parameter[1];
                this.sqlType = "mysql".equalsIgnoreCase(par2) ? "mysql" : "ksql";
            }
        }
    }

    private String genGLangDDLSql() {
        String sql;
        String[] parameter = this.getParameter();
        if (parameter == null || parameter.length == 0) {
            return "parameter is null";
        }
        Object[] appIds = new Object[]{this.appid};
        HashMap<String, List<MainEntityType>> dbRouteEntityMap = new HashMap<String, List<MainEntityType>>(20);
        if (StringUtils.isNotBlank((CharSequence)this.appid)) {
            sql = "select a.fnumber, a.fdata from t_meta_entity a where a.ftype = 11 and exists (select 1 from t_meta_formdesign b inner join t_meta_bizapp c on b.fbizappid = c.fid where b.fid = a.fid and c.fnumber = ?) order by fnumber";
            DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])appIds, this.getMetHandle(dbRouteEntityMap));
        } else {
            sql = "select fnumber, fdata from t_meta_entity where ftype = 11 order by fnumber";
            DB.query((DBRoute)DBRoute.meta, (String)sql, this.getMetHandle(dbRouteEntityMap));
        }
        boolean openGL = false;
        String cmdParam = this.getCmdParam();
        if (cmdParam.startsWith("o")) {
            openGL = true;
        }
        HashMap<String, Object> dbTableMap = new HashMap<String, Object>(20);
        boolean fillSpecifiedTable = false;
        block4: for (Map.Entry entry : dbRouteEntityMap.entrySet()) {
            if (fillSpecifiedTable) break;
            for (MainEntityType mainEntityType : (List)entry.getValue()) {
                String routeKey;
                if (!(mainEntityType instanceof BasedataEntityType)) continue;
                if (StringUtils.isNotBlank((CharSequence)this.specifiedTable)) {
                    if (!this.specifiedTable.equalsIgnoreCase(mainEntityType.getAlias())) continue;
                    routeKey = (String)entry.getKey();
                    this.fillTableMuliLangField(openGL, routeKey, mainEntityType, dbTableMap);
                    fillSpecifiedTable = true;
                    continue block4;
                }
                routeKey = (String)entry.getKey();
                this.fillTableMuliLangField(openGL, routeKey, mainEntityType, dbTableMap);
            }
        }
        dbRouteEntityMap.clear();
        int i = 1;
        StringBuilder sb = new StringBuilder(100);
        for (Map.Entry entry : dbTableMap.entrySet()) {
            String dbkey = (String)entry.getKey();
            Map tableFieldMap = (Map)entry.getValue();
            HashMap<String, List<String>> dbTableColumnMap = new HashMap<String, List<String>>(16);
            StringBuilder tabNameSB = new StringBuilder(100);
            int idx = 0;
            for (String string : tableFieldMap.keySet()) {
                if (!StringUtils.isJavaIdentifier((String)string)) {
                    throw new KDException(BosErrorCode.variableNotValid, new Object[]{string, "table name error."});
                }
                tabNameSB.append("'").append(string).append("',");
                if (++idx != 500) continue;
                tabNameSB.deleteCharAt(tabNameSB.length() - 1);
                try {
                    this.fillTableColumnMap(dbkey, tabNameSB.toString(), dbTableColumnMap);
                }
                catch (Exception e) {
                    sb.append("---- Read a field error that already exists in the table. dbkey:").append(dbkey).append(",error:").append(e.getMessage());
                    sb.append(System.lineSeparator());
                }
                idx = 0;
                tabNameSB.delete(0, tabNameSB.length());
            }
            if (idx > 0) {
                tabNameSB.deleteCharAt(tabNameSB.length() - 1);
                try {
                    this.fillTableColumnMap(dbkey, tabNameSB.toString(), dbTableColumnMap);
                }
                catch (Exception e) {
                    sb.append("---- Read a field error that already exists in the table. dbkey:").append(dbkey).append(",error:").append(e.getMessage());
                    sb.append(System.lineSeparator());
                }
                tabNameSB.delete(0, tabNameSB.length());
            }
            if (i > this.start && this.end != 0) {
                sb.append("---- use DBKey = ").append(dbkey).append(" table count:").append(tableFieldMap.size());
                sb.append(System.lineSeparator());
            }
            block8: for (Map.Entry entry2 : tableFieldMap.entrySet()) {
                String tableName = (String)entry2.getKey();
                if (StringUtils.isBlank((CharSequence)tableName)) continue;
                List fields = (List)entry2.getValue();
                for (MuliLangTextProp field : fields) {
                    if (StringUtils.isBlank((CharSequence)field.getAlias())) continue;
                    if (i > this.end && this.end != 0) continue block8;
                    if (this.end != 0 && i < this.start) continue;
                    boolean fieldExists = false;
                    List columns = (List)dbTableColumnMap.get(tableName);
                    if (columns == null) continue;
                    for (String column : columns) {
                        if (!column.equalsIgnoreCase(field.getAlias())) continue;
                        fieldExists = true;
                        break;
                    }
                    if (fieldExists) {
                        sb.append("-- table '").append(tableName).append("' not exists. Or field '").append(field.getAlias()).append("' of table '").append(tableName).append("' already exists.");
                        sb.append(System.lineSeparator());
                    } else {
                        int length = field.getMaxLenth();
                        if (length <= 0) {
                            length = 50;
                        }
                        sb.append("ALTER TABLE ").append(tableName).append(" ADD (").append(field.getAlias()).append(" NVARCHAR(").append(length).append(") DEFAULT ' ' NOT NULL );");
                        sb.append(System.lineSeparator());
                    }
                    String mainTableName = field.getParent().getAlias();
                    String mainPKName = field.getParent().getPrimaryKey().getAlias();
                    String mulTableName = ((DynamicObjectType)field.getParent()).getLocaleProperty().getDynamicCollectionItemPropertyType().getAlias();
                    if (i == this.start) {
                        sb.append("---- use DBKey = ").append(dbkey).append(" table count:").append(tableFieldMap.size());
                        sb.append(System.lineSeparator());
                    }
                    if ("mysql".equals(this.sqlType)) {
                        sb.append("update ").append(tableName).append(" A inner join ").append(mulTableName).append(" B on A.").append(mainPKName).append("=B.").append(mainPKName).append(" and B.FLOCALEID = 'zh_CN' set A.").append(field.getAlias()).append(" = B.").append(field.getAlias()).append(" where A.").append(field.getAlias()).append(" is null OR ").append("A.").append(field.getAlias()).append(" = ' ';");
                    } else {
                        sb.append("update ").append(tableName).append(" a set ").append(field.getAlias()).append(" = (select ").append(field.getAlias()).append(" from ").append(mulTableName).append(" where ").append(mainPKName).append("= a.").append(mainPKName).append(" and flocaleid = 'zh-CN') where exists (select 1 from ").append(mulTableName).append(" where ").append(mainPKName).append(" = a.").append(mainPKName).append(" and flocaleid = 'zh-CN');");
                    }
                    sb.append(System.lineSeparator());
                    ++i;
                }
            }
        }
        String str = sb.toString();
        sb.setLength(0);
        return str;
    }

    private void fillTableMuliLangField(boolean openGL, String routeKey, MainEntityType met, Map<String, Object> dbTableMap) {
        HashMap tableFieldMap = (HashMap)dbTableMap.get(routeKey);
        if (tableFieldMap == null) {
            tableFieldMap = new HashMap();
            dbTableMap.put(routeKey, tableFieldMap);
        }
        Collection allFields = met.getAllFields().values();
        for (IDataEntityProperty field : allFields) {
            if (!(field instanceof MuliLangTextProp)) continue;
            boolean isGl = ((MuliLangTextProp)field).isGL();
            if (openGL && !isGl) continue;
            String fieldName = field.getName();
            String tableName = field.getParent().getAlias();
            if (StringUtils.isBlank((CharSequence)tableName)) continue;
            ArrayList<MuliLangTextProp> fields = (ArrayList<MuliLangTextProp>)tableFieldMap.get(tableName);
            if (fields == null) {
                fields = new ArrayList<MuliLangTextProp>();
                tableFieldMap.put(tableName, fields);
            }
            boolean isExist = false;
            for (MuliLangTextProp mulProp : fields) {
                if (!StringUtils.isBlank((CharSequence)mulProp.getAlias()) && !mulProp.getAlias().equals(field.getAlias())) continue;
                isExist = true;
            }
            if (isExist) continue;
            fields.add((MuliLangTextProp)field);
        }
    }

    private void fillTableColumnMap(String dbkey, String tables, Map<String, List<String>> dbTableColumnMap) {
        String columnExistsSql = "SELECT KSQL_COL_TABNAME, KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME in (" + tables + ")";
        DB.query((DBRoute)DBRoute.of((String)dbkey), (String)columnExistsSql, rs -> {
            while (rs.next()) {
                String tn = rs.getString(1);
                String cn = rs.getString(2);
                List cols = dbTableColumnMap.computeIfAbsent(tn, k -> new ArrayList());
                cols.add(cn);
            }
            return null;
        });
    }

    @NotNull
    private ResultSetHandler<String> getMetHandle(Map<String, List<MainEntityType>> dbRouteEntityMap) {
        return rs -> {
            int i = 0;
            while (rs.next() && (++i <= this.dbEnd || this.dbEnd == 0)) {
                if (this.dbEnd != 0 && i < this.dbStart) continue;
                try {
                    MainEntityType dt = (MainEntityType)EntityItemTypes.fromJsonString((String)rs.getString(2));
                    String dbRoute = dt.getDBRouteKey();
                    List list = dbRouteEntityMap.computeIfAbsent(dbRoute, k -> new ArrayList());
                    list.add(dt);
                }
                catch (Exception e) {
                    log.error("EntityItemTypes.fromJsonString error. formnumber:" + rs.getString(1), (Throwable)e);
                }
            }
            return null;
        };
    }
}

