/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.debug.cmd;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.debug.cmd.DebugCommand;
import kd.bos.form.plugin.debug.cmd.DebugCommandContext;
import kd.bos.form.plugin.debug.executor.ExprExecutor;
import kd.bos.form.plugin.debug.executor.MethodExpr;

class VarCommand
extends DebugCommand {
    private String var;
    private String expr;
    private static String[] cmdtoken = new String[]{"a", "r"};

    public VarCommand(DebugCommandContext ctx, String[] cmdStrings) {
        super(ctx);
        this.initCmd(cmdStrings);
    }

    @Override
    public String exec() {
        if (this.getCmdParam().equals(cmdtoken[0])) {
            return this.addVar();
        }
        if (this.getCmdParam().equals(cmdtoken[1])) {
            return this.clearVar();
        }
        return "debug command does not match";
    }

    private Object execExpr() {
        try {
            MethodExpr methodExpr = MethodExpr.parseMethod(this.expr);
            HashMap<String, MethodExpr> varExprMap = new HashMap<String, MethodExpr>(this.getContext().getVarExprMap().size());
            for (Map.Entry<String, String> entry : this.getContext().getVarExprMap().entrySet()) {
                MethodExpr exprtmp = MethodExpr.parseMethod(entry.getValue());
                varExprMap.put(entry.getKey(), exprtmp);
            }
            return ExprExecutor.execMethodExpr(methodExpr, this.getContext().getFormView(), varExprMap);
        }
        catch (Exception e) {
            this.getContext().setErrInfo(e.getMessage());
            return null;
        }
    }

    @Override
    protected void initCmd(String[] cmdStrings) {
        super.initCmd(cmdStrings);
        String[] params = this.checkCmd(cmdStrings);
        this.checkCmdParam(params);
        this.var = params[0];
        if (params.length > 1) {
            this.expr = params[1];
        }
    }

    private String addVar() {
        try {
            this.getContext().addVar(this.var, this.expr);
        }
        catch (Exception e) {
            this.getContext().setErrInfo(e.getMessage());
        }
        return String.format("%s = %s finish!", this.var, this.expr);
    }

    private String clearVar() {
        this.getContext().removeVar(this.var);
        return String.format("%s remove finish!", this.var);
    }

    private String[] checkCmd(String[] cmdStrings) {
        if (cmdStrings.length < 3) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        String parameter = cmdStrings[2];
        if (StringUtils.isBlank((CharSequence)parameter)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command error."});
        }
        String[] params = parameter.split(":");
        if (params.length > 2) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command : 'var -a var:expr'."});
        }
        return params;
    }

    private void checkCmdParam(String[] params) {
        if ("r".equals(this.getCmdParam())) {
            if (params.length != 1) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"debug -r command does not match."});
            }
            return;
        }
        boolean isMatch = false;
        for (String str : cmdtoken) {
            if (!str.equals(this.getCmdParam())) continue;
            isMatch = true;
            break;
        }
        if (!isMatch) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"debug command does not match."});
        }
    }
}

