/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.encryption;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.servicehelper.EncryptDataServiceHelper;

public class EncryptDataRepairPlugin
extends AbstractFormPlugin
implements IConfirmCallBack {
    private static final String KEY_FIELDKEY = "fieldkey";
    private static final String KEY_FIELDNAME = "fieldname";
    private static final String KEY_ISHEADFIELD = "isheadfield";
    private static final String KEY_ENTRYKEY = "entrykey";
    private static final String KEY_FIELDTYPE = "fieldType";
    private static final String KEY_ISENCRYPT = "isencrypt";
    private static final String KEY_FORMNUMBER = "formnumber";
    private static final String KEY_BIZOBJECT = "bizobject";
    private static final String ACTID_REPAIRCONFIRM = "repairconfirm";
    private static final String ENTRYENTITY = "entryentity";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.lockHeadField();
    }

    private void lockHeadField() {
    }

    public void registerListener(EventObject e) {
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldId = e.getProperty().getName();
        if (KEY_BIZOBJECT.equals(fieldId)) {
            this.listEncryptField();
        }
    }

    private void listEncryptField() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(KEY_BIZOBJECT);
        if (dynamicObject == null) {
            return;
        }
        String number = dynamicObject.getString("number");
        if (StringUtils.isBlank((CharSequence)number)) {
            return;
        }
        String fid = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
        for (Entity entity : entityMetadata.getEntitys()) {
            if (entity instanceof MainEntity) {
                for (EntityItem entityItem : entity.getItems()) {
                    if (!(entityItem instanceof AmountField) && !(entityItem instanceof TextField) && !(entityItem instanceof ComboField) && !(entityItem instanceof DateTimeField)) continue;
                    this.addNewRow(entityItem.getKey(), entityItem.getName(), true, entityItem.getClass().getName().substring(entityItem.getClass().getName().lastIndexOf(".") + 1), "", ((Field)entityItem).isEncrypt());
                }
                continue;
            }
            for (EntityItem item : entity.getItems()) {
                if (!(item instanceof AmountField) && !(item instanceof TextField) && !(item instanceof ComboField) && !(item instanceof DateTimeField)) continue;
                this.addNewRow(item.getKey(), item.getName(), true, item.getClass().getName().substring(item.getClass().getName().lastIndexOf(".") + 1), entity.getKey(), ((Field)item).isEncrypt());
            }
        }
    }

    private void addNewRow(String fieldKey, LocaleString fieldname, boolean headField, String fieldType, String entrykey, boolean encrypt) {
        IDataModel model = this.getModel();
        int row = model.createNewEntryRow(ENTRYENTITY);
        model.setValue(KEY_FIELDKEY, (Object)fieldKey, row);
        model.setValue(KEY_FIELDNAME, (Object)fieldname, row);
        model.setValue(KEY_ISHEADFIELD, (Object)headField, row);
        model.setValue(KEY_FIELDTYPE, (Object)fieldType, row);
        model.setValue(KEY_ENTRYKEY, (Object)entrykey, row);
        model.setValue(KEY_ISENCRYPT, (Object)encrypt, row);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"close", (CharSequence)operate.getOperateKey())) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int row = entryGrid.getEntryState().getFocusRow();
        String fieldKey = (String)this.getModel().getValue(KEY_FIELDKEY, row);
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(KEY_BIZOBJECT);
        String formNumber = dynamicObject.getString("number");
        HashMap<String, String> callbackValue = new HashMap<String, String>();
        callbackValue.put(KEY_FIELDKEY, fieldKey);
        callbackValue.put(KEY_FORMNUMBER, formNumber);
        boolean isEncrypt = (Boolean)this.getModel().getValue(KEY_ISENCRYPT, row);
        if (isEncrypt) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ACTID_REPAIRCONFIRM, (IConfirmCallBack)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u8981\u4fee\u590d %1$s\u8868\u5355\u7684 %2$s\u52a0\u5bc6\u5b57\u6bb5\u6570\u636e", (String)"EncryptDataRepairPlugin_0", (String)"bos-form-business", (Object[])new Object[0]), formNumber, fieldKey), null, MessageBoxOptions.OKCancel, null, confirmCallBacks, null, SerializationUtils.toJsonString(callbackValue));
        } else {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("showmessage", (IConfirmCallBack)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b57\u6bb5\u672a\u52a0\u5bc6\uff0c\u65e0\u9700\u4fee\u590d", (String)"EncryptDataRepairPlugin_1", (String)"bos-form-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (ACTID_REPAIRCONFIRM.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            Map value = (Map)SerializationUtils.fromJsonString((String)messageBoxClosedEvent.getCustomVaule(), Map.class);
            EncryptDataServiceHelper.repairEncrptyData((String)((String)value.get(KEY_FORMNUMBER)), (String)((String)value.get(KEY_FIELDKEY)));
        }
    }
}

