/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.lightlayout;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.form.plugin.lightlayout.IFormMetaUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import org.jetbrains.annotations.Nullable;

class FormMetaUtil
implements IFormMetaUtil {
    FormMetaUtil() {
    }

    @Override
    public FormMetadata getFormMetadata(String formId) {
        return FormMetaUtil.getMetadata(formId, this.getLastExtId(formId));
    }

    private String getLastExtId(String formId) {
        String masterId = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        String sql = "select fid from t_meta_formdesign where (fmasterid  =? or fid = ?)\nand fisv <> 'kdprod'\norder by finheritpath desc ";
        Object[] parameter = new SqlParameter[]{new SqlParameter("masterid", 12, (Object)masterId), new SqlParameter("masterid", 12, (Object)masterId)};
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameter, rs -> {
            if (rs.next()) {
                return rs.getString("fid");
            }
            return null;
        });
    }

    private String getLightExtId(String formId) {
        String masterId = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        String sql = "select fid from t_meta_formdesign where (fmasterid  =? or fid = ?)\nand fisv = 'kdprod'\norder by finheritpath desc ";
        Object[] parameter = new SqlParameter[]{new SqlParameter("masterid", 12, (Object)masterId), new SqlParameter("masterid", 12, (Object)masterId)};
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameter, rs -> {
            if (rs.next()) {
                return rs.getString("fid");
            }
            return null;
        });
    }

    @Nullable
    private static FormMetadata getMetadata(String formId, String id) {
        if (id != null) {
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
            String masterId = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
            if (!id.equals(masterId)) {
                FormMetadata masterFormMetadata = (FormMetadata)MetadataDao.readMeta((String)masterId, (MetaCategory)MetaCategory.Form);
                formMetadata.setKey(masterFormMetadata.getKey());
                formMetadata.setName(masterFormMetadata.getName());
            }
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)formMetadata.getEntityId(), (MetaCategory)MetaCategory.Entity);
            formMetadata.bindEntityMetadata(entityMetadata);
            return formMetadata;
        }
        return null;
    }

    @Override
    public FormMetadata getLightFormMetadata(String formId) {
        return FormMetaUtil.getMetadata(formId, this.getLightExtId(formId));
    }

    @Override
    public boolean isLastExtMetdata(String formId) {
        String masterId = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isNotBlank((CharSequence)masterId)) {
            String sql = " select fid,fisv,fparentid from t_meta_formdesign where  fmasterid  =?  and ftype = '2'order by finheritpath desc ";
            Object[] parameter = new SqlParameter[]{new SqlParameter("masterid", 12, (Object)masterId)};
            return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameter, rs -> {
                String parentId = "";
                while (rs.next()) {
                    if ("kdprod".equals(rs.getString("fisv"))) {
                        parentId = rs.getString("fparentid");
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)parentId) || !parentId.equals(rs.getString("fparentid"))) continue;
                    return false;
                }
                return true;
            });
        }
        return true;
    }
}

