/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.lightlayout;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;

public class LightLayoutDeleteServicePlugin
extends AbstractOperationServicePlugIn {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String KEY_SUCCESS = "success";
    private static final String MESSAGE = "message";
    private IMetadataDao metadataDao = new IMetadataDao(){

        @Override
        public void clearSubRuntimeMeta(List<String> formIds) {
            MetadataDao.clearSubRuntimeMeta(formIds);
        }

        @Override
        public String getIdByNumber(String number, MetaCategory category) {
            return MetadataDao.getIdByNumber((String)number, (MetaCategory)category);
        }

        @Override
        public void rebuildRuntimeMetaById(String id) {
            MetadataDao.rebuildRuntimeMetaById((String)id);
        }

        @Override
        public AbstractMetadata readMeta(String id, MetaCategory category) {
            return MetadataDao.readMeta((String)id, (MetaCategory)category);
        }

        @Override
        public Map<String, Object> delFormMetadata(String id) {
            return MetadataDao.delFormMetadata((String)id);
        }
    };

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                DynamicObject[] dataEntitys;
                for (DynamicObject dataEntity : dataEntitys = e.getDataEntities()) {
                    String id = String.valueOf(dataEntity.getPkValue());
                    Map<String, Object> result = this.metadataDao.delFormMetadata(id);
                    if (result.get(KEY_SUCCESS) != null) {
                        String returnInfo = "";
                        if (!((Boolean)result.get(KEY_SUCCESS)).booleanValue()) {
                            returnInfo = result.get(MESSAGE) != null ? (String)result.get(MESSAGE) : ResManager.loadKDString((String)"\u5143\u6570\u636e\u6709\u4f9d\u8d56\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"LightLayoutDeleteServicePlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
                            throw new KDException(BosErrorCode.deleteFailed, new Object[]{returnInfo});
                        }
                    }
                    ArrayList<String> idList = new ArrayList<String>();
                    String number = dataEntity.getString("number");
                    String masterID = this.metadataDao.getIdByNumber(number, MetaCategory.Form);
                    idList.add(masterID);
                    this.metadataDao.clearSubRuntimeMeta(idList);
                    this.metadataDao.rebuildRuntimeMetaById(masterID);
                }
                txHandle.commit();
            }
            catch (Exception ex) {
                txHandle.markRollback();
                throw ex;
            }
        }
    }

    static interface IMetadataDao {
        public void clearSubRuntimeMeta(List<String> var1);

        public String getIdByNumber(String var1, MetaCategory var2);

        public void rebuildRuntimeMetaById(String var1);

        public AbstractMetadata readMeta(String var1, MetaCategory var2);

        public Map<String, Object> delFormMetadata(String var1);
    }
}

