/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.lightlayout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.SetEntryBottom;
import kd.bos.form.operate.SetEntryTop;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.lightlayout.FormMetaUtil;
import kd.bos.form.plugin.lightlayout.IFormMetaUtil;
import kd.bos.form.plugin.lightlayout.LightLayoutUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.commonfield.TimeField;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.list.ListCardViewAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metadata.list.ListGridViewAp;
import kd.bos.orm.util.CollectionUtils;

public class LightLayoutEditPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TabSelectListener {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    public static final String TREEVIEWAP = "treeviewap";
    public static final String LAYOUTTYPE = "layouttype";
    public static final String LISTLAYOUTTYPE = "listlayouttype";
    public static final String BILLENTRY = "billentry";
    public static final String LISTENTRY = "listentry";
    private FormMetadata formMetadata;
    private static final Set<String> DISPLAY2STORE_BILL = new HashSet<String>();
    private static final Set<String> DISPLAY2STORE_LIST = new HashSet<String>();
    private static final String PREV_FOCUS_NODEID = "prefocusnodeid";
    private static final String CUR_TAB = "curtab";
    private IFormMetaUtil iFormMetaUtil = new FormMetaUtil();

    public void registerListener(EventObject e) {
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"fielddefvalue"});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addItemClickListeners(new String[]{"billtool", "listtool"});
        Listbox listbox = (Listbox)this.getControl("listboxap");
        listbox.addListboxClickListener(new ListboxClickListener(){

            public void listboxClick(ListboxEvent event) {
                String itemId = event.getItemId();
                Tab tab = (Tab)LightLayoutEditPlugin.this.getControl("tabap");
                tab.activeTab(itemId);
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        String entryKey = "tabbill".equals(this.getPageCache().get(CUR_TAB)) ? BILLENTRY : LISTENTRY;
        switch (key) {
            case "listentrytop": {
                this.setTop(entryKey);
                break;
            }
            case "listentrybottom": {
                this.setButtom(entryKey);
                break;
            }
            case "btnmoveup": {
                String opKey = entryKey.equals(BILLENTRY) ? "moveentryupbill" : "moveentryuplist";
                this.getView().invokeOperation(opKey);
                break;
            }
            case "btnmovedown": {
                String opKey = entryKey.equals(BILLENTRY) ? "moveentrydownbill" : "moveentrydownlist";
                this.getView().invokeOperation(opKey);
            }
        }
    }

    private FormMetadata getMetadata(boolean isBill) {
        if (this.formMetadata == null) {
            this.formMetadata = this.initMetadata();
        }
        if (this.formMetadata == null) {
            return null;
        }
        if (isBill) {
            String layoutType = (String)this.getModel().getValue(LAYOUTTYPE);
            if ("mobile".equals(layoutType)) {
                BillFormAp rootAp = (BillFormAp)this.formMetadata.getRootAp();
                if (rootAp.getMobMeta() != null) {
                    rootAp.getMobMeta().bindEntityMetadata(this.formMetadata.getEntityMetadata());
                }
                return this.ensureCreateIndex(rootAp.getMobMeta());
            }
            return this.ensureCreateIndex(this.formMetadata);
        }
        String layoutType = (String)this.getModel().getValue(LISTLAYOUTTYPE);
        BillFormAp rootAp = (BillFormAp)this.formMetadata.getRootAp();
        if ("mobile".equals(layoutType)) {
            return this.ensureCreateIndex(rootAp.getMobListMeta());
        }
        return this.ensureCreateIndex(rootAp.getListMeta());
    }

    private FormMetadata ensureCreateIndex(FormMetadata formMetadata) {
        if (formMetadata != null) {
            formMetadata.createIndex();
        }
        return formMetadata;
    }

    public void click(EventObject evt) {
        String btnKey = ((Control)evt.getSource()).getKey();
        if ("fielddefvalue".equals(btnKey)) {
            int row = this.getModel().getEntryCurrentRowIndex(BILLENTRY);
            String controlId = (String)this.getModel().getValue("controlid", row);
            FormMetadata metadata = this.getMetadata(true);
            if (metadata == null) {
                return;
            }
            FieldAp fieldAp = (FieldAp)metadata.getItem(controlId);
            if (fieldAp.getField().getDefValueType() == 2) {
                FormShowParameter parameter = this.createDefValueEditFormShowParatemer(row, fieldAp.getField().getClass().getSimpleName());
                this.getView().showForm(parameter);
            }
        }
    }

    private FormShowParameter createDefValueEditFormShowParatemer(int row, String fieldType) {
        MainEntityType dt;
        IDataEntityProperty prop;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_defaultvalueedit");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> mockContext = new HashMap<String, Object>();
        mockContext.put("_Type_", fieldType);
        String fieldKey = this.getModel().getValue("fieldkey", row).toString();
        mockContext.put("Key", fieldKey);
        mockContext.put("FormId", this.formMetadata.getKey());
        String defValueDesign = (String)this.getModel().getValue("fielddefvaluedesign");
        if (StringUtils.isNotBlank((CharSequence)defValueDesign)) {
            mockContext.put("DefValueDesign", SerializationUtils.fromJsonString((String)defValueDesign, Map.class));
        }
        if ((prop = (IDataEntityProperty)(dt = EntityMetadataCache.getDataEntityType((String)this.formMetadata.getKey())).getAllFields().get(fieldKey)) instanceof MulBasedataProp) {
            mockContext.put("BaseEntityId", ((MulBasedataProp)prop).getBaseEntityId());
        } else if (prop instanceof BasedataProp) {
            String id = MetadataDao.getIdByNumber((String)((BasedataProp)prop).getBaseEntityId(), (MetaCategory)MetaCategory.Entity);
            mockContext.put("BaseEntityId", id);
            FilterCondition filterCondition = EntityMetadataCache.getBaseDataFieldFilterMeta((String)this.formMetadata.getKey(), (String)prop.getName());
            if (filterCondition != null && filterCondition.getFilterRow() != null && !filterCondition.getFilterRow().isEmpty()) {
                ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
                dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
                Map condition = new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, dts)).serializeToMap((Object)filterCondition, null);
                mockContext.put("Filter", condition);
            }
            parameter.setCustomParam("propertyName", (Object)"DefValueDesign");
        } else if (prop instanceof DateTimeProp) {
            parameter.setCustomParam("propertyName", (Object)"DefValueDesign");
        }
        if (prop instanceof AssistantProp) {
            mockContext.put("AsstTypeId", ((AssistantProp)prop).getAsstTypeId());
        }
        parameter.setCustomParam("context", Collections.singletonList(mockContext));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fielddefvalue"));
        return parameter;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        if ("fielddefvalue".equals(evt.getActionId()) && (returnData = evt.getReturnData()) != null) {
            Map data = (Map)returnData;
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(BILLENTRY);
            Map<String, Object> defValueFromMap = LightLayoutUtil.getDefValueFromMap(data);
            this.getModel().setValue("fielddefvalue", defValueFromMap.get("fielddefvalue"), entryCurrentRowIndex);
            if (defValueFromMap.containsKey("fielddefvaluedesign")) {
                this.getModel().setValue("fielddefvaluedesign", defValueFromMap.get("fielddefvaluedesign"), entryCurrentRowIndex);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals(LAYOUTTYPE)) {
            String nodeId = this.getView().getPageCache().get(PREV_FOCUS_NODEID);
            this.buildStoreData_Bill(nodeId);
            FormMetadata formMetadata = this.getMetadata(true);
            this.initTreeViewAndBillEntry(formMetadata);
        } else if (e.getProperty().getName().equals(LISTLAYOUTTYPE)) {
            this.buildStoreData_List((String)e.getChangeSet()[0].getOldValue());
            FormMetadata formMetadata = this.getMetadata(false);
            this.initListEntry(formMetadata);
        } else if (e.getProperty().getName().equals("layouttype_d")) {
            this.getModel().setValue(LAYOUTTYPE, this.getModel().getValue("layouttype_d"));
            this.getModel().setValue(LISTLAYOUTTYPE, this.getModel().getValue("layouttype_d"));
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String lastNodeId = this.getView().getPageCache().get(PREV_FOCUS_NODEID);
        String nodeId = (String)evt.getNodeId();
        if (!nodeId.equals(lastNodeId)) {
            this.buildStoreData_Bill(lastNodeId);
            FormMetadata formMetadata = this.getMetadata(true);
            this.initBillEntry(nodeId, formMetadata);
            this.getPageCache().put(PREV_FOCUS_NODEID, nodeId);
        }
    }

    private void fillFieldList(Consumer<ControlAp<?>> visitControl, ContainerAp<?> containerAp, boolean includeChildContainer) {
        for (ControlAp controlAp : containerAp.getItems()) {
            if (!this.isVisibleControl(controlAp)) continue;
            visitControl.accept((Object)controlAp);
            if (!(controlAp instanceof EntryFieldGroupAp) && (!(controlAp instanceof ContainerAp) || !includeChildContainer)) continue;
            this.fillFieldList(visitControl, (ContainerAp)controlAp, includeChildContainer);
        }
    }

    private void initBillEntry(String nodeId, FormMetadata formMetadata) {
        this.getModel().deleteEntryData(BILLENTRY);
        if (StringUtils.isBlank((CharSequence)nodeId) || formMetadata == null) {
            return;
        }
        this.getModel().beginInit();
        ContainerAp item = (ContainerAp)formMetadata.getItem(nodeId);
        ArrayList fieldApList = new ArrayList(16);
        this.fillFieldList(c -> {
            if (c instanceof FieldAp && ((FieldAp)c).getField() != null) {
                fieldApList.add(new FieldApHolder((FieldAp)c, null, this));
            }
        }, item, false);
        if (!fieldApList.isEmpty()) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("billentry_s");
            ArrayList storeList = new ArrayList(rows.size());
            rows.forEach(row -> {
                if (row.getString("treenodeid").equals(nodeId)) {
                    storeList.add(new FieldApHolder(null, (DynamicObject)row, this));
                }
            });
            List resultList = this.sortData(storeList, fieldApList);
            HashMap map = new HashMap(fieldApList.size());
            fieldApList.forEach(o -> map.put(o, o));
            resultList.forEach(o -> o.setFieldAp(((FieldApHolder)map.get(o)).getFieldAp()));
            this.getModel().batchCreateNewEntryRow(BILLENTRY, fieldApList.size());
            int i = 0;
            HashMap<String, Integer> controlMap = new HashMap<String, Integer>(16);
            for (FieldApHolder fieldApHolder : resultList) {
                this.getModel().setValue("fieldkey", (Object)fieldApHolder.getFieldKey(), i);
                this.getModel().setValue("fieldname", (Object)fieldApHolder.getName(), i);
                this.getModel().setValue("fielddspname", (Object)fieldApHolder.getDspName(), i);
                this.getModel().setValue("fieldmustinput", (Object)fieldApHolder.getMustInput(), i);
                this.getModel().setValue("controlid", (Object)fieldApHolder.getId(), i);
                this.getModel().setValue("fieldid", (Object)fieldApHolder.getFieldId(), i);
                if (fieldApHolder.getSystemMustInput() || this.isLayout()) {
                    this.lockCell("fieldmustinput", i);
                }
                this.getModel().setValue("fielddefvalue", (Object)fieldApHolder.getDefValue(), i);
                this.getModel().setValue("fielddefvaluedesign", (Object)fieldApHolder.getDefValueDesign(), i);
                if (this.isLayout()) {
                    this.lockCell("fielddefvalue", i);
                }
                int finalI = i;
                LightLayoutUtil.LOCK2STATUS.forEach((key, value) -> {
                    String propName = value.substring(0, value.length() - 2);
                    this.getModel().setValue(propName, (Object)fieldApHolder.getLock((String)key), finalI);
                    if (fieldApHolder.getSystemLock((String)key)) {
                        this.lockCell(propName, finalI);
                    }
                });
                LightLayoutUtil.VISIBLE2STATUS.forEach((key, value) -> {
                    String propName = value.substring(0, value.length() - 2);
                    this.getModel().setValue(propName, (Object)fieldApHolder.getVisible((String)key), finalI);
                    if (!fieldApHolder.getSystemVisible((String)key)) {
                        this.lockCell(propName, finalI);
                    }
                });
                if (fieldApHolder.getDefValueType() == 0) {
                    this.lockCell("fielddefvalue", finalI);
                }
                controlMap.put(fieldApHolder.getId(), i);
                ++i;
            }
            String s = this.getPageCache().get("loadnodeid_" + nodeId);
            if (StringUtils.isBlank((CharSequence)s)) {
                BillFormAp rootAp;
                this.getPageCache().put("loadnodeid_" + nodeId, "1");
                FormMetadata metadata = this.iFormMetaUtil.getLightFormMetadata((String)this.getModel().getValue("number"));
                String layoutType = (String)this.getModel().getValue(LAYOUTTYPE);
                if (metadata != null && "mobile".equals(layoutType) && (rootAp = (BillFormAp)metadata.getRootAp()) != null) {
                    metadata = rootAp.getMobMeta();
                }
                if (metadata != null) {
                    metadata.createIndex();
                    for (Map.Entry keyValue : controlMap.entrySet()) {
                        ControlAp controlAp = metadata.getItem((String)keyValue.getKey());
                        if (controlAp == null) continue;
                        LightLayoutUtil.LOCK2STATUS.forEach((key, value) -> {
                            String propName = value.substring(0, value.length() - 2);
                            this.getModel().setValue(propName, (Object)controlAp.getLock().contains((CharSequence)key), ((Integer)keyValue.getValue()).intValue());
                        });
                        LightLayoutUtil.VISIBLE2STATUS.forEach((key, value) -> {
                            String propName = value.substring(0, value.length() - 2);
                            this.getModel().setValue(propName, (Object)controlAp.getVisible().contains((CharSequence)key), ((Integer)keyValue.getValue()).intValue());
                        });
                    }
                }
            }
        }
        this.getModel().endInit();
        this.getView().updateView(BILLENTRY);
    }

    private boolean isLayout() {
        return "Layout".equals(this.getModel().getValue("type"));
    }

    private void lockCell(String key, int row) {
        FieldEdit cellEdit = (FieldEdit)this.getView().getControl(key);
        cellEdit.setEnable("", false, row);
    }

    private void initListEntry(FormMetadata formMetadata) {
        this.getModel().deleteEntryData(LISTENTRY);
        if (formMetadata == null || formMetadata.getItems().isEmpty()) {
            return;
        }
        String layoutType = (String)this.getModel().getValue(LISTLAYOUTTYPE);
        ContainerAp containerAp = null;
        for (ControlAp item : formMetadata.getItems()) {
            if ("mobile".equals(layoutType)) {
                if (!(item instanceof ListCardViewAp)) continue;
                containerAp = (ContainerAp)item;
                break;
            }
            if (!(item instanceof ListGridViewAp)) continue;
            containerAp = (ContainerAp)item;
            break;
        }
        if (containerAp == null) {
            return;
        }
        ArrayList listColumnApList = new ArrayList(16);
        this.fillFieldList(c -> {
            if (c instanceof ListColumnAp && !"seq".equals(c.getKey()) && !"fseq".equals(((ListColumnAp)c).getListFieldId())) {
                listColumnApList.add(new ListColumnApHolder((ListColumnAp)c, null, this));
            }
        }, containerAp, true);
        if (listColumnApList.isEmpty()) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("listentry_s");
        ArrayList storeList = new ArrayList(rows.size());
        rows.forEach(row -> {
            if (row.getString("listlayouttype_s").equals(layoutType)) {
                storeList.add(new ListColumnApHolder(null, (DynamicObject)row, this));
            }
        });
        List resultList = this.sortData(storeList, listColumnApList);
        HashMap map = new HashMap(listColumnApList.size());
        listColumnApList.forEach(o -> map.put(o, o));
        resultList.forEach(o -> o.setFieldAp(((ListColumnApHolder)map.get(o)).getFieldAp()));
        this.getModel().batchCreateNewEntryRow(LISTENTRY, listColumnApList.size());
        int i = 0;
        this.getModel().beginInit();
        HashMap<String, Integer> controlMap = new HashMap<String, Integer>(16);
        for (ListColumnApHolder item : resultList) {
            this.getModel().setValue("listkey", item.getListFieldId(), i);
            this.getModel().setValue("listcontrolid", (Object)item.getId(), i);
            this.getModel().setValue("listname", (Object)item.getName(), i);
            this.getModel().setValue("listdspname", (Object)item.getDspName(), i);
            this.getModel().setValue("listviinit", (Object)item.getVisible("default"), i);
            this.getModel().setValue("listvif7", (Object)item.getVisible("lookup"), i);
            controlMap.put(item.getId(), i);
            ++i;
        }
        String s = this.getPageCache().get("loadlayoutType_" + layoutType);
        if (StringUtils.isBlank((CharSequence)s)) {
            BillFormAp rootAp;
            this.getPageCache().put("loadlayoutType_" + layoutType, "1");
            FormMetadata metadata = this.iFormMetaUtil.getLightFormMetadata((String)this.getModel().getValue("number"));
            if (metadata != null && (rootAp = (BillFormAp)metadata.getRootAp()) != null) {
                metadata = "mobile".equals(layoutType) ? rootAp.getMobListMeta() : rootAp.getListMeta();
            }
            if (metadata != null) {
                metadata.createIndex();
                for (Map.Entry keyValue : controlMap.entrySet()) {
                    ControlAp controlAp = metadata.getItem((String)keyValue.getKey());
                    if (controlAp == null) continue;
                    this.getModel().setValue("listviinit", (Object)controlAp.getVisible().contains("default"), ((Integer)keyValue.getValue()).intValue());
                    this.getModel().setValue("listvif7", (Object)controlAp.getVisible().contains("lookup"), ((Integer)keyValue.getValue()).intValue());
                }
            }
        }
        this.getModel().endInit();
        this.getView().updateView(LISTENTRY);
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put(CUR_TAB, "tabbill");
        super.afterCreateNewData(e);
        FormMetadata metadata = this.getMetadata(true);
        this.setHeader(metadata);
        FormMetadata listMeatData = this.getMetadata(false);
        this.initListEntry(listMeatData);
    }

    public void afterBindData(EventObject e) {
        this.getPageCache().put(CUR_TAB, "tabbill");
        FormMetadata metadata = this.getMetadata(true);
        this.initTreeViewAndBillEntry(metadata);
        metadata = this.getMetadata(false);
        this.initListEntry(metadata);
        this.getModel().setValue("layouttype_d", this.getModel().getValue(LAYOUTTYPE));
        this.getModel().setDataChanged(false);
        this.showExtMetaNotice();
        Listbox listbox = (Listbox)this.getControl("listboxap");
        ArrayList<ListboxItem> list = new ArrayList<ListboxItem>();
        ListboxItem item = new ListboxItem();
        item.setId("tabbill");
        item.setContent(ResManager.loadKDString((String)"\u8868\u5355\u8bbe\u7f6e", (String)"LightLayoutEditPlugin_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        list.add(item);
        ListboxItem item2 = new ListboxItem();
        item2.setId("tablist");
        item2.setContent(ResManager.loadKDString((String)"\u5217\u8868\u8bbe\u7f6e", (String)"LightLayoutEditPlugin_6", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        list.add(item2);
        listbox.addItems(list);
        ComboEdit layout = (ComboEdit)this.getControl("layouttype_d");
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(16);
        LocaleString caption = new LocaleString(ResManager.loadKDString((String)"PC\u7aef", (String)"LightLayoutEditPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        itemList.add(new ComboItem(caption, "pc"));
        BillFormAp rootAp = (BillFormAp)this.formMetadata.getRootAp();
        if (rootAp.getMobMeta() != null) {
            caption = new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef", (String)"LightLayoutEditPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            itemList.add(new ComboItem(caption, "mobile"));
        }
        layout.setComboItems(itemList);
    }

    private void showExtMetaNotice() {
        String formId = (String)this.getModel().getValue("number");
        if (!this.iFormMetaUtil.isLastExtMetdata(formId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5143\u6570\u636e\u5b58\u5728\u65b0\u6269\u5c55\uff0c\u53ef\u80fd\u4e0e\u8f7b\u91cf\u7ea7\u6269\u5c55\u51b2\u7a81\uff0c\u8bf7\u5220\u9664\u8f7b\u91cf\u7ea7\u6269\u5c55\u6570\u636e\uff0c\u91cd\u65b0\u6269\u5c55\u3002", (String)"LightLayoutEditPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setSkipNoField(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        AbstractOperate source = (AbstractOperate)evt.getSource();
        if ("save".equals(source.getOperateKey()) || "saveandnew".equals(source.getOperateKey()) || "subimt".equals(source.getOperateKey()) || "saveandpreview".equals(source.getOperateKey())) {
            this.buildStoreData_Bill(this.getView().getPageCache().get(PREV_FOCUS_NODEID));
            this.buildStoreData_List((String)this.getModel().getValue(LISTLAYOUTTYPE));
            if ("saveandpreview".equals(source.getOperateKey())) {
                this.getView().invokeOperation("save");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        AbstractOperate source = (AbstractOperate)evt.getSource();
        if ("saveandpreview".equals(source.getOperateKey())) {
            this.delay(1000L);
            String number = (String)this.getModel().getValue("number");
            this.preview(number);
        }
        if ("save".equals(source.getOperateKey()) || "saveandnew".equals(source.getOperateKey()) || "subimt".equals(source.getOperateKey())) {
            FormMetadata metadata = this.getMetadata(true);
            this.initTreeViewAndBillEntry(metadata);
            metadata = this.getMetadata(false);
            this.initListEntry(metadata);
            this.getModel().setDataChanged(false);
        }
    }

    private void delay(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void preview(String number) {
        String value;
        String curTab = this.getPageCache().get(CUR_TAB);
        if (StringUtils.isBlank((CharSequence)curTab)) {
            curTab = "tabbill";
        }
        LightLayoutUtil.PREVIEW_TYPE previewType = "tabbill".equals(curTab) ? ("pc".equals(value = (String)this.getModel().getValue(LAYOUTTYPE)) ? LightLayoutUtil.PREVIEW_TYPE.billpreview : LightLayoutUtil.PREVIEW_TYPE.mobilepreview) : ("pc".equals(value = (String)this.getModel().getValue(LISTLAYOUTTYPE)) ? LightLayoutUtil.PREVIEW_TYPE.listpreview : LightLayoutUtil.PREVIEW_TYPE.mobilelistpreview);
        FormShowParameter parameter = LightLayoutUtil.preview(number, previewType);
        if (parameter != null) {
            this.getView().showForm(parameter);
        }
    }

    private FormMetadata initMetadata() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formid");
        FormMetadata ret = this.iFormMetaUtil.getFormMetadata(formId);
        if (ret == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u65e0\u6cd5\u8bfb\u53d6\u5143\u6570\u636e\u3002", (String)"LightLayoutEditPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
        return ret;
    }

    private void setHeader(FormMetadata metadata) {
        if (metadata == null) {
            return;
        }
        this.getModel().setValue("number", (Object)metadata.getKey());
        this.getModel().setValue("name", (Object)metadata.getName());
        this.getModel().setValue("type", (Object)(metadata.getId().equals(metadata.getEntityId()) ? metadata.getModelType() : "Layout"));
    }

    private void initTreeViewAndBillEntry(FormMetadata metadata) {
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        treeView.deleteAllNodes();
        this.getView().getPageCache().put(PREV_FOCUS_NODEID, "");
        this.getModel().deleteEntryData(BILLENTRY);
        if (metadata == null) {
            return;
        }
        Collection<ContainerAp<?>> leafContainer = this.getLeafContainer(null, (ContainerAp<?>)metadata.getRootAp());
        if (leafContainer.isEmpty()) {
            return;
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(16);
        for (ContainerAp<?> containerAp : leafContainer) {
            TreeNode node = new TreeNode();
            node.setId(containerAp.getId());
            node.setText(containerAp.getName() == null ? ResManager.loadKDString((String)"\u672a\u547d\u540d", (String)"LightLayoutEditPlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]) : containerAp.getName().toString());
            nodeList.add(node);
        }
        treeView.addNodes(nodeList);
        treeView.focusNode((TreeNode)nodeList.get(0));
        this.getView().getPageCache().put(PREV_FOCUS_NODEID, ((TreeNode)nodeList.get(0)).getId());
        this.initBillEntry(((TreeNode)nodeList.get(0)).getId(), metadata);
    }

    private Collection<ContainerAp<?>> getLeafContainer(Map<String, ContainerAp<?>> mapContainer, ContainerAp<?> containerAp) {
        if (CollectionUtils.isEmpty((Collection)containerAp.getItems())) {
            return Collections.emptyList();
        }
        if (mapContainer == null) {
            mapContainer = new LinkedHashMap(16);
        }
        for (ControlAp item : containerAp.getItems()) {
            if (!(item instanceof FieldAp) || !this.isVisibleControl(item) || StringUtils.isBlank((CharSequence)item.getVisible()) || ((FieldAp)item).getField() == null || !this.isVisibleControl((ControlAp<?>)containerAp)) continue;
            mapContainer.put(containerAp.getId(), containerAp);
            break;
        }
        for (ControlAp item : containerAp.getItems()) {
            if (!(item instanceof ContainerAp) || item instanceof EntryFieldGroupAp) continue;
            this.getLeafContainer(mapContainer, (ContainerAp)item);
        }
        return mapContainer.values();
    }

    private boolean isVisibleControl(ControlAp<?> controlAp) {
        return !controlAp.isInvisible() && !controlAp.isHidden();
    }

    private void buildStoreData_Bill(String nodeId) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.buildStoreData(dataEntity, nodeId, "treenodeid", BILLENTRY, DISPLAY2STORE_BILL);
    }

    private void buildStoreData_List(String layoutType) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.buildStoreData(dataEntity, layoutType, "listlayouttype_s", LISTENTRY, DISPLAY2STORE_LIST);
    }

    private void buildStoreData(DynamicObject dataEntity, String group, String groupKey, String rowsKey, Set<String> map2Store) {
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection(rowsKey + "_s");
        rows.removeIf(row -> group.equals(row.getString(groupKey)));
        DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection(rowsKey);
        for (DynamicObject entry : entrys) {
            DynamicObject newRow = rows.addNew();
            newRow.set(groupKey, (Object)group);
            for (String key : map2Store) {
                newRow.set(key + "_s", entry.get(key));
            }
        }
        this.setSeq(0, rows, (IDataEntityType)rows.getDynamicObjectType());
    }

    private void setSeq(int start, DynamicObjectCollection cols, IDataEntityType dt) {
        IDataEntityProperty propSeq = (IDataEntityProperty)dt.getProperties().get((Object)"seq");
        if (propSeq != null) {
            for (int i = 0; i < cols.size(); ++i) {
                propSeq.setValueFast(cols.get(i), (Object)(start + i + 1));
            }
        }
    }

    <T> List<T> sortData(List<T> storeList, List<T> sourceList) {
        HashSet sourceSet = new HashSet(sourceList.size());
        sourceSet.addAll(sourceList);
        ArrayList<T> resultList = new ArrayList<T>(storeList);
        resultList.removeIf(key -> !sourceSet.contains(key));
        HashSet<T> resultSet = new HashSet<T>(resultList.size());
        resultSet.addAll(resultList);
        HashSet skipSet = new HashSet(16);
        int currentIndex = 0;
        block0: for (T src : sourceList) {
            if (!resultSet.contains(src)) {
                resultList.add(currentIndex, src);
                ++currentIndex;
                continue;
            }
            if (skipSet.contains(src)) continue;
            for (int i = currentIndex; i < resultList.size(); ++i) {
                if (src.equals(resultList.get(i))) {
                    currentIndex = i + 1;
                    continue block0;
                }
                skipSet.add(resultList.get(i));
            }
        }
        return resultList;
    }

    public void tabSelected(TabSelectEvent evt) {
        this.getPageCache().put(CUR_TAB, evt.getTabKey());
    }

    private void setTop(String entryKey) {
        SetEntryTop setEntryTop = new SetEntryTop(entryKey, this.getView());
        setEntryTop.invokeOperation();
    }

    private void setButtom(String entryKey) {
        SetEntryBottom setEntryBottom = new SetEntryBottom(entryKey, this.getView());
        setEntryBottom.invokeOperation();
    }

    static {
        DISPLAY2STORE_BILL.add("fieldkey");
        DISPLAY2STORE_BILL.add("fielddspname");
        DISPLAY2STORE_BILL.add("fieldmustinput");
        DISPLAY2STORE_BILL.add("fielddefvalue");
        DISPLAY2STORE_BILL.add("fielddefvaluedesign");
        DISPLAY2STORE_BILL.add("controlid");
        DISPLAY2STORE_BILL.add("fieldid");
        DISPLAY2STORE_BILL.add("locknew");
        DISPLAY2STORE_BILL.add("lockmodify");
        DISPLAY2STORE_BILL.add("locksubmit");
        DISPLAY2STORE_BILL.add("lockaudit");
        DISPLAY2STORE_BILL.add("viinit");
        DISPLAY2STORE_BILL.add("vinew");
        DISPLAY2STORE_BILL.add("vimodify");
        DISPLAY2STORE_BILL.add("viview");
        DISPLAY2STORE_BILL.add("visubmit");
        DISPLAY2STORE_BILL.add("viaudit");
        DISPLAY2STORE_LIST.add("listkey");
        DISPLAY2STORE_LIST.add("listcontrolid");
        DISPLAY2STORE_LIST.add("listdspname");
        DISPLAY2STORE_LIST.add("listviinit");
        DISPLAY2STORE_LIST.add("listvif7");
    }

    private static class FieldApHolder
    extends ControlApHolder {
        private FieldAp fieldAp;

        public void setFieldAp(FieldAp fieldAp) {
            this.fieldAp = fieldAp;
            this.controlAp = fieldAp;
        }

        public FieldAp getFieldAp() {
            return this.fieldAp;
        }

        public FieldApHolder(FieldAp fieldAp, DynamicObject storeData, LightLayoutEditPlugin parent) {
            super((ControlAp<?>)fieldAp, storeData, parent, storeData == null ? fieldAp.getKey() : storeData.getString("fieldkey_s"));
            this.fieldAp = fieldAp;
            this.visibleMap = LightLayoutUtil.VISIBLE2STATUS;
            this.lockMap = LightLayoutUtil.LOCK2STATUS;
        }

        public boolean getSystemMustInput() {
            return this.fieldAp.getField().isMustInput();
        }

        public boolean getMustInput() {
            if (this.parent.isLayout()) {
                return this.fieldAp.getField().isMustInput();
            }
            if (this.storeData == null || this.fieldAp.getField().isMustInput()) {
                return this.fieldAp.getField().isMustInput();
            }
            return this.storeData.getBoolean("fieldmustinput_s");
        }

        public String getDefValue() {
            return this.storeData == null ? "" : this.storeData.getString("fielddefvalue_s");
        }

        public String getDefValueDesign() {
            return this.storeData == null ? "" : this.storeData.getString("fielddefvaluedesign_s");
        }

        public int getDefValueType() {
            return this.fieldAp.getField() instanceof TimeField ? 0 : this.fieldAp.getField().getDefValueType();
        }

        public String getFieldId() {
            return this.fieldAp.getField().getId();
        }

        @Override
        public ILocaleString getDspName() {
            return this.storeData == null ? this.controlAp.getName() : this.storeData.getLocaleString("fielddspname_s");
        }
    }

    private static class ListColumnApHolder
    extends ControlApHolder {
        private ListColumnAp fieldap;

        public ListColumnAp getFieldAp() {
            return this.fieldap;
        }

        public void setFieldAp(ListColumnAp fieldap) {
            this.fieldap = fieldap;
            this.controlAp = fieldap;
        }

        public ListColumnApHolder(ListColumnAp fieldAp, DynamicObject storeData, LightLayoutEditPlugin parent) {
            super((ControlAp<?>)fieldAp, storeData, parent, storeData == null ? fieldAp.getListFieldId() : storeData.getString("listkey_s"));
            this.fieldap = fieldAp;
            this.visibleMap = LightLayoutUtil.LISTVISIBLE2STATUS;
        }

        public Object getListFieldId() {
            return this.fieldap.getListFieldId();
        }

        @Override
        public ILocaleString getDspName() {
            return this.storeData == null ? this.controlAp.getName() : this.storeData.getLocaleString("listdspname_s");
        }
    }

    private static abstract class ControlApHolder {
        protected ControlAp<?> controlAp;
        protected final DynamicObject storeData;
        protected final String fieldKey;
        protected LightLayoutEditPlugin parent;
        protected Map<String, String> visibleMap;
        protected Map<String, String> lockMap;

        protected ControlApHolder(ControlAp<?> fieldAp, DynamicObject storeData, LightLayoutEditPlugin parent, String fieldKey) {
            if (fieldAp == null && storeData == null) {
                throw new IllegalArgumentException();
            }
            this.controlAp = fieldAp;
            this.storeData = storeData;
            this.parent = parent;
            this.fieldKey = fieldKey;
        }

        public String getId() {
            return this.controlAp.getId();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                return this.getFieldKey().equals(((ControlApHolder)obj).getFieldKey());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.fieldKey);
        }

        public String getFieldKey() {
            return this.fieldKey;
        }

        public LocaleString getName() {
            return this.controlAp.getName();
        }

        public boolean getLock(String lock) {
            if (this.storeData == null) {
                return this.controlAp.getLock().contains(lock);
            }
            return this.storeData.getBoolean(this.lockMap.get(lock));
        }

        public boolean getSystemLock(String lock) {
            return this.controlAp.getLock().contains(lock);
        }

        public boolean getSystemVisible(String visible) {
            return this.controlAp.getVisible().contains(visible);
        }

        public boolean getVisible(String visible) {
            if (this.storeData == null) {
                return this.controlAp.getVisible().contains(visible);
            }
            return this.storeData.getBoolean(this.visibleMap.get(visible));
        }

        public abstract ILocaleString getDspName();
    }
}

