/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.lightlayout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.lightlayout.LightLayoutUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;

public class LightLayoutListPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final Log logger = LogFactory.getLog(LightLayoutListPlugin.class);
    private static final String KEY_TREEVIEWAP = "treeviewap";
    private static final String CACHEID_CURRNODE = "currnode";
    private static final String PREFIX_APP = "app_";
    private static final String PREFIX_CLOUD = "cloud_";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String ROOT_NODE_ID = "";
    public static final String ENTRYENTITY = "entryentity";
    public static final String BOS_LIGHTLAYOUT = "bos_lightlayout";
    public static final String NUMBER = "number";
    public static final String DODEL = "dodel";
    public static final String CREATOR = "creator";
    public static final String BILLPREVIEW = "billpreview";
    public static final String LISTPREVIEW = "listpreview";
    public static final String MOBILEPREVIEW = "mobilepreview";
    public static final String MOBILELISTPREVIEW = "mobilelistpreview";
    private IBusinessDataReader businessDataReader = new IBusinessDataReader(){

        @Override
        public Map<Object, DynamicObject> loadFromCache(String entityName, QFilter[] filters) {
            return BusinessDataReader.loadFromCache((String)entityName, (QFilter[])filters);
        }
    };

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addPackageDataListener(evt -> {
            block3: {
                block4: {
                    if (!(evt.getSource() instanceof OperationColumn)) break block3;
                    if (!"op".equals(((OperationColumn)evt.getSource()).getKey())) break block4;
                    List opItems = (List)evt.getFormatValue();
                    String creator = evt.getRowData().getString(CREATOR);
                    for (OperationColItem item : opItems) {
                        if (!StringUtils.isBlank((CharSequence)creator) || !DODEL.equals(item.getOperationKey())) continue;
                        item.setVisible(false);
                    }
                    break block3;
                }
                if (!"operationcolumnap".endsWith(((OperationColumn)evt.getSource()).getKey())) break block3;
                List opItems = (List)evt.getFormatValue();
                boolean nomobile = evt.getRowData().getBoolean("nomobile");
                if (nomobile) {
                    for (OperationColItem item : opItems) {
                        if (!item.getOperationKey().startsWith("mobile")) continue;
                        item.setVisible(false);
                    }
                }
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tView = (TreeView)this.getControl(KEY_TREEVIEWAP);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"tbar_main"});
        Search search = (Search)this.getControl("search");
        search.addEnterListener((SearchEnterListener)this);
        Search searchCloud = (Search)this.getControl("searchcloud");
        searchCloud.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEWAP);
        TreeNode root = this.getSubsysTreeNodes();
        treeView.addNode(root);
        if (!root.getChildren().isEmpty()) {
            TreeNode focuNode = (TreeNode)root.getChildren().get(0);
            treeView.focusNode(focuNode);
            this.refreshNodeTree(focuNode.getId());
        }
    }

    private TreeNode getSubsysTreeNodes() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"LightLayoutListPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        root.setParentid(ROOT_NODE_ID);
        root.setIsOpened(true);
        root.addChildren(this.getCloudNodes());
        return root;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals("refresh")) {
            TreeNode rootNode = this.getSubsysTreeNodes();
            TreeView tView = (TreeView)this.getControl(KEY_TREEVIEWAP);
            tView.updateNode(rootNode);
            String currNodeId = this.getPageCache().get(CACHEID_CURRNODE);
            TreeNode currentNode = rootNode.getTreeNode(currNodeId);
            if (currentNode == null) {
                currentNode = rootNode;
            }
            tView.focusNode(currentNode);
            this.refreshView(currentNode.getId(), ROOT_NODE_ID);
            this.getPageCache().put(CACHEID_CURRNODE, currNodeId);
        } else if (BILLPREVIEW.equals(evt.getItemKey()) || LISTPREVIEW.equals(evt.getItemKey()) || MOBILEPREVIEW.equals(evt.getItemKey()) || MOBILELISTPREVIEW.equals(evt.getItemKey())) {
            this.doPreview(evt.getItemKey());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        switch (args.getOperateKey()) {
            case "doext": {
                String number = (String)this.getModel().getValue(NUMBER);
                BaseShowParameter formShowParameter = new BaseShowParameter();
                formShowParameter.setCustomParam("formid", (Object)number);
                formShowParameter.setFormId(BOS_LIGHTLAYOUT);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "doext"));
                DynamicObject data = this.getLightLayoutByNumber(number);
                if (data != null) {
                    formShowParameter.setPkId(data.get("id"));
                    formShowParameter.setBillStatus(BillOperationStatus.EDIT);
                }
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "dodel": {
                String number = (String)this.getModel().getValue(NUMBER);
                if (StringUtils.isBlank((CharSequence)number)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"LightLayoutListPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u8be5\u6269\u5c55?", (String)"LightLayoutListPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DODEL, (IFormPlugin)this));
                break;
            }
            case "billpreview": 
            case "listpreview": 
            case "mobilepreview": 
            case "mobilelistpreview": {
                this.doPreview(args.getOperateKey());
            }
        }
    }

    private void doPreview(String opKey) {
        String number = (String)this.getModel().getValue(NUMBER);
        if (StringUtils.isNotBlank((CharSequence)number)) {
            FormShowParameter formShowParameter = LightLayoutUtil.preview(number, LightLayoutUtil.PREVIEW_TYPE.valueOf(opKey));
            if (formShowParameter != null) {
                this.getView().showForm(formShowParameter);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"LightLayoutListPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String number;
        DynamicObject data;
        if ("doext".equals(evt.getActionId()) && (data = this.getLightLayoutByNumber(number = (String)this.getModel().getValue(NUMBER))) != null) {
            int current = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            this.getModel().setValue(CREATOR, (Object)data.getDynamicObject(CREATOR).getString("name"), current);
            this.getModel().setValue("createtime", (Object)data.getDate("createtime"), current);
            this.getView().updateView(ENTRYENTITY, current);
        }
    }

    private DynamicObject getLightLayoutByNumber(String number) {
        QFilter[] qFilters = new QFilter[]{new QFilter(NUMBER, "=", (Object)number)};
        Map<Object, DynamicObject> data = this.businessDataReader.loadFromCache(BOS_LIGHTLAYOUT, qFilters);
        return data.isEmpty() ? null : data.values().iterator().next();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (DODEL.equals(evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            String number = (String)this.getModel().getValue(NUMBER);
            QFilter[] qFilters = new QFilter[]{new QFilter(NUMBER, "=", (Object)number)};
            Map id = BusinessDataReader.loadFromCache((String)BOS_LIGHTLAYOUT, (String)"id", (QFilter[])qFilters);
            Object[] pks = id.keySet().toArray();
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)BOS_LIGHTLAYOUT, (Object[])pks, (OperateOption)OperateOption.create());
            if (result.isSuccess()) {
                EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
                int current = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
                grid.hideOperateItems("op", current, Collections.singletonList(DODEL));
                this.getModel().setValue(CREATOR, (Object)ROOT_NODE_ID, current);
                this.getModel().setValue("createtime", (Object)ROOT_NODE_ID, current);
                this.getView().updateView(ENTRYENTITY, current);
            } else {
                this.getView().showOperationResult(result);
            }
        }
    }

    private List<TreeNode> getCloudNodes() {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>(0);
        }
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            String cloudNodeId = PREFIX_CLOUD + cloud.getId();
            cloud.setId(cloudNodeId);
            cloud.setData((Object)"cloud");
            List apps = cloud.getChildren();
            if (apps == null) {
                cloudIterator.remove();
                continue;
            }
            for (TreeNode app : apps) {
                String appNodeId = PREFIX_APP + app.getId();
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData((Object)"app");
            }
        }
        return clouds;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String newNodeId = (String)e.getNodeId();
        this.refreshNodeTree(newNodeId);
    }

    private void refreshNodeTree(String newNodeId) {
        String currNodeId = this.getPageCache().get(CACHEID_CURRNODE);
        if (newNodeId.equals(currNodeId)) {
            return;
        }
        this.refreshView(newNodeId, ROOT_NODE_ID);
        this.getPageCache().put(CACHEID_CURRNODE, newNodeId);
    }

    private void refreshView(String nodeId, String searchText) {
        List<BillModel> list = this.getBillModels(nodeId, searchText);
        this.getModel().beginInit();
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (!list.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, list.size());
            int i = 0;
            for (BillModel billObj : list) {
                this.getModel().setValue(NUMBER, (Object)billObj.number, i);
                this.getModel().setValue("name", (Object)billObj.name, i);
                this.getModel().setValue("modeltype", (Object)billObj.modelType, i);
                this.getModel().setValue(CREATOR, (Object)billObj.creator, i);
                this.getModel().setValue("createtime", (Object)billObj.createDate, i);
                this.getModel().setValue("nomobile", (Object)billObj.isNoMobile, i);
                ++i;
            }
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private List<Object> loadAppIds(String appId) {
        String sql = "SELECT FID FROM t_meta_bizapp WHERE FMasterId = ? AND FType = ? ";
        Object[] param = new SqlParameter[]{new SqlParameter(":FMasterId", 12, (Object)appId), new SqlParameter(":FType", 12, (Object)"2")};
        ResultSetHandler action = rs -> {
            ArrayList<String> tempIdList = new ArrayList<String>(10);
            while (rs.next()) {
                tempIdList.add(rs.getString("FID"));
            }
            return tempIdList;
        };
        List appIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])param, (ResultSetHandler)action);
        appIds.add(appId);
        return appIds;
    }

    private List<Object> loadAppIdsByCloudId(String cloudId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT B.FID FROM t_meta_bizcloud A INNER JOIN t_meta_bizapp B ON A.FID = B.FBIZCLOUDID ", new Object[0]).append(" WHERE  b.FDeployStatus ='2' and b.fvisible = '1' ", new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)cloudId)) {
            sql.append(" and A.FID = ? ", new Object[]{cloudId});
        }
        ResultSetHandler action = rs -> {
            ArrayList<String> tempIdList = new ArrayList<String>(10);
            while (rs.next()) {
                tempIdList.add(rs.getString("FID"));
            }
            return tempIdList;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, (ResultSetHandler)action);
    }

    private List<BillModel> getBillModels(String nodeId, String searchText) {
        List<Object> appIds;
        if (nodeId.startsWith(PREFIX_CLOUD)) {
            String cloudId = StringUtils.substringAfter((String)nodeId, (String)"_");
            appIds = this.loadAppIdsByCloudId(cloudId);
        } else if (nodeId.startsWith(PREFIX_APP)) {
            String appId = StringUtils.substringAfter((String)nodeId, (String)"_");
            appIds = this.loadAppIds(appId);
        } else {
            appIds = StringUtils.isNotBlank((CharSequence)searchText) ? this.loadAppIdsByCloudId(ROOT_NODE_ID) : new ArrayList<Object>(0);
        }
        if (appIds.isEmpty()) {
            return new ArrayList<BillModel>(0);
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select  t1.fid, case when t1.fid <> t1.fentityid then 'Layout' else t1.fmodeltype end  as fmodeltype,t1.fnumber,t2.fname  from t_meta_formdesign t1 inner join t_meta_formdesign_l  t2 on t1.FID = t2.FID ", new Object[0]).append(" and t2.FLocaleId = ?", new Object[]{Lang.get()}).append("where  (", new Object[0]).append("t1.fid <> t1.fentityid  or t1.fmasterid = ' ')  and  t1.fmodeltype in ('BillFormModel','BaseFormModel')  and t1.fisv <> 'kdprod' ", new Object[0]).appendIn(" and t1.FBizAppId ", appIds);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            sql.append(" and ( t1.fnumber like ? ", new Object[]{"%" + searchText + "%"});
            sql.append(" or  t2.fname like ? ", new Object[]{"%" + searchText + "%"});
            sql.append(")", new Object[0]);
        }
        sql.append(" order by t1.fnumber", new Object[0]);
        List list = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, rs -> {
            ArrayList<BillModel> ret = new ArrayList<BillModel>(16);
            while (rs.next()) {
                BillModel billModel = new BillModel(rs.getString("fid"), rs.getString("fnumber"), rs.getString("fname"), rs.getString("fmodeltype"));
                ret.add(billModel);
            }
            return ret;
        });
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<String> numberList = new ArrayList<String>(16);
        for (BillModel billModel : list) {
            numberList.add(billModel.number);
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(NUMBER, "in", numberList)};
        Map<Object, DynamicObject> lightlayout = this.businessDataReader.loadFromCache(BOS_LIGHTLAYOUT, qFilters);
        HashMap<String, DynamicObject> numberMap = new HashMap<String, DynamicObject>(lightlayout.size());
        for (Map.Entry<Object, DynamicObject> keyValue : lightlayout.entrySet()) {
            numberMap.put(keyValue.getValue().getString(NUMBER), keyValue.getValue());
        }
        for (Object billModel : list) {
            DynamicObject data = (DynamicObject)numberMap.get(((BillModel)billModel).number);
            if (data == null) continue;
            ((BillModel)billModel).creator = data.getDynamicObject(CREATOR).getString("name");
            ((BillModel)billModel).createDate = data.getDate("createtime");
        }
        ArrayList<String> mobileNumberList = new ArrayList<String>(16);
        for (BillModel billModel : list) {
            mobileNumberList.add(billModel.number + "_mob");
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct fnumber from t_meta_form where", new Object[0]).appendIn(" fnumber  ", mobileNumberList);
        Set set = (Set)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, rs -> {
            HashSet<String> s = new HashSet<String>(8);
            while (rs.next()) {
                s.add(rs.getString("fnumber"));
            }
            return s;
        });
        for (BillModel billModel : list) {
            if (!set.contains(billModel.number + "_mob")) continue;
            billModel.isNoMobile = false;
        }
        return list;
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)"search", (CharSequence)search.getKey())) {
            TreeView tView = (TreeView)this.getControl(KEY_TREEVIEWAP);
            TreeNode rootNode = new TreeNode();
            rootNode.setId(ROOT_NODE_ID);
            tView.focusNode(rootNode);
            this.getPageCache().put(CACHEID_CURRNODE, ROOT_NODE_ID);
            this.refreshView(ROOT_NODE_ID, e.getText());
        } else if (StringUtils.equals((CharSequence)"searchcloud", (CharSequence)search.getKey())) {
            String searchText = e.getText();
            TreeNode rootNode = this.getSubsysTreeNodes();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                ArrayList<TreeNode> newChildNodes = new ArrayList<TreeNode>(10);
                if (CollectionUtils.isNotEmpty((Collection)rootNode.getChildren())) {
                    for (TreeNode node : rootNode.getChildren()) {
                        String name = node.getText();
                        if (name.contains(searchText)) {
                            newChildNodes.add(node);
                            continue;
                        }
                        if (!CollectionUtils.isNotEmpty((Collection)node.getChildren())) continue;
                        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(16);
                        for (TreeNode child : node.getChildren()) {
                            if (!child.getText().contains(searchText)) continue;
                            childNodes.add(child);
                        }
                        if (!CollectionUtils.isNotEmpty(childNodes)) continue;
                        node.setChildren(childNodes);
                        newChildNodes.add(node);
                    }
                }
                rootNode.setChildren(newChildNodes);
            }
            TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEWAP);
            treeView.updateNode(rootNode);
        }
    }

    private static class BillModel {
        public String id;
        public String number;
        public String name;
        public String modelType;
        public String creator;
        public Date createDate;
        public boolean isNoMobile = true;

        public BillModel(String id, String number, String name, String modelType) {
            this.id = id;
            this.number = number;
            this.name = name;
            this.modelType = modelType;
        }
    }

    static interface IBusinessDataReader {
        public Map<Object, DynamicObject> loadFromCache(String var1, QFilter[] var2);
    }
}

