/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.lightlayout;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;

class LightLayoutUtil {
    public static final Map<String, String> LOCK2STATUS = new LinkedHashMap<String, String>();
    public static final Map<String, String> VISIBLE2STATUS = new LinkedHashMap<String, String>();
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String FORM_ID = "formId";
    private static final String SHOW_FORM_LANG_PARAM = "formConfigShowLang";
    public static final Map<String, String> LISTVISIBLE2STATUS = new LinkedHashMap<String, String>();

    LightLayoutUtil() {
    }

    public static String getMapValue(DynamicObject row, Map<String, String> fieldMap) {
        StringBuilder s = new StringBuilder();
        fieldMap.forEach((key, value) -> {
            if (row.getBoolean(value)) {
                s.append((String)key).append(",");
            }
        });
        if (s.length() > 0) {
            s.deleteCharAt(s.length() - 1);
        }
        return s.toString();
    }

    public static Map<String, Object> getDefValueFromMap(Map<String, Object> data) {
        Object value;
        block7: {
            value = data.get("alias");
            if (value == null && (value = data.get("value")) instanceof Map) {
                Map mapValue = (Map)value;
                if (mapValue.containsKey("FuncParameter")) {
                    String funcParameter = (String)mapValue.get("FuncParameter");
                    try {
                        Map funcParameterMap = (Map)SerializationUtils.fromJsonString((String)funcParameter, Map.class);
                        if (funcParameterMap.containsKey("name")) {
                            value = funcParameterMap.get("name");
                            break block7;
                        }
                        value = mapValue.get("FuncType");
                    }
                    catch (Exception ignore) {
                        value = funcParameter;
                    }
                } else {
                    value = SerializationUtils.toJsonString((Object)value);
                }
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("fielddefvalue", value);
        if (data.get("value") instanceof Map) {
            result.put("fielddefvaluedesign", SerializationUtils.toJsonString((Object)data.get("value")));
        }
        return result;
    }

    public static FormShowParameter preview(String number, PREVIEW_TYPE opkey) {
        ListShowParameter parameter;
        switch (opkey) {
            case billpreview: {
                HashMap<String, String> para = new HashMap<String, String>();
                para.put(FORM_ID, number);
                parameter = FormShowParameter.createFormShowParameter(para);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam(SHOW_FORM_LANG_PARAM, (Object)RequestContext.get().getLang());
                break;
            }
            case listpreview: {
                parameter = new ListShowParameter();
                parameter.setBillFormId(number);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                break;
            }
            case mobilepreview: {
                parameter = LightLayoutUtil.createMobShowParam(number + "_mob", "MobileBillFormModel");
                break;
            }
            case mobilelistpreview: {
                parameter = LightLayoutUtil.createMobShowParam(number, "MobileListModel");
                break;
            }
            default: {
                return null;
            }
        }
        parameter.setCaption(ResManager.loadKDString((String)"\u9884\u89c8", (String)"LightLayoutUtil_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        return parameter;
    }

    private static FormShowParameter createMobShowParam(String formId, String modelType) {
        HashMap<String, String> para = new HashMap<String, String>();
        String tempNumber = formId;
        if (modelType.startsWith("Mob")) {
            tempNumber = "bos_mobilepreview";
        }
        para.put(FORM_ID, tempNumber);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        if (modelType.startsWith("Mob")) {
            showParameter.setCustomParam("number", (Object)formId);
            showParameter.setCustomParam("modelType", (Object)modelType);
            showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
            showParameter.setClientParam("preview", (Object)"true");
        } else {
            showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        }
        showParameter.setCustomParam(SHOW_FORM_LANG_PARAM, (Object)RequestContext.get().getLang());
        return showParameter;
    }

    static {
        LOCK2STATUS.put("new", "locknew_s");
        LOCK2STATUS.put("edit", "lockmodify_s");
        LOCK2STATUS.put("submit", "locksubmit_s");
        LOCK2STATUS.put("audit", "lockaudit_s");
        VISIBLE2STATUS.put("init", "viinit_s");
        VISIBLE2STATUS.put("new", "vinew_s");
        VISIBLE2STATUS.put("edit", "vimodify_s");
        VISIBLE2STATUS.put("view", "viview_s");
        VISIBLE2STATUS.put("submit", "visubmit_s");
        VISIBLE2STATUS.put("audit", "viaudit_s");
        LISTVISIBLE2STATUS.put("default", "listviinit_s");
        LISTVISIBLE2STATUS.put("lookup", "listvif7_s");
    }

    static enum PREVIEW_TYPE {
        billpreview,
        listpreview,
        mobilepreview,
        mobilelistpreview;

    }
}

