/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.list;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.util.StringUtils;

public class GlobalSchemeTreePlugin
extends StandardTreeListPlugin {
    public void initializeTree(EventObject e) {
        this.intiTree();
    }

    private void intiTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"GlobalSchemeTreePlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getAllCloudNodes();
        ArrayList<String> cloudIds = new ArrayList<String>(cloudNodes.size());
        for (TreeNode treeNode : cloudNodes) {
            cloudIds.add(treeNode.getId());
        }
        List<TreeNode> appNodes = this.getAppNodesByCloudId(cloudIds);
        for (TreeNode treeNode : cloudNodes) {
            this.addChildNode(treeNode, appNodes);
        }
        root.addChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setBarItemEnable(false, true);
    }

    protected List<TreeNode> getAllCloudNodes() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            DynamicObject cloudObject = BizCloudServiceHelp.getBizCloudByAppID((String)refAppId);
            TreeNode node = new TreeNode("-1", cloudObject.getString("id"), cloudObject.getLocaleString("name").getLocaleValue());
            cloudNode.add(node);
        } else {
            DynamicObjectCollection dynamicObjects = BizCloudServiceHelp.getAllBizClouds();
            for (DynamicObject dynamicObject : dynamicObjects) {
                TreeNode node = new TreeNode();
                node.setId(dynamicObject.getString("id"));
                node.setText(dynamicObject.getString("name"));
                node.setParentid("-1");
                cloudNode.add(node);
            }
        }
        return cloudNode;
    }

    protected List<TreeNode> getAppNodesByCloudId(List<String> cloudIds) {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            AppMetadata refAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)refAppId, (boolean)false);
            String refAppName = refAppMeta.getName().getLocaleValue();
            for (String cloudId : cloudIds) {
                TreeNode node = new TreeNode(cloudId, refAppId, refAppName);
                appNodes.add(node);
            }
        } else {
            DynamicObjectCollection dynamicObjects = BizAppServiceHelp.getAllBizAppsByCloudID(cloudIds);
            for (DynamicObject dynamicObject : dynamicObjects) {
                TreeNode node = new TreeNode();
                String nodeId = dynamicObject.getString("id");
                node.setId(nodeId);
                node.setText(dynamicObject.getString("name"));
                node.setParentid(dynamicObject.getString("bizcloud"));
                appNodes.add(node);
            }
        }
        return appNodes;
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(this.addChildNode(cnode, childNodes));
        }
        return pnode;
    }

    public void refreshNode(RefreshNodeEvent e) {
        List<TreeNode> childNodes = this.getChildNodes(e.getNodeId());
        e.setChildNodes(childNodes);
    }

    private List<TreeNode> getChildNodes(Object parentId) {
        List<TreeNode> cloudNodes = null;
        if (this.getTreeModel().getRoot().getId().equals(parentId)) {
            cloudNodes = this.getAllCloudNodes();
            ArrayList<String> cloudIds = new ArrayList<String>(cloudNodes.size());
            for (TreeNode treeNode : cloudNodes) {
                cloudIds.add(treeNode.getId());
            }
            List<TreeNode> appNodes = this.getAppNodesByCloudId(cloudIds);
            for (TreeNode treeNode : cloudNodes) {
                this.addChildNode(treeNode, appNodes);
            }
        } else {
            TreeNode node = this.getTreeModel().getRoot().getTreeNode((String)parentId, 20);
            if (node != null) {
                return node.getChildren();
            }
        }
        return cloudNodes;
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{"btnnew", "btnedit", "btndel"});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{"btnnew"});
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{"btnedit", "btndel"});
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent nodeEvent) {
        super.buildTreeListFilter(nodeEvent);
        String nodeId = nodeEvent.getNodeId().toString();
        QFilter qFilter = this.filter();
        qFilter.and(this.getModelFilter(nodeId));
        nodeEvent.addQFilter(qFilter);
        nodeEvent.setCancel(true);
    }

    protected QFilter filter() {
        return new QFilter("modeltype", "in", (Object)this.getModelFilterContent());
    }

    protected QFilter getModelFilter(String nodeId) {
        QFilter qFilter = null;
        ORM orm = ORM.create();
        boolean isCloud = orm.exists("bos_devportal_bizcloud", (Object)nodeId);
        if (nodeId.equals("-1")) {
            qFilter = new QFilter("dentityid", "is not null", (Object)"");
        } else if (isCloud) {
            JSONArray units = this.getUnitIdsByCloudId(nodeId);
            qFilter = new QFilter("bizappid", "in", (Object)units);
        } else {
            qFilter = new QFilter("bizappid", "=", (Object)nodeId);
        }
        return qFilter;
    }

    protected JSONArray getUnitIdsByCloudId(String bizCloudId) {
        JSONArray unitIds = new JSONArray();
        ORM orm = ORM.create();
        QFilter q = new QFilter("bizcloud", "=", (Object)bizCloudId);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id";
        DynamicObjectCollection query = orm.query("bos_devportal_bizapp", selectFields, filters, "sequence asc");
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            String bizAppId = dynamicObject.getString("id");
            unitIds.add((Object)bizAppId);
        }
        return unitIds;
    }

    protected JSONArray getModelFilterContent() {
        String modeltype = (String)this.getView().getFormShowParameter().getCustomParam("modeltype");
        JSONArray modelFilterContent = new JSONArray();
        if (!StringUtils.isEmpty((String)modeltype)) {
            String[] modelTypes;
            for (String modelType : modelTypes = modeltype.split(",")) {
                modelFilterContent.add((Object)modelType);
            }
        } else {
            modelFilterContent.add((Object)"BaseFormModel");
            modelFilterContent.add((Object)"BillFormModel");
            modelFilterContent.add((Object)"ReportFormModel");
            modelFilterContent.add((Object)"DynamicFormModel");
            modelFilterContent.add((Object)"QueryListModel");
            modelFilterContent.add((Object)"MobileFormModel");
            modelFilterContent.add((Object)"BalanceModel");
            modelFilterContent.add((Object)"LogBillFormModel");
        }
        modelFilterContent.add((Object)"PCLayoutModel");
        return modelFilterContent;
    }
}

