/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IListSortSetting;
import kd.bos.list.FieldSort;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class ListSortSettingPlugin
extends AbstractFormPlugin
implements IListSortSetting {
    private static final String SORTTYPE = "sorttype";
    private static final String FIELD = "field";
    private static final String ENTRYENTITY = "entryentity";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String ISLOOKUP = "isLookup";

    private String getEntityId() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParams().get("entityId");
        return FormMetadataCache.getFormConfig((String)entityId).getEntityTypeId();
    }

    public void afterCreateNewData(EventObject e) {
        String setting;
        String msfKey;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Collection multiSortFields = (Collection)formShowParameter.getCustomParam("multiSortFields");
        if (!multiSortFields.isEmpty()) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(multiSortFields.size());
            for (String multiSortField : multiSortFields) {
                IDataEntityProperty findProperty = this.getDataEntityProperty(dataEntityType, multiSortField);
                if (findProperty == null || findProperty instanceof PictureProp || findProperty instanceof BasedataProp || findProperty instanceof MulBasedataProp || findProperty instanceof AttachmentProp) continue;
                comboItems.add(new ComboItem(findProperty.getDisplayName(), findProperty.getName()));
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl(FIELD);
            comboEdit.setComboItems(comboItems);
        }
        if (StringUtils.isNotBlank((CharSequence)(msfKey = this.getMSFKey(this.getSchemeId()))) && StringUtils.isNotBlank((CharSequence)(setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)msfKey)))) {
            List fieldSorts = SerializationUtils.fromJsonStringToList((String)setting, FieldSort.class);
            this.getModel().clearNoDataRow();
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, fieldSorts.size());
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRYENTITY);
            int i = 0;
            for (FieldSort fieldSort : fieldSorts) {
                ((DynamicObject)dynamicObjectCollection.get(i)).set(FIELD, (Object)fieldSort.getFieldName());
                ((DynamicObject)dynamicObjectCollection.get(i)).set(SORTTYPE, (Object)fieldSort.getSortType());
                ++i;
            }
        }
        super.afterCreateNewData(e);
    }

    IDataEntityProperty getDataEntityProperty(MainEntityType dataEntityType, String multiSortField) {
        return dataEntityType.findProperty(multiSortField);
    }

    private String getSchemeId() {
        return this.getView().getFormShowParameter().getCustomParams().get("schemeId") != null ? this.getView().getFormShowParameter().getCustomParams().get("schemeId").toString() : "";
    }

    public List<FieldSort> saveSortSetting(String schemeId) {
        ArrayList<FieldSort> multiSortFields = new ArrayList<FieldSort>();
        ArrayList<String> fields = new ArrayList<String>();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            if (!StringUtils.isNotBlank((CharSequence)dynamicObject.getString(FIELD))) continue;
            String field = dynamicObject.getString(FIELD);
            if (!fields.contains(field)) {
                fields.add(field);
                String sortStr = dynamicObject.getString(SORTTYPE);
                if (StringUtils.isNotBlank((CharSequence)sortStr)) {
                    multiSortFields.add(new FieldSort(field, SortType.valueOf((String)sortStr)));
                    continue;
                }
                multiSortFields.add(new FieldSort(field, SortType.ASC));
                continue;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\u6392\u5e8f\u91cd\u590d\uff0c\u8bf7\u5220\u9664\u91cd\u590d\u5b57\u6bb5\u3002", (String)"MultiSortFieldsConfigPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), dataEntityType.findProperty(field).getDisplayName()));
        }
        if (!multiSortFields.isEmpty()) {
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)this.getMSFKey(schemeId), (String)SerializationUtils.toJsonString(multiSortFields));
        } else {
            UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)this.getMSFKey(schemeId));
        }
        return multiSortFields;
    }

    protected boolean isLookup() {
        return this.getView().getFormShowParameter().getCustomParams().get(ISLOOKUP) == null ? false : Boolean.parseBoolean(this.getView().getFormShowParameter().getCustomParams().get(ISLOOKUP).toString());
    }

    protected String getMSFKey(String schemeId) {
        if (StringUtils.isBlank((CharSequence)schemeId) || this.isLookup()) {
            return "";
        }
        String listFieldsControlKey = (String)this.getView().getFormShowParameter().getCustomParam("ListFieldsControlKey");
        return listFieldsControlKey + "." + schemeId + "_sort";
    }
}

