/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.list;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.SelectedDisplayField;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.list.AbstractMobF7Plugin;
import kd.bos.list.BillList;
import kd.bos.list.MobF7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;

public class MobTabF7SelectedPlugin
extends AbstractMobF7Plugin
implements F7SelectedListRemoveListener {
    private static final String MOB_F7_SELECTED_LIST_AP = "mobf7selectedlistap";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String MT = "mt";
    private static final String ST = "st";
    private static final String ID = "id";
    private static final String SELECTED_DISPLAY_FIELD = "selectedDisplayField";
    private static final String PRIMARY_KEY_VALUE = "primaryKeyValue";
    private static final String PAGE_ID = "pageId";
    private static final String CLEAR_SEL_ROWS = "clearSelRows";
    private static final String LB_SEL = "lbsel";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String CONFIRM = "confirm";

    @Override
    public void registerListener(EventObject e) {
        MobF7SelectedList mobF7SelectedList = (MobF7SelectedList)this.getControl(MOB_F7_SELECTED_LIST_AP);
        if (mobF7SelectedList != null) {
            mobF7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        }
        super.registerListener(e);
    }

    @Override
    public void afterBindData(EventObject e) {
    }

    public void afterCreateNewData(EventObject e) {
        MobF7SelectedList f7SelectedList = (MobF7SelectedList)this.getControl(MOB_F7_SELECTED_LIST_AP);
        if (f7SelectedList == null) {
            return;
        }
        ArrayList selectedData = new ArrayList(16);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object selectedDisplayField = customParams.get(SELECTED_DISPLAY_FIELD);
        Object pageId = customParams.get(PAGE_ID);
        if (pageId == null) {
            return;
        }
        IFormView parentView = this.getView().getViewNoPlugin(pageId.toString());
        BillList billList = (BillList)parentView.getControl(BILL_LIST_AP);
        String mt = null;
        String st = "";
        if (StringUtils.isNotBlank(selectedDisplayField)) {
            SelectedDisplayField fields = (SelectedDisplayField)JSON.parseObject((String)selectedDisplayField.toString(), SelectedDisplayField.class);
            mt = fields.getMainField();
            st = fields.getSecondField();
        }
        Object[] primaryKeys = billList.getSelectedRows().stream().map(row -> row.getPrimaryKeyValue()).collect(Collectors.toList()).toArray();
        String entityId = billList.getEntityType().getName();
        Map loadFromCache = BusinessDataReader.loadFromCache((Object[])primaryKeys, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityId));
        for (Map.Entry entry : loadFromCache.entrySet()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            data.put(ID, dynamicObject.get(ID).toString());
            data.put(MT, this.getFieldDataByPriority(mt, dynamicObject));
            if (StringUtils.isNotBlank((CharSequence)st)) {
                data.put(ST, StringUtils.isNotBlank((Object)dynamicObject.get(String.valueOf(st))) ? dynamicObject.get(st.toString()).toString() : "");
            }
            selectedData.add(data);
        }
        f7SelectedList.addItems(selectedData);
    }

    @Override
    protected IFormView getInterView() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object pageId = customParams.get(PAGE_ID);
        if (pageId == null) {
            return null;
        }
        return this.getView().getViewNoPlugin(pageId.toString());
    }

    public void RemoveClick(F7SelectedListRemoveEvent evt) {
        IFormView parentView = this.getInterView();
        if (parentView == null) {
            return;
        }
        BillList billList = (BillList)parentView.getControl(BILL_LIST_AP);
        billList.removeSelectRow(evt.getParam().toString());
        if (this.isMultiSelect()) {
            Label label = (Label)parentView.getControl(LB_SEL);
            label.setText(String.format("%s", billList.getSelectedRows().size()));
        }
        this.changeConfirmStatus(CONFIRM);
        this.changeSelectedEnable("flexpanelap1");
        this.getView().sendFormAction(parentView);
    }

    private Object getFieldDataByPriority(Object field, DynamicObject dynamicObject) {
        Object fieldValue = StringUtils.isNotBlank((Object)field) ? dynamicObject.get(field.toString()) : (StringUtils.isNotBlank((Object)dynamicObject.get(NAME)) ? dynamicObject.get(NAME) : (StringUtils.isNotBlank((Object)dynamicObject.get(NUMBER)) ? dynamicObject.get(NUMBER) : dynamicObject.get(PRIMARY_KEY_VALUE)));
        return StringUtils.isNotBlank((Object)fieldValue) ? fieldValue.toString() : "";
    }

    private void changeSelectedEnable(String name) {
        IFormView interView = this.getInterView();
        if (!this.hasSelectedRows()) {
            interView.setEnable(Boolean.valueOf(false), new String[]{name});
        } else {
            interView.setEnable(Boolean.valueOf(true), new String[]{name});
        }
    }
}

