/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.query.SchemeQuery;
import kd.bos.list.query.SchemeWriter;

public class ShareFilterSchemeListPlugin
extends AbstractListPlugin {
    Map<String, String> appNameMap = new HashMap<String, String>();
    private static final String SCHEME_ID = "scheme_id";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection dynamicObjectCollection = e.getPageData();
        ArrayList<String> schemeIds = new ArrayList<String>();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            if (dynamicObject.getString(SCHEME_ID) == null) continue;
            schemeIds.add(dynamicObject.getString(SCHEME_ID));
        }
        HashSet<String> formIds = new HashSet<String>(16);
        Map<Object, DynamicObject> filterSchemeMap = this.loadDynamicObject("bos_filterscheme", schemeIds.toArray(), "form.number");
        HashMap<String, String> schemeFormMap = new HashMap<String, String>(16);
        for (Map.Entry<Object, DynamicObject> entry : filterSchemeMap.entrySet()) {
            String id = entry.getValue().getString("id");
            String string = entry.getValue().getString("form.number");
            if (!StringUtils.isNotBlank((CharSequence)string)) continue;
            formIds.add(string);
            schemeFormMap.put(id, string);
        }
        HashMap<String, String> formAppMap = new HashMap<String, String>(16);
        Map<Object, DynamicObject> entityObjectMap = this.loadDynamicObject("bos_entityobject", formIds.toArray(), "bizappid");
        for (Map.Entry<Object, DynamicObject> entry : entityObjectMap.entrySet()) {
            String id = entry.getValue().getString("id");
            DynamicObject appObject = (DynamicObject)entry.getValue().get("bizappid");
            formAppMap.put(id, appObject.getString("name"));
        }
        for (Map.Entry<Object, Object> entry : schemeFormMap.entrySet()) {
            for (Map.Entry entry2 : formAppMap.entrySet()) {
                if (!((String)entry2.getKey()).equals(entry.getValue())) continue;
                this.appNameMap.put((String)entry.getKey(), (String)entry2.getValue());
            }
        }
        super.beforePackageData(e);
    }

    private boolean checkSelectedRows() {
        if (this.getSelectedRows().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ShareFilterSchemeListPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void itemClick(ItemClickEvent evt) {
        if ("deleteshare".equals(evt.getItemKey()) && this.checkSelectedRows() && this.checkIsNotShared()) {
            for (ListSelectedRow listSelectedRow : this.getSelectedRows()) {
                SchemeWriter.deleteShareScheme((long)((Long)listSelectedRow.getPrimaryKeyValue()));
            }
            this.reload();
            this.clearSelection();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5171\u4eab\u65b9\u6848\u6210\u529f\u3002", (String)"ShareFilterSchemeListPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
        super.itemClick(evt);
    }

    private boolean isShared(ListSelectedRowCollection selectedRows) {
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        return SchemeQuery.isSchemeShared((long)((Long)listSelectedRow.getPrimaryKeyValue()));
    }

    private boolean checkIsNotShared() {
        if (!this.isShared(this.getSelectedRows())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u4e0d\u5c5e\u4e8e\u8868\u5355\u7684\u5df2\u5206\u4eab\u65b9\u6848\uff0c\u65e0\u9700\u53d6\u6d88\u3002", (String)"ShareFilterSchemeListPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void packageData(PackageDataEvent e) {
        String scheme = e.getRowData().getString(SCHEME_ID);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("appname".equalsIgnoreCase(columnDesc.getFieldKey()) && this.appNameMap.containsKey(scheme)) {
            e.setFormatValue((Object)this.appNameMap.get(scheme));
        }
        super.packageData(e);
    }

    private Map<Object, DynamicObject> loadDynamicObject(String formId, Object[] ids, String ... fieldName) {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("id");
        selectFields.addAll(Arrays.asList(fieldName));
        return BusinessDataReader.loadFromCache((Object[])ids, (DynamicObjectType)((MainEntityType)EntityMetadataCache.getSubDataEntityType((String)formId, selectFields)));
    }
}

