/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.mulilang;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.mulilang.GLDataServiceHelper;

public class GLDataRepairListPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String NEEDREPAIRE = "needrepaire";
    private static final String FORMNUMBER = "formnumber";

    public void initialize() {
        super.initialize();
        TreeView treeView = (TreeView)this.getControl("treeview");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.intiTree();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4f7f\u7528bos_gldata_repaireutil\u8868\u5355\u4fee\u590d\u6570\u636e", (String)"GLDataRepairListPlugin_3", (String)"bos-form-business", (Object[])new Object[0]));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"validate"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    private void intiTree() {
        TreeView treeView = (TreeView)this.getControl("treeview");
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"GLDataRepairListPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getCloudNodes();
        for (TreeNode treeNode : cloudNodes) {
            List<TreeNode> groupNodes = this.getAppNodes(treeNode.getId());
            this.addChildNode(treeNode, groupNodes);
        }
        root.addChildren(cloudNodes);
        treeView.addNode(root);
        treeView.focusNode(root);
        TreeNodeEvent evt = new TreeNodeEvent((Object)treeView, (Object)"", (Object)"-1");
        this.treeNodeClick(evt);
    }

    private List<TreeNode> getAppNodes(String cloudId) {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>();
        DynamicObjectCollection dynamicObjects = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloudId);
        for (DynamicObject dynamicObject : dynamicObjects) {
            TreeNode node = new TreeNode();
            String nodeId = dynamicObject.getString("id");
            node.setId(nodeId);
            node.setText(dynamicObject.getString("name"));
            node.setParentid(cloudId);
            appNodes.add(node);
        }
        return appNodes;
    }

    private List<TreeNode> getCloudNodes() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        DynamicObjectCollection dynamicObjects = BizCloudServiceHelp.getAllBizClouds();
        for (DynamicObject dynamicObject : dynamicObjects) {
            TreeNode node = new TreeNode();
            node.setId(dynamicObject.getString("id"));
            node.setText(dynamicObject.getString("name"));
            node.setParentid("-1");
            cloudNode.add(node);
        }
        return cloudNode;
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(this.addChildNode(cnode, childNodes));
        }
        return pnode;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "scan": {
                this.scan();
                break;
            }
            case "addfield": {
                this.repairLackField();
                break;
            }
            case "repairdata": {
                this.repairData();
                break;
            }
        }
    }

    private DynamicObjectCollection getData() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = grid.getEntryState().getSelectedRows();
        DynamicObjectCollection col = new DynamicObjectCollection();
        if (rows.length > 0) {
            for (int i : rows) {
                DynamicObject obj = this.getModel().getEntryRowEntity(ENTRYENTITY, i);
                col.add((Object)obj);
            }
        } else {
            return this.getModel().getEntryEntity(ENTRYENTITY);
        }
        return col;
    }

    private void repairData() {
        DynamicObjectCollection col = this.getData();
        for (DynamicObject obj : col) {
            if (!obj.getBoolean(NEEDREPAIRE)) continue;
            String num = obj.getString(FORMNUMBER);
            String id = MetadataDao.getIdByNumber((String)num, (MetaCategory)MetaCategory.Entity);
            EntityMetadata meta = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
            Map<String, List<String>> datas = this.getMuliLangKey(meta);
            ArrayList<String> muliLangFields = new ArrayList<String>();
            for (List<String> list : datas.values()) {
                muliLangFields.addAll(list);
            }
            GLDataServiceHelper.repairData((String)num, muliLangFields);
        }
    }

    private void repairLackField() {
        DynamicObjectCollection col = this.getData();
        for (DynamicObject obj : col) {
            if (!obj.getBoolean(NEEDREPAIRE)) continue;
            String num = obj.getString(FORMNUMBER);
            String id = MetadataDao.getIdByNumber((String)num, (MetaCategory)MetaCategory.Entity);
            EntityMetadata meta = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
            String lackFieldStr = obj.getString("lackfields");
            Map map = (Map)SerializationUtils.fromJsonString((String)lackFieldStr, Map.class);
            for (Map.Entry data : map.entrySet()) {
                List list = (List)data.getValue();
                this.addField2Table((String)data.getKey(), meta, list);
            }
        }
        this.scan();
    }

    private void addField2Table(String tableName, EntityMetadata meta, List<String> fieldKeys) {
        ArrayList<SqlObject> sqlList = new ArrayList<SqlObject>();
        for (String fieldKey : fieldKeys) {
            Field field = meta.getFieldByKey(fieldKey);
            if (!(field instanceof MuliLangTextField) || !((MuliLangTextField)field).isGL()) continue;
            SqlObject sqlObj = new SqlObject();
            sqlObj.setParams(new SqlParameter[0]);
            String sql = String.format("ALTER TABLE %s ADD %s;", tableName, this.getFieldDesc((MuliLangTextField)field));
            sqlObj.setSql(sql);
            sqlList.add(sqlObj);
        }
        if (!sqlList.isEmpty()) {
            for (SqlObject sql : sqlList) {
                DB.execute((DBRoute)DBRoute.of((String)meta.getDBRouteKey()), (String)sql.getSql(), (Object[])sql.getParams());
            }
        }
    }

    private String getFieldDesc(MuliLangTextField field) {
        if (field.getMaxLength() > 0) {
            return String.format("%s NVARCHAR(%s) DEFAULT(' ') NOT NULL", field.getFieldName(), field.getMaxLength());
        }
        return String.format("%s NVARCHAR(255) DEFAULT(' ') NOT NULL", field.getFieldName());
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        ORM orm = ORM.create();
        String selectField = "number,name,id";
        String entityName = "bos_entityobject";
        QFilter filter = this.getModelFilter(evt.getNodeId().toString());
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection doc = orm.query(entityName, selectField, filters);
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (doc.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, doc.size());
        }
        for (int i = 0; i < doc.size(); ++i) {
            DynamicObject doj = (DynamicObject)doc.get(i);
            this.getModel().setValue("formname", doj.get("name"), i);
            this.getModel().setValue(FORMNUMBER, doj.get("number"), i);
        }
        ((EntryGrid)this.getControl(ENTRYENTITY)).setPageIndex(1);
    }

    protected QFilter getModelFilter(String nodeId) {
        QFilter qFilter = null;
        ORM orm = ORM.create();
        boolean isCloud = orm.exists("bos_devportal_bizcloud", (Object)nodeId);
        if (nodeId.equals("-1")) {
            qFilter = new QFilter("dentityid", "is not null", (Object)"");
        } else if (isCloud) {
            Object[] units = this.getUnitIdsByCloudId(nodeId);
            qFilter = new QFilter("bizappid", "in", (Object)units);
        } else {
            qFilter = new QFilter("bizappid", "=", (Object)nodeId);
        }
        return qFilter;
    }

    protected Object[] getUnitIdsByCloudId(String bizCloudId) {
        ArrayList<String> unitIds = new ArrayList<String>(10);
        ORM orm = ORM.create();
        QFilter q = new QFilter("bizcloud", "=", (Object)bizCloudId);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id";
        DynamicObjectCollection query = orm.query("bos_devportal_bizapp", selectFields, filters, "");
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            String bizAppId = dynamicObject.getString("id");
            unitIds.add(bizAppId);
        }
        return unitIds.toArray();
    }

    private void scan() {
        DynamicObjectCollection cols = this.getModel().getEntryEntity(ENTRYENTITY);
        HashMap<String, Integer> gridDataMapping = new HashMap<String, Integer>();
        ArrayList<SqlParameter> list = new ArrayList<SqlParameter>();
        for (Object dy : cols) {
            dy.set("detailmsg", (Object)"");
            dy.set(NEEDREPAIRE, (Object)false);
        }
        int i = 0;
        for (DynamicObject obj : cols) {
            gridDataMapping.put(obj.getString(FORMNUMBER), i++);
            list.add(new SqlParameter("fnumber", -9, (Object)obj.getString(FORMNUMBER)));
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid from t_meta_entitydesign where", new Object[0]).appendIn("fnumber", list.toArray());
        List ids = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, rs -> {
            ArrayList<String> idList = new ArrayList<String>(10);
            while (rs.next()) {
                idList.add(rs.getString("fid"));
            }
            return idList;
        });
        for (String id : ids) {
            EntityMetadata meta = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
            Map<String, List<MuliLangTextField>> datas = this.getMuliLangField(meta);
            boolean needRepair = false;
            StringBuilder builder = new StringBuilder();
            HashMap<String, List<String>> lackFields = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<MuliLangTextField>> data : datas.entrySet()) {
                if (StringUtils.isBlank((CharSequence)data.getKey()) || data.getValue().isEmpty() || this.checkGLFieldColumn(meta.getDBRouteKey(), data.getKey(), data.getValue(), builder, lackFields)) continue;
                needRepair = true;
            }
            if (!needRepair) continue;
            this.getModel().setValue("detailmsg", (Object)builder.toString(), ((Integer)gridDataMapping.get(meta.getKey())).intValue());
            this.getModel().setValue(NEEDREPAIRE, (Object)true, ((Integer)gridDataMapping.get(meta.getKey())).intValue());
            this.getModel().setValue("lackfields", (Object)SerializationUtils.toJsonString(lackFields), ((Integer)gridDataMapping.get(meta.getKey())).intValue());
        }
    }

    private Map<String, List<MuliLangTextField>> getMuliLangField(EntityMetadata meta) {
        List entitys = meta.getEntitys();
        HashMap<String, List<MuliLangTextField>> mapping = new HashMap<String, List<MuliLangTextField>>();
        for (Entity entity : entitys) {
            List items = entity.getItems();
            for (EntityItem item : items) {
                if (!(item instanceof MuliLangTextField) || !((MuliLangTextField)item).isGL() || !StringUtils.isNotBlank((CharSequence)((MuliLangTextField)item).getFieldName())) continue;
                String tableName = meta.getFieldByKey(item.getKey()).getTableName(entity);
                if (mapping.get(tableName) == null) {
                    ArrayList<MuliLangTextField> fields = new ArrayList<MuliLangTextField>();
                    fields.add((MuliLangTextField)item);
                    mapping.put(tableName, fields);
                    continue;
                }
                ((List)mapping.get(tableName)).add((MuliLangTextField)item);
            }
        }
        return mapping;
    }

    private Map<String, List<String>> getMuliLangKey(EntityMetadata meta) {
        List entitys = meta.getEntitys();
        HashMap<String, List<String>> mapping = new HashMap<String, List<String>>();
        for (Entity entity : entitys) {
            List items = entity.getItems();
            for (EntityItem item : items) {
                if (!(item instanceof MuliLangTextField) || !((MuliLangTextField)item).isGL() || !StringUtils.isNotBlank((CharSequence)((MuliLangTextField)item).getFieldName())) continue;
                String tableName = meta.getFieldByKey(item.getKey()).getTableName(entity);
                if (mapping.get(tableName) == null) {
                    ArrayList<String> fields = new ArrayList<String>();
                    fields.add(((MuliLangTextField)item).getKey().toLowerCase());
                    mapping.put(tableName, fields);
                    continue;
                }
                ((List)mapping.get(tableName)).add(((MuliLangTextField)item).getKey().toLowerCase());
            }
        }
        return mapping;
    }

    private boolean checkGLFieldColumn(String dbRoute, String tableName, List<MuliLangTextField> fileds, StringBuilder error, Map<String, List<String>> lackFields) {
        String mulTable = tableName + "_L";
        HashMap<String, String> fieldNames = new HashMap<String, String>(16);
        for (MuliLangTextField field : fileds) {
            fieldNames.put(field.getFieldName().toLowerCase(), field.getKey());
        }
        Map<String, DbMetadataColumn> fieldMapping = this.getColumn(dbRoute, tableName, fieldNames.keySet());
        Map<String, DbMetadataColumn> fieldLMapping = this.getColumn(dbRoute, mulTable, fieldNames.keySet());
        Set<String> fieldL = fieldLMapping.keySet();
        for (String key : fieldMapping.keySet()) {
            fieldL.remove(key);
            fieldNames.remove(key);
        }
        boolean result = true;
        if (fieldL.size() > 0) {
            error.append(ResManager.loadKDString((String)"\u4e3b\u8868\u591a\u8bed\u8a00\u901a\u7528\u5b57\u6bb5\u4e0d\u5b58\u5728: ", (String)"GLDataRepairListPlugin_1", (String)"bos-form-business", (Object[])new Object[0])).append(SerializationUtils.toJsonString(fieldL)).append("\r\n");
            lackFields.put(tableName, new ArrayList(fieldNames.values()));
            result = false;
        }
        for (String key : fieldMapping.keySet()) {
            int count = (Integer)DB.query((DBRoute)DBRoute.of((String)dbRoute), (String)String.format(" select count(1) as num from %s where %s is null or %s = '' or %s = ' ' ", tableName, key, key, key), rs -> {
                int num = 0;
                while (rs.next()) {
                    num = rs.getInt("num");
                }
                return num;
            });
            if (count <= 0) continue;
            error.append(ResManager.loadKDString((String)"\u4e3b\u8868\u591a\u8bed\u8a00\u901a\u7528\u5b57\u6bb5\u5b58\u5728\u7a7a\u503c: ", (String)"GLDataRepairListPlugin_2", (String)"bos-form-business", (Object[])new Object[0])).append(key).append("\r\n");
            result = false;
        }
        return result;
    }

    private Map<String, DbMetadataColumn> getColumn(String dbRoute, String tableName, Set<String> fileds) {
        HashMap<String, DbMetadataColumn> result = new HashMap<String, DbMetadataColumn>();
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)dbRoute), (String)tableName)) {
            return result;
        }
        DbMetadataTable tb = AlterTableUtil.getTableSchema((String)dbRoute, (String)tableName);
        if (fileds == null || fileds.isEmpty()) {
            return result;
        }
        for (DbMetadataColumn column : tb.getColumns()) {
            if (!fileds.contains(column.getName().toLowerCase())) continue;
            result.put(column.getName().toLowerCase(), column);
        }
        return result;
    }
}

