/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.url.UrlService;

public class CustomHoverMenuConfigPlugin
extends AbstractFormPlugin {
    private static final String CLICK = "1";
    private static final String ENTRY_ENTITY_PREFIX = "entryentity";
    private static final String ENTRY_ENTITY_1 = "entryentity1";
    private static final String ENTRY_ENTITY_2 = "entryentity2";
    private static final String ICON_PREFIX = "icon";
    private static final String ICON_1 = "icon1";
    private static final String ICON_2 = "icon2";
    private static final String IDE_PICTURE_SELECTOR = "ide_pictureselector";
    private static final String BTN_OK = "btnok";
    private static final String CUSTOM_HOVER_MENU_DETAIL = "customhovermenudetail";
    private static final String KEY_LEVEL = "level";
    private static final String KEY_HEADER = "header";
    private static final String KEY_CONTENT = "content";
    private static final String KEY_ISSHOW = "isShow";
    private static final String PROJECT_NAME = "bos-form-business";
    private static final String MULILANGHEADER = "mulilangheader";
    private static final String MULILANGCONTENT = "mulilangcontent";

    public void afterCreateNewData(EventObject e) {
        String customHoverMenuDetailStr = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_HOVER_MENU_DETAIL);
        if (StringUtils.isBlank((CharSequence)customHoverMenuDetailStr)) {
            return;
        }
        List list = SerializationUtils.fromJsonStringToList((String)customHoverMenuDetailStr, Map.class);
        if (list.isEmpty()) {
            return;
        }
        ArrayList<Map<String, Object>> firstClassList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> secondClassList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < list.size(); ++i) {
            Map item = (Map)list.get(i);
            Integer level = (Integer)item.get(KEY_LEVEL);
            if (level == null) {
                item.put(KEY_LEVEL, 2);
                level = 2;
            }
            if (level == 1) {
                firstClassList.add(item);
                continue;
            }
            if (level != 2) continue;
            secondClassList.add(item);
        }
        this.updateEntryData(ENTRY_ENTITY_1, firstClassList);
        this.updateEntryData(ENTRY_ENTITY_2, secondClassList);
    }

    private void updateEntryData(String entryName, List<Map<String, Object>> dataList) {
        if (dataList.isEmpty()) {
            return;
        }
        String levelStr = entryName.substring(entryName.length() - 1);
        this.getModel().beginInit();
        this.getModel().deleteEntryData(entryName);
        this.getModel().batchCreateNewEntryRow(entryName, dataList.size());
        DynamicObjectCollection entryEntityData = this.getModel().getEntryEntity(entryName);
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> item = dataList.get(i);
            DynamicObject dynamicObject = (DynamicObject)entryEntityData.get(i);
            String header = (String)item.get(KEY_HEADER);
            dynamicObject.set(KEY_HEADER + levelStr, (Object)header);
            dynamicObject.set(MULILANGHEADER + levelStr, (Object)this.getLocaleString(item.get(MULILANGHEADER), header));
            if ("2".equals(levelStr)) {
                String content = (String)item.get(KEY_CONTENT);
                dynamicObject.set(KEY_CONTENT + levelStr, (Object)content);
                dynamicObject.set(MULILANGCONTENT + levelStr, (Object)this.getLocaleString(item.get(MULILANGCONTENT), content));
            }
            dynamicObject.set(ICON_PREFIX + levelStr, item.get(ICON_PREFIX));
            dynamicObject.set("link" + levelStr, item.get("link"));
            if (CLICK.equals(levelStr)) {
                Object fireWay = item.get("fireway");
                dynamicObject.set("fireway", StringUtils.isEmpty((CharSequence)((String)fireWay)) ? "0" : fireWay);
                dynamicObject.set("eventnumber", item.get("eventnumber"));
            }
            dynamicObject.set(KEY_ISSHOW + levelStr, item.get(KEY_ISSHOW));
            dynamicObject.set(KEY_LEVEL + levelStr, (Object)Integer.valueOf(levelStr));
        }
        this.getModel().endInit();
        this.getView().updateView(entryName);
    }

    private ILocaleString getLocaleString(Object localeStr, String defaultValue) {
        Object localeData = localeStr instanceof Map && ((Map)localeStr).size() > 0 ? (ILocaleString)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)localeStr), LocaleString.class) : new LocaleString(defaultValue);
        return localeData;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ICON_1, ICON_2, BTN_OK});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (ICON_1.equals(key) || ICON_2.equals(key)) {
            this.showImageSelector(key);
        } else if (BTN_OK.equals(key)) {
            List<Map<String, Object>> paraList1 = this.getMaps(ENTRY_ENTITY_1);
            if (paraList1 == null) {
                return;
            }
            List<Map<String, Object>> paraList2 = this.getMaps(ENTRY_ENTITY_2);
            if (paraList2 == null) {
                return;
            }
            paraList1.addAll(paraList2);
            if (SerializationUtils.toJsonString(paraList1).length() > 2000) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201d\u81ea\u5b9a\u4e49\u60ac\u6d6e\u83dc\u5355\u201c\u7684\u5b57\u7b26\u6570\u603b\u548c\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,2000]", (String)"CustomHoverMenuConfigPlugin_2", (String)PROJECT_NAME, (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(paraList1);
            this.getView().close();
        }
    }

    private List<Map<String, Object>> getMaps(String entityName) {
        String levelStr = entityName.substring(entityName.length() - 1);
        DynamicObjectCollection entryEntityData = this.getModel().getEntryEntity(entityName);
        ArrayList<Map<String, Object>> paraList = new ArrayList<Map<String, Object>>(entryEntityData.size());
        ArrayList<String> eventKeys = new ArrayList<String>();
        for (int i = 0; i < entryEntityData.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntityData.get(i);
            if (!this.checkValid(dynamicObject, Integer.parseInt(levelStr))) {
                return null;
            }
            HashMap<String, Object> para = new HashMap<String, Object>(20);
            para.put(KEY_HEADER, dynamicObject.get(KEY_HEADER + levelStr));
            para.put(MULILANGHEADER, dynamicObject.get(MULILANGHEADER + levelStr));
            if ("2".equals(levelStr)) {
                para.put(KEY_CONTENT, dynamicObject.get(KEY_CONTENT + levelStr));
                para.put(MULILANGCONTENT, dynamicObject.get(MULILANGCONTENT + levelStr));
            }
            para.put(ICON_PREFIX, dynamicObject.get(ICON_PREFIX + levelStr));
            if (CLICK.equals(levelStr)) {
                Object fireWay = dynamicObject.get("fireway");
                para.put("fireway", fireWay);
                Object eventNumber = dynamicObject.get("eventnumber");
                if (CLICK.equals(fireWay)) {
                    if (eventNumber == null || StringUtils.isEmpty((CharSequence)((String)eventNumber))) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e00\u7ea7\u83dc\u5355\u7b2c%d\u884c\u7684\u4e8b\u4ef6\u6807\u8bc6\u3002", (String)"CustomHoverMenuConfigPlugin_1", (String)PROJECT_NAME, (Object[])new Object[0]), i + 1, eventNumber));
                        return null;
                    }
                    if (eventKeys.contains((String)eventNumber)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u6807\u8bc6\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u4e00\u7ea7\u83dc\u5355\u7b2c%d\u884c\u7684\u4e8b\u4ef6\u6807\u8bc6\u7684\u503c\u201c%s\u201d\u3002", (String)"CustomHoverMenuConfigPlugin_0", (String)PROJECT_NAME, (Object[])new Object[0]), i + 1, eventNumber));
                        eventKeys.clear();
                        return null;
                    }
                    para.put("eventnumber", eventNumber);
                    eventKeys.add((String)eventNumber);
                }
            }
            para.put("link", dynamicObject.get("link" + levelStr));
            para.put(KEY_ISSHOW, dynamicObject.get(KEY_ISSHOW + levelStr));
            para.put(KEY_LEVEL, Integer.valueOf(levelStr));
            paraList.add(para);
        }
        return paraList;
    }

    private boolean checkValid(DynamicObject dynamicObject, int level) {
        ILocaleString localeContent;
        String header = "";
        ILocaleString localeHeader = dynamicObject.getLocaleString(MULILANGHEADER + level);
        if (localeHeader != null) {
            header = localeHeader.getLocaleValue();
        }
        String content = "";
        if (level == 2 && (localeContent = dynamicObject.getLocaleString("mulilangcontent2")) != null) {
            content = localeContent.getLocaleValue();
        }
        String icon = dynamicObject.getString(ICON_PREFIX + level);
        if (StringUtils.isBlank((CharSequence)header) || StringUtils.isBlank((CharSequence)icon) || level == 2 && StringUtils.isBlank((CharSequence)content)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u9879", (String)"CustomHoverMenuConfigPlugin_3", (String)PROJECT_NAME, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void showImageSelector(String key) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(IDE_PICTURE_SELECTOR);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectImage_" + key));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        if (actionId.startsWith("selectImage")) {
            String levelStr = actionId.substring(actionId.length() - 1);
            Map imgData = (Map)evt.getReturnData();
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_ENTITY_PREFIX + levelStr);
            int rowKey = grid.getEntryState().getFocusRow();
            String rootUrl = UrlService.getDomainContextUrl();
            if (StringUtils.isBlank(imgData.get("value"))) {
                this.getModel().setValue(ICON_PREFIX + levelStr, (Object)"", rowKey);
            } else {
                this.getModel().setValue(ICON_PREFIX + levelStr, (Object)(rootUrl + imgData.get("value")), rowKey);
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        if ("clickTipsLink".equals(e.getKey()) && "openform".equals(e.getEventArgs()) || (ICON_1.equals(e.getKey()) || ICON_2.equals(e.getKey())) && "openform".equals(e.getEventName())) {
            IFormView parentView = this.getView().getParentView();
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("ide_pictureresediter");
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            parameter.setCaption(ResManager.loadKDString((String)"\u9759\u6001\u8d44\u6e90\u7ef4\u62a4", (String)"CustomHoverMenuConfigPlugin_4", (String)PROJECT_NAME, (Object[])new Object[0]));
            parentView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(parentView);
        }
    }
}

