/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.report;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class ReportExportDownloadPlugin
extends AbstractBillPlugIn {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String DOWNLOAD_PANEL = "downloadpanel";
    private static final String BTN_EXPORT = "btnexport";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_EXPORT});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void beforeBindData(EventObject e) {
        Object taskId = this.getView().getFormShowParameter().getCustomParam("taskId");
        if (StringUtils.isBlank((Object)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId.toString());
        this.getModel().setValue("endtime", (Object)new Date(taskInfo.getEndTime()));
        String dataStr = taskInfo.getData();
        String jobId = taskInfo.getJobId();
        DynamicObject jobInfo = BusinessDataServiceHelper.loadSingle((Object)jobId, (String)"sch_job", (String)"name, runbyuser");
        if (jobInfo == null) {
            return;
        }
        this.getModel().setValue("name", jobInfo.get("name"));
        DynamicObject creator = (DynamicObject)jobInfo.get("runbyuser");
        String createId = creator.getString("id");
        if (!StringUtils.equals((CharSequence)createId, (CharSequence)RequestContext.get().getUserId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DOWNLOAD_PANEL});
            this.getView().showMessage(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u7528\u6237\u5bfc\u51fa\u6587\u4ef6\uff0c\u65e0\u6743\u4e0b\u8f7d\u3002", (String)"ReportExportDownloadPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (taskInfo.isFailure()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DOWNLOAD_PANEL});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u5bfc\u51fa\u4efb\u52a1\u5931\u8d25\uff0c\u65e0\u6cd5\u4e0b\u8f7d\u6587\u4ef6\u3002", (String)"ReportExportDownloadPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)dataStr, Map.class);
        String url = (String)data.get("downloadurl");
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DOWNLOAD_PANEL});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4e0b\u8f7d\u6587\u4ef6\u3002", (String)"ReportExportDownloadPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{DOWNLOAD_PANEL});
        this.getPageCache().put("url", url);
    }

    public void click(EventObject evt) {
        if (BTN_EXPORT.equals(((Control)evt.getSource()).getKey())) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.addAction("download", (Object)this.getPageCache().get("url"));
        }
    }
}

