/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.tools;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Html;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;
import kd.bos.xdb.xpm.metrics.inspector.XDBInspectResult;
import kd.bos.xdb.xpm.metrics.inspector.XDBInspector;

public class SQLInspectorPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handle();
    }

    private void handle() {
        Object dbRouteObject = this.getView().getFormShowParameter().getCustomParams().get("dbroute");
        Object sqlObject = this.getView().getFormShowParameter().getCustomParams().get("sql");
        if (dbRouteObject instanceof String && sqlObject instanceof String) {
            String dbRouteText = (String)dbRouteObject;
            String sql = (String)sqlObject;
            DBRoute dbRoute = DBRoute.basedata;
            if (!StringUtils.isEmpty((String)dbRouteText)) {
                dbRoute = DBRoute.of((String)dbRouteText);
            }
            this.inspect(dbRouteText, sql);
        }
    }

    private void inspect(String route, String sql) {
        Date now = new Date();
        if (!XDBConfig.isXDBEnabled()) {
            this.showMessage("----------------WARN----------------\nXDB was disabled!", true, now);
            return;
        }
        try {
            XDBInspectResult inspect = XDBInspector.inspect((String)route, (String)sql, null);
            StringBuilder sb = new StringBuilder();
            sb.append("<div class='seg1'>SQL</div>\n").append(sql);
            sb.append("\n\n<div class='seg1'>Metrics(").append(inspect.getMetricsCollectors().length).append(")</div>");
            for (MetricsCollector mc : inspect.getMetricsCollectors()) {
                sb.append('\n').append(mc);
            }
            sb.append("\n\n<div class='seg1'>AllSQL(").append(inspect.getAllSQL().size()).append(")</div>");
            int i = 0;
            for (String s : inspect.getAllSQL()) {
                int p = s.indexOf(10);
                if (p != -1) {
                    sb.append("\n<b class='seg2'>").append(++i).append(". ").append(s.substring(0, p)).append("</b>").append(s.substring(p + 1));
                    continue;
                }
                sb.append("\n<b class='seg2'>No.").append(++i).append(" </b>").append(s);
            }
            sb.append("\n\n<b class='seg1'>END</b>\n");
            this.showMessage(sb.toString(), false, now);
        }
        catch (Exception e) {
            this.showMessage("<b class='seg1'>ERROR</b>\n" + e.getMessage(), true, now);
        }
    }

    private void showMessage(String msg, boolean warnOrError, Date now) {
        long used = System.currentTimeMillis() - now.getTime();
        Html html = (Html)this.getView().getControl("txtresult");
        String color = warnOrError ? "red" : "black";
        StringBuilder sb = new StringBuilder(4096);
        sb.append("<i>inspect @").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(now)).append(" use ").append(used).append("ms</i><br/>");
        sb.append("<style type='text/css'> .seg1{color:black;font-weight:bold;background-color:#fc9;padding:5px;} .seg2,.seg2h{font-weight:bold;color:#39f;display:inline;white-space:nowrap;}");
        sb.append(" .seg2h{background-color:#e2e2e2;padding:2px;} #txtresult{line-height:135%;font-size:120%;word-break:break-all;color:").append(color).append(";overflow:scroll;}</style>");
        int i = 0;
        for (String line : msg.split("\n")) {
            if ((line = line.replaceAll("\r\n", "<br/>").replaceAll("\n", "<br/>").replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;")).startsWith("[")) {
                String seg;
                if (line.startsWith("[SQLFeature]")) {
                    seg = "seg2h";
                    line = ++i + ". " + line;
                } else {
                    seg = "seg2";
                }
                line = "<b class='" + seg + "'>" + line + "</b>";
            } else {
                line = line + "<br/>";
            }
            sb.append(line);
        }
        html.setConent(sb.toString());
    }
}

