/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.tools;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.tools.Column;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class SQLResultGrid
extends AbstractFormPlugin {
    private static final int timeout = 60;
    private static final String FSEQ_NAME = "fseq";
    private static final String TABLE_KEY_ENTRYENTITY = "entryentity";
    private static final int PAGE_ROW = 50;
    public static final String COLUMN_LIST = "columnList";
    public static final String DATA_LIST = "dataList";
    public static final String INDEX = "index";
    public static final String DBROUTE = "dbRoute";
    public static final String SQL = "sql";
    private static final String DATAINDEX = "dataIndex";
    private static final String HEADER = "header";
    private static final Log log = LogFactory.getLog(SQLResultGrid.class);
    private static final int line_num = 1000;

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleBusinessLogic();
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    private void handleBusinessLogic() {
        Object dbRouteObject = this.getView().getFormShowParameter().getCustomParams().get(DBROUTE);
        Object sqlObject = this.getView().getFormShowParameter().getCustomParams().get(SQL);
        if (dbRouteObject != null && sqlObject instanceof String) {
            String dbRouteText = (String)dbRouteObject;
            String sql = (String)sqlObject;
            DBRoute dbRoute = DBRoute.basedata;
            if (!StringUtils.isEmpty((String)dbRouteText)) {
                dbRoute = DBRoute.of((String)dbRouteText);
            }
            ArrayList<Column> columnList = new ArrayList<Column>(16);
            List<List<Object>> dataList = this.getData(dbRoute, sql, columnList);
            if (columnList.size() > 0) {
                this.createGrid(this.getCoulumnList(columnList), TABLE_KEY_ENTRYENTITY);
                if (dataList != null) {
                    this.setGridData(this.getCoulumnList(columnList), dataList, TABLE_KEY_ENTRYENTITY);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private List<List<Object>> getData(DBRoute dbRoute, String sql, List<Column> columnList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> getCoulumnList(List<Column> columnList) {
        ArrayList<String> reutrnList = null;
        if (columnList != null) {
            reutrnList = new ArrayList<String>(10);
            for (Column column : columnList) {
                if (column.getName().indexOf(".") != -1) {
                    reutrnList.add(column.getName().replace(".", "\u00b7"));
                    continue;
                }
                reutrnList.add(column.getName());
            }
        }
        return reutrnList;
    }

    private void setGridData(List<String> colNames, List<List<Object>> rs, String gridKey) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("dataindex", this.getDataIndex(colNames));
        data.put("rows", rs);
        data.put("datacount", rs.size());
        data.put("isSelectedAll", Boolean.FALSE);
        data.put("isSplitPage", Boolean.FALSE);
        data.put("pagerows", 50);
        data.put("pageindex", 1);
        int pageCount = this.getPageCount(50, rs.size());
        data.put("pagecount", pageCount);
        data.put("realPageCount", pageCount);
        data.put("rowcount", 50);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setEntryProperty(TABLE_KEY_ENTRYENTITY, "data", data);
    }

    private int getPageCount(int pageRow, int total) {
        int pageCount = 0;
        pageCount = total / pageRow;
        if (total / pageRow > pageCount) {
            ++pageCount;
        }
        if (pageCount < 0) {
            pageCount = 0;
        }
        return pageCount;
    }

    private Map<String, Integer> getDataIndex(List<String> colNames) {
        LinkedHashMap<String, Integer> dataIndex = new LinkedHashMap<String, Integer>(16);
        dataIndex.put("rk", 0);
        dataIndex.put(FSEQ_NAME, 1);
        for (int i = 0; i < colNames.size(); ++i) {
            String key = colNames.get(i);
            if (dataIndex.containsKey(key)) {
                key = key + "_" + i;
            }
            dataIndex.put(key, i + 2);
        }
        return dataIndex;
    }

    private void createGrid(List<String> colNames, String gridKey) {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("key", gridKey);
        meta.put("methodname", "createGridColumns");
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("rk", "rk");
        args.put("seq", FSEQ_NAME);
        args.put("columns", this.createColumns(colNames));
        meta.put("args", new Map[]{args});
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("InvokeControlMethod", meta);
    }

    public List<Map<String, Object>> createColumns(List<String> colNames) {
        LinkedHashMap<String, Integer> dataIndex = new LinkedHashMap<String, Integer>(16);
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(10);
        cols.add(SQLResultGrid.genRKColumn());
        cols.add(SQLResultGrid.genSeqColumn());
        for (int i = 0; i < colNames.size(); ++i) {
            String dataIndex_key = colNames.get(i);
            String view_key = colNames.get(i);
            if (dataIndex.containsKey(dataIndex_key)) {
                dataIndex_key = dataIndex_key + "_" + i;
            }
            dataIndex.put(dataIndex_key, i + 2);
            cols.add(this.createColumn(dataIndex_key, view_key));
        }
        return cols;
    }

    public static Map<String, Object> genSeqColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put(DATAINDEX, FSEQ_NAME);
        map.put(HEADER, new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"SQLResultGrid_0", (String)"bos-form-business", (Object[])new Object[0])));
        map.put("isColPageFixed", Boolean.TRUE);
        map.put("type", "numberfield");
        map.put("width", 100);
        return map;
    }

    public static Map<String, Object> genRKColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put(DATAINDEX, "rk");
        map.put(HEADER, new LocaleString("rk"));
        map.put("visible", Boolean.FALSE);
        map.put("width", "50");
        return map;
    }

    public Map<String, Object> createColumn(String dataIndex_key, String view_key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("visible", true);
        map.put(DATAINDEX, dataIndex_key);
        map.put(HEADER, new LocaleString(view_key));
        return map;
    }
}

