/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.tools.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.plugin.tools.ast.Column;
import kd.bos.form.plugin.tools.ast.JoinTable;
import kd.bos.form.plugin.tools.ast.SimpleColumn;
import kd.bos.form.plugin.tools.ast.SimpleTable;
import kd.bos.form.plugin.tools.ast.SubTable;
import kd.bos.form.plugin.tools.ast.Table;

public class Query {
    private List<Column> select = new ArrayList<Column>();
    private List<Column> condition = new ArrayList<Column>();
    private final Map<String, Column> columnAliasMap = new HashMap<String, Column>();
    private final Map<String, Table> tableAliasMap = new HashMap<String, Table>();
    private Table mainTable;

    public Column getColumnName(String alias) {
        return this.columnAliasMap.get(alias);
    }

    public void putSelectColumn(Column column) {
        this.columnAliasMap.put(column.getAlias(), column);
        this.select.add(column);
    }

    public void putConditionColumn(List<SimpleColumn> columns) {
        this.condition.addAll(columns);
    }

    public void initTable(Table table) {
        if (table instanceof SimpleTable) {
            this.tableAliasMap.put(((SimpleTable)table).getAlias(), table);
            if (this.mainTable == null) {
                this.mainTable = table;
            }
        } else if (table instanceof SubTable) {
            this.tableAliasMap.put(((SubTable)table).getTableAlias(), table);
            if (this.mainTable == null) {
                this.mainTable = table;
            }
        } else if (table instanceof JoinTable) {
            this.initTable(((JoinTable)table).getLeft());
            this.initTable(((JoinTable)table).getRight());
            List<Column> conditionColumns = ((JoinTable)table).getCondition();
            for (Column conditionColumn : conditionColumns) {
                for (SimpleColumn simpleColumn : conditionColumn.getSimpleColumn()) {
                    Table t = this.tableAliasMap.get(simpleColumn.getTable());
                    if (t == null) {
                        throw new RuntimeException(String.format("Unknown table alias:%s on condition.", simpleColumn.getTable()));
                    }
                    this.condition.addAll(this.relevanceTable(simpleColumn, t));
                }
            }
        }
    }

    private List<SimpleColumn> relevanceTable(SimpleColumn column, Table table) {
        if (table instanceof SimpleTable) {
            ArrayList<SimpleColumn> scs = new ArrayList<SimpleColumn>();
            column.setTable(((SimpleTable)table).getName());
            scs.add(column);
            return scs;
        }
        if (((SubTable)table).getQuery().getSelect().size() == 1) {
            return ((SubTable)table).getQuery().getSelect().get(0).getSimpleColumn();
        }
        Column subColumn = ((SubTable)table).getQuery().getColumnName(column.getAlias());
        return subColumn.getSimpleColumn();
    }

    public Table getMainTable() {
        return this.mainTable;
    }

    public Table getTableByAlias(String tableAlias) {
        return this.tableAliasMap.get(tableAlias);
    }

    public List<Column> getSelect() {
        return this.select;
    }

    public List<Column> getCondition() {
        return this.condition;
    }
}

