/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.upgrade;

import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DepolyjarListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(DepolyjarListPlugin.class);
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    public void itemClick(ItemClickEvent evt) {
        if (evt.getItemKey().equals("download")) {
            ListSelectedRowCollection rows = this.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)rows)) {
                return;
            }
            List<JarData> list = this.getJarData(rows);
            if (CollectionUtils.isEmpty(list)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u884c\u6ca1\u6709jar\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepolyjarListPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return;
            }
            this.createZipData(list);
        }
    }

    private void createZipData(List<JarData> list) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ZipOutputStream out = new ZipOutputStream(bos);){
            for (JarData jarData : list) {
                ZipEntry entry = new ZipEntry(jarData.number.endsWith(".jar") ? jarData.number : jarData.number + ".jar");
                entry.setMethod(8);
                out.putNextEntry(entry);
                out.write(jarData.jar);
                out.closeEntry();
                out.flush();
            }
        }
        catch (Exception ex) {
            logger.error("\u751f\u6210zip\u6587\u4ef6\u5931\u8d25\u3002{}", (Object)ex.getMessage(), (Object)ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210zip\u6587\u4ef6\u5931\u8d25\u3002", (String)"DepolyjarListPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddhhmmss");
        String fileName = "HotSwap_" + sf.format(new Date()) + ".zip";
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, bos.toByteArray(), 5000);
        this.getView().openUrl(url);
    }

    private List<JarData> getJarData(ListSelectedRowCollection rows) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fnumber,fjar from t_meta_ext_jar where ", new Object[0]);
        sql.appendIn("fid ", rows.getPrimaryKeyValues());
        ArrayList<JarData> list = new ArrayList<JarData>(16);
        this.query(DBRoute.meta, sql, rs -> {
            while (rs.next()) {
                JarData jarData = new JarData();
                jarData.number = rs.getString("fnumber");
                jarData.jar = rs.getBytes("fjar");
                if (jarData.jar == null || jarData.jar.length <= 0) continue;
                list.add(jarData);
            }
            return null;
        });
        return list;
    }

    protected <T> T query(DBRoute dbRoute, SqlBuilder sb, ResultSetHandler<T> rh) {
        return (T)DB.query((DBRoute)dbRoute, (SqlBuilder)sb, rh);
    }

    static class JarData {
        public String number;
        public byte[] jar;

        JarData() {
        }
    }
}

