/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.rule;

import java.util.List;
import java.util.Map;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.rule.FormAction;
import kd.bos.form.rule.FormRuleExecuteContext;

public class ClientAction
extends FormAction {
    private String actionId;
    private List<String> dependencyFields;

    public void setParameter(Map<String, Object> param) {
        this.actionId = (String)param.get("actionId");
        this.dependencyFields = (List)param.get("dependencyFields");
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public List<String> getDependencyFields() {
        return this.dependencyFields;
    }

    public void setDependencyFields(List<String> dependencyFields) {
        this.dependencyFields = dependencyFields;
    }

    public void execute(FormRuleExecuteContext executeContext) {
        MainEntityType mainEntityType = executeContext.getModel().getDataEntityType();
        IClientViewProxy proxy = (IClientViewProxy)executeContext.getView().getService(IClientViewProxy.class);
        for (RowDataEntity rowDataEntity : executeContext.getDataEntities()) {
            int index = -1;
            if (!this.isLockWholeEntry(mainEntityType) && rowDataEntity.getDataEntity().getDynamicObjectType() instanceof EntryType) {
                index = rowDataEntity.getRowIndex();
                EntryGrid entryGrid = (EntryGrid)executeContext.getView().getControl(rowDataEntity.getDataEntity().getDynamicObjectType().getName());
                if (entryGrid != null && entryGrid.isStopUpdateCell()) continue;
            }
            proxy.addRuleAction(this.actionId, index);
        }
    }

    private boolean isLockWholeEntry(MainEntityType mainEntityType) {
        return this.dependencyFields == null ? false : this.dependencyFields.stream().anyMatch(field -> mainEntityType.findProperty(field).getParent() instanceof MainEntityType);
    }
}

