/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cloudmetric.alarm;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cloudmetric_plugin.meta.AlarmState;
import kd.bos.cloudmetric_plugin.meta.ComparisonOperator;
import kd.bos.cloudmetric_plugin.meta.Statistic;
import kd.bos.cloudmetric_plugin.meta.Unit;
import kd.bos.cloudmetric_plugin.utils.GetUrl;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.HttpUtils;

public class CloudAlarmUpdate
extends AbstractFormPlugin
implements UploadListener,
ClickListener,
RowClickEventListener {
    public void initialize() {
        this.addClickListeners(new String[]{"btnback", "btnupdate"});
        TextEdit edt1 = (TextEdit)this.getView().getControl("groupbydimensions");
        edt1.addButtonClickListener((ClickListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject evt) {
        List list = new ArrayList();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        list = (List)showParameter.getCustomParam("lookalarmlist");
        IDataModel model = this.getModel();
        model.setValue("category", ((Map)list.get(0)).get("category"));
        model.setValue("name", ((Map)list.get(0)).get("name"));
        model.setValue("description", ((Map)list.get(0)).get("description"));
        model.setValue("metricname", ((Map)list.get(0)).get("metricname"));
        model.setValue("groupbydimensions", ((Map)list.get(0)).get("groupbydimensions"));
        model.setValue("dimensionfilters", ((Map)list.get(0)).get("dimensionfilters"));
        model.setValue("period", ((Map)list.get(0)).get("period"));
        model.setValue("evaluationperiods", ((Map)list.get(0)).get("evaluationperiods"));
        model.setValue("statistic", ((Map)list.get(0)).get("statistic"));
        model.setValue("comparisonoperator", ((Map)list.get(0)).get("comparisonoperator"));
        model.setValue("threshold", ((Map)list.get(0)).get("threshold"));
        model.setValue("unit", ((Map)list.get(0)).get("unit"));
        model.setValue("actionenabled", ((Map)list.get(0)).get("actionenabled"));
    }

    private void updateForm() {
        List list = new ArrayList();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        list = (List)showParameter.getCustomParam("lookalarmlist");
        String row = ((Map)list.get(0)).get("row").toString();
        String category = ((Map)list.get(0)).get("category").toString();
        String name = ((Map)list.get(0)).get("name").toString();
        String metricName = ((Map)list.get(0)).get("metricname").toString();
        String description = this.getModel().getValue("description").toString();
        String stateUpdatedTimestamp = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp now = new Timestamp(System.currentTimeMillis());
        stateUpdatedTimestamp = df.format(now);
        String groupbydimensionStr = this.getModel().getValue("groupbydimensions").toString();
        String dimensionfilterStr = this.getModel().getValue("dimensionfilters").toString();
        String groupByDimensions = groupbydimensionStr;
        String dimensionFilters = dimensionfilterStr;
        String statisticStr = this.getModel().getValue("statistic").toString();
        Statistic statistic = Statistic.Count;
        if (statisticStr.equals("Count")) {
            statistic = Statistic.Count;
        } else if (statisticStr.equals("Average")) {
            statistic = Statistic.Average;
        } else if (statisticStr.equals("Max")) {
            statistic = Statistic.Max;
        } else if (statisticStr.equals("Min")) {
            statistic = Statistic.Min;
        } else if (statisticStr.equals("Sum")) {
            statistic = Statistic.Sum;
        }
        String stateStr = ((Map)list.get(0)).get("state").toString();
        AlarmState state = AlarmState.OK;
        if (stateStr.equals("OK")) {
            state = AlarmState.OK;
        } else if (stateStr.equals("ALARM")) {
            state = AlarmState.ALARM;
        } else if (stateStr.equals("INSUFFICIENT_DATA")) {
            state = AlarmState.INSUFFICIENT_DATA;
        }
        String comparisonoperatorStr = this.getModel().getValue("comparisonoperator").toString();
        ComparisonOperator comparisonOperator = ComparisonOperator.GE;
        if (comparisonoperatorStr.equals("GE")) {
            comparisonOperator = ComparisonOperator.GE;
        } else if (comparisonoperatorStr.equals("GT")) {
            comparisonOperator = ComparisonOperator.GT;
        } else if (comparisonoperatorStr.equals("LE")) {
            comparisonOperator = ComparisonOperator.LE;
        } else if (comparisonoperatorStr.equals("LT")) {
            comparisonOperator = ComparisonOperator.LT;
        }
        String unitStr = this.getModel().getValue("unit").toString();
        Unit unit = Unit.Percent;
        if (unitStr.equals("Percent")) {
            unit = Unit.Percent;
        } else if (unitStr.equals("Count")) {
            unit = Unit.Count;
        } else if (unitStr.equals("Megabytes")) {
            unit = Unit.Megabytes;
        } else if (unitStr.equals("Seconds")) {
            unit = Unit.Seconds;
        }
        String actionenabledStr = this.getModel().getValue("actionenabled").toString();
        boolean actionEnabled = true;
        if (actionenabledStr.equals("true")) {
            actionEnabled = true;
        } else if (actionenabledStr.equals("false")) {
            actionEnabled = false;
        }
        String periodStr = this.getModel().getValue("period").toString();
        int period = Integer.parseInt(periodStr);
        String evaluationPeriodsStr = this.getModel().getValue("evaluationperiods").toString();
        int evaluationPeriods = Integer.parseInt(evaluationPeriodsStr);
        String thresholdStr = this.getModel().getValue("threshold").toString();
        double threshold = Double.parseDouble(thresholdStr);
        HashMap<String, String> date = new HashMap<String, String>();
        date.put("row", row);
        date.put("name", name);
        date.put("description", description);
        date.put("category", category);
        date.put("metricName", metricName);
        date.put("stateUpdatedTimestamp", stateUpdatedTimestamp);
        date.put("groupByDimensions", groupbydimensionStr);
        date.put("dimensionFilters", dimensionfilterStr);
        date.put("statistic", statisticStr);
        date.put("state", stateStr);
        date.put("comparisonOperator", comparisonoperatorStr);
        date.put("unit", unitStr);
        date.put("actionEnabled", actionenabledStr);
        date.put("period", periodStr);
        date.put("evaluationPeriods", evaluationPeriodsStr);
        date.put("threshold", thresholdStr);
        String url = GetUrl.getUrl() + "/api/updateAlarm";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("content-type", "application/json");
        String argument = "{\"name\":\"" + name + "\",\"category\":\"" + category + "\",\"metricName\":\"" + metricName + "\",\"state\":\"" + (Object)((Object)state) + "\",\"description\":\"" + description + "\",\"dimensionFilters\":\"" + dimensionFilters + "\",\"groupByDimensions\":\"" + groupByDimensions + "\",\"period\":\"" + period + "\",\"evaluationPeriods\":\"" + evaluationPeriods + "\",\"statistic\":\"" + (Object)((Object)statistic) + "\",\"comparisonOperator\":\"" + (Object)((Object)comparisonOperator) + "\",\"threshold\":\"" + threshold + "\",\"unit\":\"" + (Object)((Object)unit) + "\",\"actionEnabled\":\"" + actionEnabled + "\",\"stateUpdatedTimestamp\":\"" + stateUpdatedTimestamp + "\"}";
        String jsonResult = HttpUtils.post((String)url, header, (String)argument);
        this.getView().returnDataToParent(date);
        this.getView().showMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u6570\u636e\u6210\u529f\uff01", (String)"CloudAlarmUpdate_0", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
        this.getView().close();
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnupdate".equalsIgnoreCase(c.getKey())) {
            this.updateForm();
        } else if ("btnback".equalsIgnoreCase(c.getKey())) {
            this.getView().close();
        } else if ("groupbydimensions".equalsIgnoreCase(c.getKey())) {
            this.selectDimensions();
        }
    }

    private void selectDimensions() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cloud_dimension_select");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectDimensions");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map date;
        if ("selectDimensions".equals(e.getActionId()) && (date = (Map)e.getReturnData()) != null) {
            IDataModel model = this.getModel();
            model.setValue("groupbydimensions", date.get("dimensions"));
        }
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
    }

    public void remove(UploadEvent arg0) {
    }

    public void upload(UploadEvent arg0) {
    }

    public void afterRemove(UploadEvent arg0) {
    }

    public void afterUpload(UploadEvent arg0) {
    }
}

