/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cloudmetric.dimension;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.cloudmetric.metric.MetricList;
import kd.bos.cloudmetric_plugin.utils.GetUrl;
import kd.bos.cloudmetric_plugin.utils.SeparateStringUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.login.utils.HttpUtils;

public class DimensionList
extends AbstractFormPlugin
implements UploadListener,
ClickListener,
RowClickEventListener {
    public void initialize() {
        Button btnNewForm = (Button)this.getView().getControl("btnadddimension");
        btnNewForm.addClickListener((ClickListener)this);
        Button btnupdate = (Button)this.getView().getControl("btnupdate");
        btnupdate.addClickListener((ClickListener)this);
        Button btndel = (Button)this.getView().getControl("btndelete");
        btndel.addClickListener((ClickListener)this);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("dimensionlist");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject evt) {
        List list = DimensionList.getDimensionsList();
        IDataModel model = this.getModel();
        if (list != null) {
            model.batchCreateNewEntryRow("dimensionlist", list.size());
            for (int i = 0; i < list.size(); ++i) {
                model.setValue("dimensionname", ((Map)list.get(i)).get("name"), list.size() - 1 - i);
                model.setValue("description", ((Map)list.get(i)).get("description"), list.size() - 1 - i);
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u5217\u8868\u4e3a\u7a7a\uff01", (String)"DimensionList_0", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
        }
    }

    private void addDimensionForm() {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addDimensionCloseBack");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cloud_dimension_add");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void delDimensionForm() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("dimensionlist");
        int row = grid.getEntryState().getFocusRow();
        if (row == -1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"DimensionList_1", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
            return;
        }
        String name = (String)this.getModel().getValue("dimensionname", row);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "delDimensionCloseBack");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cloud_delete_config");
        parameter.setCustomParam("message", (Object)String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u7ef4\u5ea6\u201c%s\u201d\u5417\uff1f\u8be5\u64cd\u4f5c\u53ef\u80fd\u4f1a\u5220\u6389\u5176\u4ed6\u7684\u5217\u8868\u9879", (String)"DimensionList_2", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]), name));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void updateDimensionForm() {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "updateDimensionCloseBack");
        List list = new ArrayList();
        list = this.getLookDimension();
        if (list == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"DimensionList_1", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cloud_dimension_update");
        parameter.setCustomParam("lookdimensionlist", list);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void delDimension() {
        boolean temp;
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("dimensionlist");
        int row = grid.getEntryState().getFocusRow();
        if (row == -1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"DimensionList_1", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
            return;
        }
        String name = (String)this.getModel().getValue("dimensionname", row);
        List metricList = MetricList.getMetricList();
        ArrayList metricDate = new ArrayList();
        for (int i = 0; i < metricList.size(); ++i) {
            String dimensions = SeparateStringUtil.separateString(((Map)metricList.get(i)).get("dimensions") + "");
            if (!dimensions.contains(name)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", ((Map)metricList.get(i)).get("name").toString());
            map.put("category", ((Map)metricList.get(i)).get("category").toString());
            metricDate.add(map);
        }
        boolean bl = temp = metricDate.size() != 0;
        if (temp && metricDate != null) {
            for (int i = 0; i < metricDate.size(); ++i) {
                String metricName = (String)((Map)metricDate.get(i)).get("name");
                String category = (String)((Map)metricDate.get(i)).get("category");
                String url = GetUrl.getUrl() + "/api/deleteMetric";
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("content-type", "application/json");
                String argument = "{\"name\":\"" + metricName + "\",\"category\":\"" + category + "\"}";
                String string = HttpUtils.post((String)url, header, (String)argument);
            }
        }
        String url = GetUrl.getUrl() + "/api/deleteDimension";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("content-type", "application/json");
        String argument = "{\"name\":\"" + name + "\"}";
        String jsonResult = HttpUtils.post((String)url, header, (String)argument);
        Map result = (Map)SerializationUtils.fromJsonString((String)jsonResult, Map.class);
        if (result.get("state").toString().equals("success")) {
            IDataModel model = this.getModel();
            model.deleteEntryRow("dimensionlist", row);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u9664\u6570\u636e\u6210\u529f\uff01", (String)"DimensionList_3", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25error\uff01", (String)"DimensionList_4", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("addDimensionCloseBack".equals(e.getActionId())) {
            Map date = (Map)e.getReturnData();
            if (date != null) {
                IDataModel model = this.getModel();
                int rowIndex = this.getModel().createNewEntryRow("dimensionlist");
                this.getModel().setValue("dimensionname", date.get("name"), rowIndex);
                this.getModel().setValue("description", date.get("description"), rowIndex);
            }
        } else if ("updateDimensionCloseBack".equals(e.getActionId())) {
            Map date = (Map)e.getReturnData();
            if (date != null) {
                IDataModel model = this.getModel();
                int row = Integer.parseInt((String)date.get("row"));
                this.getModel().setValue("description", date.get("description"), row);
            }
        } else if ("delDimensionCloseBack".equals(e.getActionId()) && "ok".equals(e.getReturnData())) {
            this.delDimension();
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btnadddimension": {
                this.addDimensionForm();
                break;
            }
            case "btnupdate": {
                this.updateDimensionForm();
                break;
            }
            case "btndelete": {
                this.delDimensionForm();
            }
        }
    }

    private List getLookDimension() {
        ArrayList lookActionList = new ArrayList();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("dimensionlist");
        int row = grid.getEntryState().getFocusRow();
        if (row == -1) {
            return null;
        }
        String name = (String)this.getModel().getValue("dimensionname", row);
        String description = (String)this.getModel().getValue("description", row);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("row", row);
        map.put("name", name);
        map.put("description", description);
        lookActionList.add(map);
        return lookActionList;
    }

    private static List getDimensionsList() {
        String url = GetUrl.getUrl() + "/api/dimensions";
        String jsonResult = HttpUtils.request((String)url);
        Map result = (Map)SerializationUtils.fromJsonString((String)jsonResult, Map.class);
        List list = (List)result.get("data");
        if (list != null) {
            return list;
        }
        return null;
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent evt0) {
        this.updateDimensionForm();
    }

    public void remove(UploadEvent arg0) {
    }

    public void upload(UploadEvent arg0) {
    }

    public void afterRemove(UploadEvent arg0) {
    }

    public void afterUpload(UploadEvent arg0) {
    }
}

