/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cloudmetric.metric;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cloudmetric_plugin.utils.GetUrl;
import kd.bos.cloudmetric_plugin.utils.SeparateStringUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.HttpUtils;

public class CloudMetricAdd
extends AbstractFormPlugin {
    private static final Object LocaleString = null;

    public void initialize() {
        this.addClickListeners(new String[]{"btnaddmetric", "btnback"});
        TextEdit edt = (TextEdit)this.getView().getControl("category");
        edt.addButtonClickListener((ClickListener)this);
        TextEdit edt1 = (TextEdit)this.getView().getControl("dimensions");
        edt1.addButtonClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnaddmetric".equalsIgnoreCase(c.getKey())) {
            this.addMetric();
        } else if ("btnback".equalsIgnoreCase(c.getKey())) {
            this.cancelAddAction();
        } else if ("category".equalsIgnoreCase(c.getKey())) {
            this.selectCategory();
        } else if ("dimensions".equalsIgnoreCase(c.getKey())) {
            this.selectDimensions();
        }
    }

    private void selectDimensions() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cloud_dimension_select");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectDimensions");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void selectCategory() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cloud_category_choose");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectCategory");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void addMetric() {
        if (this.getModel().getValue("name").equals(" ") || this.getModel().getValue("category").equals(" ")) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CloudMetricAdd_0", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
        } else {
            String category = this.getModel().getValue("category").toString();
            String name = this.getModel().getValue("name").toString();
            String description = this.getModel().getValue("description").toString();
            String dimension = this.getModel().getValue("dimensions").toString();
            String dimensions = SeparateStringUtil.separateToJsonString(dimension);
            String url = GetUrl.getUrl() + "/api/addMetric";
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("content-type", "application/json");
            String argument = "{\"category\":\"" + category + "\",\"name\":\"" + name + "\",\"description\":\"" + description + "\",\"dimensions\":[" + dimensions + "]}";
            String jsonResult = HttpUtils.post((String)url, header, (String)argument);
            Map result = (Map)SerializationUtils.fromJsonString((String)jsonResult, Map.class);
            if (result.get("state").toString().equals("success")) {
                HashMap<String, String> date = new HashMap<String, String>();
                date.put("name", name);
                date.put("description", description);
                date.put("category", category);
                date.put("dimensions", dimensions.replace("\"", ""));
                this.getView().returnDataToParent(date);
                this.getView().showMessage(ResManager.loadKDString((String)"\u6dfb\u52a0\u6210\u529f\uff01", (String)"CloudMetricAdd_1", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
                this.getView().close();
            } else if (result.get("state").toString().equals("error")) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6dfb\u52a0", (String)"CloudMetricAdd_2", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
            }
        }
    }

    public void cancelAddAction() {
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map date;
        if ("selectCategory".equals(e.getActionId())) {
            Map date2 = (Map)e.getReturnData();
            if (date2 != null) {
                IDataModel model = this.getModel();
                model.setValue("category", date2.get("categoryname"));
            }
        } else if ("selectDimensions".equals(e.getActionId()) && (date = (Map)e.getReturnData()) != null) {
            IDataModel model = this.getModel();
            model.setValue("dimensions", date.get("dimensions"));
        }
    }
}

