/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cloudmetric.metric;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.cloudmetric.actionhistory.CloudActionHistoryList;
import kd.bos.cloudmetric.alarm.CloudAlarmList;
import kd.bos.cloudmetric.alarmaction.CloudAlarmactionList;
import kd.bos.cloudmetric_plugin.utils.GetUrl;
import kd.bos.cloudmetric_plugin.utils.SeparateStringUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.login.utils.HttpUtils;

public class MetricList
extends AbstractFormPlugin
implements UploadListener,
ClickListener,
RowClickEventListener {
    public void initialize() {
        Button btnNewForm = (Button)this.getView().getControl("btnaddmetric");
        btnNewForm.addClickListener((ClickListener)this);
        Button btnupdate = (Button)this.getView().getControl("btnupdate");
        btnupdate.addClickListener((ClickListener)this);
        Button btndel = (Button)this.getView().getControl("btndelete");
        btndel.addClickListener((ClickListener)this);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("metriclist");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject evt) {
        List list = MetricList.getMetricList();
        IDataModel model = this.getModel();
        if (list != null) {
            model.batchCreateNewEntryRow("metriclist", list.size());
            for (int i = 0; i < list.size(); ++i) {
                String dimensions = SeparateStringUtil.separateString(((Map)list.get(i)).get("dimensions") + "");
                model.setValue("dimensions", (Object)dimensions, list.size() - 1 - i);
                model.setValue("category", (Object)(((Map)list.get(i)).get("category") + ""), list.size() - 1 - i);
                model.setValue("name", ((Map)list.get(i)).get("name"), list.size() - 1 - i);
                model.setValue("description", ((Map)list.get(i)).get("description"), list.size() - 1 - i);
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u5217\u8868\u4e3a\u7a7a\uff01", (String)"MetricList_0", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("addMetricCloseBack".equals(e.getActionId())) {
            Map date = (Map)e.getReturnData();
            if (date != null) {
                IDataModel model = this.getModel();
                int rowIndex = this.getModel().createNewEntryRow("metriclist");
                this.getModel().setValue("name", date.get("name"), rowIndex);
                this.getModel().setValue("description", date.get("description"), rowIndex);
                this.getModel().setValue("category", date.get("category"), rowIndex);
                this.getModel().setValue("dimensions", date.get("dimensions"), rowIndex);
            }
        } else if ("updateMetricCloseBack".equals(e.getActionId())) {
            Map date = (Map)e.getReturnData();
            if (date != null) {
                IDataModel model = this.getModel();
                int row = Integer.parseInt((String)date.get("row"));
                this.getModel().setValue("description", date.get("description"), row);
                this.getModel().setValue("dimensions", date.get("dimensions"), row);
            }
        } else if ("delMetricCloseBack".equals(e.getActionId()) && "ok".equals(e.getReturnData())) {
            this.delMetric();
        }
    }

    private void addMetricForm() {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addMetricCloseBack");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hyc_cloud_metricadd");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void updateMetricForm() {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "updateMetricCloseBack");
        List list = new ArrayList();
        list = this.getLookMetric();
        if (list == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"MetricList_1", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hyc_cloud_metricupdate");
        parameter.setCustomParam("lookmetriclist", list);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void delMetricForm() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("metriclist");
        int row = grid.getEntryState().getFocusRow();
        if (row == -1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"MetricList_1", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
            return;
        }
        String name = (String)this.getModel().getValue("name", row);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "delMetricCloseBack");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cloud_delete_config");
        parameter.setCustomParam("message", (Object)String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u6307\u6807\u201c%s\u201d\u5417\uff1f\u8be5\u64cd\u4f5c\u53ef\u80fd\u4f1a\u5220\u6389\u5176\u4ed6\u7684\u5217\u8868\u9879", (String)"MetricList_2", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]), name));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private List getLookMetric() {
        ArrayList lookActionList = new ArrayList();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("metriclist");
        int row = grid.getEntryState().getFocusRow();
        if (row == -1) {
            return null;
        }
        String category = (String)this.getModel().getValue("category", row);
        String name = (String)this.getModel().getValue("name", row);
        String description = (String)this.getModel().getValue("description", row);
        String dimensions = (String)this.getModel().getValue("dimensions", row);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("row", row);
        map.put("category", category);
        map.put("name", name);
        map.put("description", description);
        map.put("dimensions", dimensions);
        lookActionList.add(map);
        return lookActionList;
    }

    private void delMetric() {
        boolean temp;
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("metriclist");
        int row = grid.getEntryState().getFocusRow();
        if (row == -1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"MetricList_1", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
            return;
        }
        String name = (String)this.getModel().getValue("name", row);
        List alarmList = CloudAlarmList.getAlarmList();
        List actionList = CloudAlarmactionList.getAlarmactionList();
        List actionhistoryList = CloudActionHistoryList.getActionHistoryList();
        ArrayList alarmDate = new ArrayList();
        for (int i = 0; i < alarmList.size(); ++i) {
            if (!((Map)alarmList.get(i)).get("metricName").equals(name)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", ((Map)alarmList.get(i)).get("name").toString());
            map.put("category", ((Map)alarmList.get(i)).get("category").toString());
            map.put("metricName", ((Map)alarmList.get(i)).get("metricName").toString());
            alarmDate.add(map);
        }
        ArrayList actionDate = new ArrayList();
        for (int i = 0; i < actionList.size(); ++i) {
            if (!((Map)actionList.get(i)).get("metricName").equals(name)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", ((Map)actionList.get(i)).get("name").toString());
            map.put("category", ((Map)actionList.get(i)).get("category").toString());
            map.put("metricName", ((Map)actionList.get(i)).get("metricName").toString());
            map.put("alarmName", ((Map)actionList.get(i)).get("alarmName").toString());
            actionDate.add(map);
        }
        ArrayList actionhistoryDate = new ArrayList();
        for (int i = 0; i < actionhistoryList.size(); ++i) {
            if (!((Map)actionhistoryList.get(i)).get("metricName").equals(name)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("actionName", ((Map)actionhistoryList.get(i)).get("actionName").toString());
            map.put("category", ((Map)actionhistoryList.get(i)).get("category").toString());
            map.put("metricName", ((Map)actionhistoryList.get(i)).get("metricName").toString());
            map.put("alarmName", ((Map)actionhistoryList.get(i)).get("alarmName").toString());
            actionhistoryDate.add(map);
        }
        boolean bl = temp = alarmDate.size() != 0 || actionDate.size() != 0 || actionhistoryDate.size() != 0;
        if (temp) {
            String string;
            String argument;
            HashMap<String, String> header;
            String url;
            String alarmName;
            String actionName;
            String metricName;
            String category;
            if (alarmDate != null) {
                for (int i = 0; i < alarmDate.size(); ++i) {
                    String alarmName2 = (String)((Map)alarmDate.get(i)).get("name");
                    category = (String)((Map)alarmDate.get(i)).get("category");
                    metricName = (String)((Map)alarmDate.get(i)).get("metricName");
                    String url2 = GetUrl.getUrl() + "/api/deleteAlarm";
                    HashMap<String, String> header2 = new HashMap<String, String>();
                    header2.put("content-type", "application/json");
                    String argument2 = "{\"name\":\"" + alarmName2 + "\",\"category\":\"" + category + "\",\"metricName\":\"" + metricName + "\"}";
                    String string2 = HttpUtils.post((String)url2, header2, (String)argument2);
                }
            }
            if (actionDate != null) {
                for (int i = 0; i < actionDate.size(); ++i) {
                    actionName = (String)((Map)actionDate.get(i)).get("name");
                    category = (String)((Map)actionDate.get(i)).get("category");
                    metricName = (String)((Map)actionDate.get(i)).get("metricName");
                    alarmName = (String)((Map)actionDate.get(i)).get("alarmName");
                    url = GetUrl.getUrl() + "/api/deleteAlarmAction";
                    header = new HashMap<String, String>();
                    header.put("content-type", "application/json");
                    argument = "{\"name\":\"" + actionName + "\",\"category\":\"" + category + "\",\"alarmName\":\"" + alarmName + "\",\"metricName\":\"" + metricName + "\"}";
                    string = HttpUtils.post((String)url, header, (String)argument);
                }
            }
            if (actionhistoryDate != null) {
                for (int i = 0; i < actionhistoryDate.size(); ++i) {
                    actionName = (String)((Map)actionhistoryDate.get(i)).get("actionName");
                    category = (String)((Map)actionhistoryDate.get(i)).get("category");
                    metricName = (String)((Map)actionhistoryDate.get(i)).get("metricName");
                    alarmName = (String)((Map)actionhistoryDate.get(i)).get("alarmName");
                    url = GetUrl.getUrl() + "/api/deleteAlarmActionHistory";
                    header = new HashMap();
                    header.put("content-type", "application/json");
                    argument = "{\"category\":\"" + category + "\",\"metricName\":\"" + metricName + "\",\"alarmName\":\"" + alarmName + "\",\"actionName\":\"" + actionName + "\"}";
                    string = HttpUtils.post((String)url, header, (String)argument);
                }
            }
        }
        String category = (String)this.getModel().getValue("category", row);
        String url = GetUrl.getUrl() + "/api/deleteMetric";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("content-type", "application/json");
        String argument = "{\"name\":\"" + name + "\",\"category\":\"" + category + "\"}";
        String jsonResult = HttpUtils.post((String)url, header, (String)argument);
        Map result = (Map)SerializationUtils.fromJsonString((String)jsonResult, Map.class);
        if (result.get("state").toString().equals("success")) {
            IDataModel model = this.getModel();
            model.deleteEntryRow("metriclist", row);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u9664\u6570\u636e\u6210\u529f\uff01", (String)"MetricList_3", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25error\uff01", (String)"MetricList_4", (String)"bos-cloudmetric-plugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btnaddmetric": {
                this.addMetricForm();
                break;
            }
            case "btnupdate": {
                this.updateMetricForm();
                break;
            }
            case "btndelete": {
                this.delMetricForm();
            }
        }
    }

    public static List getMetricList() {
        String url = GetUrl.getUrl() + "/api/metrics";
        String jsonResult = HttpUtils.request((String)url);
        Map result = (Map)SerializationUtils.fromJsonString((String)jsonResult, Map.class);
        List list = (List)result.get("data");
        if (list != null) {
            return list;
        }
        return null;
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent evt0) {
        this.updateMetricForm();
    }

    public void remove(UploadEvent arg0) {
    }

    public void upload(UploadEvent arg0) {
    }

    public void afterRemove(UploadEvent arg0) {
    }

    public void afterUpload(UploadEvent arg0) {
    }
}

