/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.trace.cache.MessagePackage;

class EntityTraceCache {
    private static final String REGION_KEY = "entitytrace";
    private static final String TYPE_CONFIG = "config";
    private static final String KEY_REALTIME = "rt";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("entitytrace", new DistributeCacheHAPolicy());
    private static final int DEF_TIMEOUTSEC = 300;
    private static final int REALTIME_TIMEOUT_SEC = 1200;

    private EntityTraceCache() {
    }

    private static String buildType() {
        RequestContext ctx = RequestContext.get();
        return String.format("%s.%s.%s", ctx.getAccountId(), ctx.getCurrUserId(), ctx.getGlobalSessionId());
    }

    private static int getTimeOutSec() {
        return 300;
    }

    public static void put(MessagePackage msgPackage) {
        if (EntityTraceCache.isRealtime()) {
            String msgStr = SerializationUtils.toJsonString((Object)msgPackage);
            cache.put(EntityTraceCache.buildType(), String.valueOf(msgPackage.getCreateTime()), msgStr, EntityTraceCache.getTimeOutSec());
        }
    }

    public static List<MessagePackage> getAndRemove() {
        String type = EntityTraceCache.buildType();
        Map vals = cache.getAll(type);
        if (vals.isEmpty()) {
            return new ArrayList<MessagePackage>(0);
        }
        ArrayList<MessagePackage> list = new ArrayList<MessagePackage>(vals.size());
        for (Map.Entry entry : vals.entrySet()) {
            String val = (String)entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)val)) continue;
            MessagePackage msgPackage = (MessagePackage)SerializationUtils.fromJsonString((String)val, MessagePackage.class);
            list.add(msgPackage);
        }
        cache.remove(type, vals.keySet().toArray(new String[0]));
        return list;
    }

    public static void setRealtime(boolean realtime) {
        String type = "config." + EntityTraceCache.buildType();
        if (realtime) {
            cache.put(type, KEY_REALTIME, "1", 1200);
        } else {
            cache.remove(type, KEY_REALTIME);
            cache.remove(EntityTraceCache.buildType());
        }
    }

    public static boolean isRealtime() {
        String type = "config." + EntityTraceCache.buildType();
        String val = (String)cache.get(type, KEY_REALTIME);
        return StringUtils.equals((CharSequence)val, (CharSequence)"1");
    }
}

