/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.config;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.trace.EntityTraceConfig;
import kd.bos.dataentity.trace.ListenSchemeParam;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.trace.scheme.ListenScheme;
import kd.bos.entity.trace.scheme.ListenSchemeLoader;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class EntityTraceConfigReader {
    private static final String KEY_REALTIME = "realtime";
    private static final String KEY_CREATER = "creatorid";
    private static final String KEY_SCHEME_ENTRY = "schemeentry";
    private static final String KEY_SCHEME_ID = "schemeid";
    private static final String KEY_SCHEME_ENABLE = "schemeenable";
    private static final String KEY_SCHEME_PARAM = "schemeparam";
    private static final String ENTITY_TRACE_CONFIG = "bos_entitytraceconfig";
    private static final String SQL_READ_PK_REALTIME = "select top 1 fid from t_log_etconfig where frealtime = ? and fcreatorid = ? order by fcreatetime asc";
    private static final String SQL_READ_PK_BACKGROUND = "select top 1 fid from t_log_etconfig where frealtime = ? order by fcreatetime asc";
    private static final String ENTITY_TRACE_CONFIG_XML = "{\"BizAppNumber\":\"log\",\"InheritPath\":\"\",\"DBRouteKey\":\"log\",\"FlexProperty\":\"\",\"Properties\":[{\"_Type_\":\"LongProp\"},{\"_Type_\":\"EntryProp\",\"ItemType\":{\"_Type_\":\"EntryType\",\"Alias\":\"t_log_etconfigentry\",\"DBRouteKey\":\"log\",\"DisplayName\":{\"zh_CN\":\"\u76d1\u542c\u65b9\u6848\"},\"Properties\":[{\"_Type_\":\"LongProp\",\"Alias\":\"FEntryId\"},{\"_Type_\":\"IntegerProp\",\"Alias\":\"FSeq\",\"DisplayName\":{\"zh_CN\":\"\u5206\u5f55\u884c\u53f7\",\"zh_TW\":\"\u5206\u5f55\u884c\u53f7\",\"en_US\":\"Entry Line Number\"},\"Sys\":true,\"Name\":\"seq\"},{\"_Type_\":\"TextProp\",\"Alias\":\"fschemeid\",\"DisplayName\":{\"zh_CN\":\"\u76d1\u542c\u65b9\u6848\u6807\u8bc6\"},\"Features\":8411,\"MaxLenth\":50,\"Name\":\"schemeid\"},{\"_Type_\":\"TextProp\",\"DbIgnore\":true,\"DisplayName\":{\"zh_CN\":\"\u76d1\u542c\u65b9\u6848\"},\"Features\":8411,\"MaxLenth\":50,\"Name\":\"schemename\"},{\"_Type_\":\"TextProp\",\"DbIgnore\":true,\"DisplayName\":{\"zh_CN\":\"\u8bf4\u660e\"},\"Features\":8411,\"MaxLenth\":50,\"Name\":\"schemedesc\"},{\"DefValue\":false,\"_Type_\":\"BooleanProp\",\"Alias\":\"fschemeenable\",\"DisplayName\":{\"zh_CN\":\"\u542f\u7528\"},\"Features\":8411,\"Name\":\"schemeenable\"},{\"_Type_\":\"TextProp\",\"Alias\":\"fschemeparam\",\"DisplayName\":{\"zh_CN\":\"\u76d1\u542c\u53c2\u6570\"},\"Features\":8411,\"MaxLenth\":2000,\"Name\":\"schemeparam\"}],\"ExtendName\":\"schemeentry\",\"Name\":\"schemeentry\"},\"DefaultRows\":0,\"DisplayName\":{\"zh_CN\":\"\u76d1\u542c\u65b9\u6848\"},\"Name\":\"schemeentry\"},{\"_Type_\":\"BigIntProp\",\"Alias\":\"fcreatorid\",\"DisplayName\":{\"zh_CN\":\"\u521b\u5efa\u4eba\"},\"Features\":8409,\"Name\":\"creatorid\"},{\"_Type_\":\"CreateDateProp\",\"TimeZoneTransType\":1,\"Alias\":\"fcreatetime\",\"DisplayName\":{\"zh_CN\":\"\u521b\u5efa\u65f6\u95f4\"},\"UseRegion\":false,\"Features\":8409,\"Name\":\"createtime\"},{\"_Type_\":\"BigIntProp\",\"Alias\":\"fmodifierid\",\"DisplayName\":{\"zh_CN\":\"\u4fee\u6539\u4eba\"},\"Features\":8409,\"Name\":\"modifierid\"},{\"_Type_\":\"ModifyDateProp\",\"TimeZoneTransType\":1,\"Alias\":\"fmodifytime\",\"DisplayName\":{\"zh_CN\":\"\u4fee\u6539\u65e5\u671f\"},\"UseRegion\":false,\"Features\":8409,\"Name\":\"modifytime\"},{\"DefValue\":false,\"_Type_\":\"BooleanProp\",\"Alias\":\"frealtime\",\"DisplayName\":{\"zh_CN\":\"\u662f\u5426\u5b9e\u65f6\u76d1\u542c\"},\"Features\":8411,\"Name\":\"realtime\"}],\"Name\":\"bos_entitytraceconfig\",\"_Type_\":\"BasedataEntityType\",\"BillNo\":\"\",\"AppId\":\"bos\",\"Version\":\"1.1.634.1660012494599.2022-08-09 16:08:59:386\",\"NameProperty\":\"\",\"Alias\":\"t_log_etconfig\",\"DisplayName\":{\"zh_CN\":\"\u76d1\u63a7\u914d\u7f6e\"},\"ExtendName\":\"bos_entitytraceconfig\",\"BOSVer\":\"1.1.634\",\"NumberProperty\":\"\"}";
    private static MainEntityType entityTraceConfigType;
    private static QFilter[] realtimeFilters;
    private static QFilter[] backgroudFilters;

    private EntityTraceConfigReader() {
    }

    public static EntityTraceConfig loadConfigFromCache(boolean realtime) {
        Object[] pkids;
        DynamicObject configObj = null;
        if (realtime && (pkids = EntityTraceConfigReader.loadConfigPKFromCache(realtime)) != null && pkids.length > 0) {
            configObj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkids[0], (DynamicObjectType)EntityTraceConfigReader.getEntityTraceConfigType());
        }
        return EntityTraceConfigReader.convertObject(configObj, realtime);
    }

    private static Object[] loadConfigPKFromCache(boolean realtime) {
        QFilter[] filters;
        Object[] pks = null;
        MainEntityType type = EntityTraceConfigReader.getEntityTraceConfigType();
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        pks = cacheManager.getCachePks(filters = EntityTraceConfigReader.buildQFilter(realtime));
        if (pks == null) {
            try {
                ResultSetHandler<List<Long>> action = new ResultSetHandler<List<Long>>(){

                    public List<Long> handle(ResultSet rs) throws SQLException {
                        ArrayList<Long> ids = new ArrayList<Long>(1);
                        if (rs.next()) {
                            Long id = rs.getLong("fid");
                            ids.add(id);
                        }
                        return ids;
                    }
                };
                SqlBuilder sb = new SqlBuilder();
                if (realtime) {
                    sb.append(SQL_READ_PK_REALTIME, new Object[]{new SqlParameter(KEY_REALTIME, 16, (Object)realtime), new SqlParameter(KEY_CREATER, -5, (Object)RequestContext.get().getCurrUserId())});
                } else {
                    sb.append(SQL_READ_PK_BACKGROUND, new Object[]{new SqlParameter(KEY_REALTIME, 16, (Object)realtime)});
                }
                List idList = (List)DB.query((DBRoute)DBRoute.log, (SqlBuilder)sb, (ResultSetHandler)action);
                pks = idList.toArray();
                cacheManager.putCachePks(filters, pks);
            }
            catch (RuntimeException exp) {
                pks = new Object[]{};
            }
        }
        return pks;
    }

    private static QFilter[] buildQFilter(boolean realtime) {
        if (realtime) {
            if (realtimeFilters == null) {
                QFilter[] filters = new QFilter[]{new QFilter(KEY_REALTIME, "=", (Object)realtime), new QFilter(KEY_CREATER, "=", (Object)RequestContext.get().getCurrUserId())};
                realtimeFilters = filters;
            }
            return realtimeFilters;
        }
        if (backgroudFilters == null) {
            QFilter[] filters = new QFilter[]{new QFilter(KEY_REALTIME, "=", (Object)realtime)};
            backgroudFilters = filters;
        }
        return backgroudFilters;
    }

    public static DynamicObject loadBackGroundConfig() {
        QFilter realtimeFilter = new QFilter(KEY_REALTIME, "=", (Object)false);
        QFilter[] qFilters = new QFilter[]{realtimeFilter};
        return EntityTraceConfigReader.loadFromDb(qFilters);
    }

    public static DynamicObject loadRealtimeConfig() {
        QFilter realtimeFilter = new QFilter(KEY_REALTIME, "=", (Object)true);
        QFilter userFilter = new QFilter(KEY_CREATER, "=", (Object)RequestContext.get().getCurrUserId());
        QFilter[] qFilters = new QFilter[]{realtimeFilter, userFilter};
        return EntityTraceConfigReader.loadFromDb(qFilters);
    }

    private static DynamicObject loadFromDb(QFilter[] qfilters) {
        Long id = null;
        try (DataSet ds = ORM.create().queryDataSet("EntityTraceConfigReader.loadFromDb", ENTITY_TRACE_CONFIG, "id", qfilters, "createtime asc", 1);){
            if (ds.hasNext()) {
                Row row = ds.next();
                id = row.getLong("id");
            }
        }
        if (id == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_TRACE_CONFIG);
    }

    private static EntityTraceConfig convertObject(DynamicObject configObj, boolean realtime) {
        List<ListenScheme> listenSchemes = ListenSchemeLoader.load();
        HashMap<String, DynamicObject> configEntryRows = new HashMap<String, DynamicObject>(listenSchemes.size());
        if (configObj != null) {
            DynamicObjectCollection rows = configObj.getDynamicObjectCollection(KEY_SCHEME_ENTRY);
            for (DynamicObject row : rows) {
                String schemeId = row.getString(KEY_SCHEME_ID);
                if (!StringUtils.isNotBlank((CharSequence)schemeId)) continue;
                configEntryRows.put(schemeId, row);
            }
        }
        EntityTraceConfig config = new EntityTraceConfig();
        config.setRealtime(realtime);
        for (ListenScheme listenScheme : listenSchemes) {
            DynamicObject configRow = (DynamicObject)configEntryRows.get(listenScheme.getId());
            ListenSchemeParam schemeParam = EntityTraceConfigReader.createSchemeParam(listenScheme, configRow, realtime);
            config.addParam(schemeParam);
        }
        return config;
    }

    protected static ListenSchemeParam createSchemeParam(ListenScheme listenScheme, DynamicObject configRow, boolean realtime) {
        ListenSchemeParam param = new ListenSchemeParam();
        param.setId(listenScheme.getId());
        param.setName(listenScheme.getName().toString());
        if (configRow == null) {
            if (realtime) {
                param.setEnable(listenScheme.isDefSelected());
                return param;
            }
            if (listenScheme.isRealtime()) {
                param.setEnable(false);
                return param;
            }
            if (StringUtils.isNotEmpty((CharSequence)listenScheme.getListenerParamMcName())) {
                String listenerParam = listenScheme.getListenerParamByMC();
                if (StringUtils.isNotEmpty((CharSequence)listenerParam)) {
                    param.setParam(listenerParam);
                    param.setEnable(true);
                    return param;
                }
                param.setEnable(false);
                return param;
            }
            param.setEnable(listenScheme.isDefSelected());
            return param;
        }
        Boolean selected = configRow.getBoolean(KEY_SCHEME_ENABLE);
        param.setEnable(selected != null && selected != false);
        param.setParam(configRow.getString(KEY_SCHEME_PARAM));
        return param;
    }

    private static MainEntityType getEntityTraceConfigType() {
        if (entityTraceConfigType == null) {
            entityTraceConfigType = (MainEntityType)EntityItemTypes.fromJsonString((String)ENTITY_TRACE_CONFIG_XML);
        }
        return entityTraceConfigType;
    }
}

