/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.trace.EntityTraceConfig;
import kd.bos.dataentity.trace.EntityTraceListener;
import kd.bos.dataentity.trace.EntityTraceWriter;
import kd.bos.dataentity.trace.ListenSchemeParam;
import kd.bos.dataentity.trace.WriterManager;
import kd.bos.dataentity.trace.internal.EntityTraceInitializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.trace.cache.ConfigCacheReader;
import kd.bos.entity.trace.config.EntityTraceConfigReader;
import kd.bos.entity.trace.listener.DefaultTraceListener;
import kd.bos.entity.trace.scheme.ListenScheme;
import kd.bos.entity.trace.scheme.ListenSchemeLoader;
import kd.bos.entity.trace.writer.WriterFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class EntityTraceDbInitializer
implements EntityTraceInitializer {
    private static final Log LOG = LogFactory.getLog(EntityTraceDbInitializer.class);
    private static final String SYS_PARAM_ENTITY_TRACE_ENABLE = "bos.entitytrace.enable";
    private static final String TRUE_VALUE = "true";
    protected EntityTraceConfig config;
    protected Boolean loginOut = null;
    protected Boolean entityTraceEnabled = null;

    public EntityTraceConfig getConfig() {
        if (this.config == null) {
            this.config = this.loadConfig();
        }
        return this.config;
    }

    public List<EntityTraceListener> init() {
        if (!this.isEntityTraceEnabled() || this.isLoginOut()) {
            this.config = new EntityTraceConfig();
            return new ArrayList<EntityTraceListener>(0);
        }
        EntityTraceConfig entityTraceConfig = this.getConfig();
        List<EntityTraceListener> listeners = EntityTraceDbInitializer.createListeners(entityTraceConfig);
        if (!listeners.isEmpty()) {
            WriterManager writerManager = new WriterManager();
            List<EntityTraceWriter> writers = EntityTraceDbInitializer.createTraceWriters(entityTraceConfig);
            for (EntityTraceWriter writer : writers) {
                writerManager.addWriter(writer);
            }
            for (EntityTraceListener listener : listeners) {
                listener.setWriterManager(writerManager);
            }
        }
        return listeners;
    }

    private boolean isEntityTraceEnabled() {
        if (this.entityTraceEnabled == null) {
            String paramValue = System.getProperty(SYS_PARAM_ENTITY_TRACE_ENABLE, TRUE_VALUE);
            this.entityTraceEnabled = TRUE_VALUE.equals(paramValue);
        }
        return this.entityTraceEnabled;
    }

    private boolean isLoginOut() {
        if (this.loginOut != null) {
            return this.loginOut;
        }
        RequestContext ctx = RequestContext.get();
        if (ctx == null) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)ctx.getGlobalSessionId()) || StringUtils.isBlank((CharSequence)ctx.getAccountId()) || StringUtils.isBlank((CharSequence)ctx.getTenantId())) {
            return true;
        }
        this.loginOut = Long.compare(-1L, ctx.getCurrUserId()) == 0;
        return this.loginOut;
    }

    private EntityTraceConfig loadConfig() {
        boolean realtime = ConfigCacheReader.isRealtime();
        return EntityTraceConfigReader.loadConfigFromCache(realtime);
    }

    private static List<EntityTraceListener> createListeners(EntityTraceConfig config) {
        ArrayList<EntityTraceListener> listeners = new ArrayList<EntityTraceListener>(2 + config.getParams().size());
        HashSet<String> listenTypes = new HashSet<String>(10);
        for (Map.Entry entry : config.getParams().entrySet()) {
            ListenSchemeParam param = (ListenSchemeParam)entry.getValue();
            ListenScheme listenScheme = ListenSchemeLoader.get((String)entry.getKey());
            if (listenScheme == null) {
                LOG.info("scheme id [" + (String)entry.getKey() + "] is not exist.");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)listenScheme.getListenerClass())) {
                LOG.info("scheme [" + (String)entry.getKey() + "] class name is empty.");
                continue;
            }
            EntityTraceListener listener = EntityTraceDbInitializer.createListener(listenScheme.getListenerClass());
            if (listener == null) continue;
            if (param.isEnable()) {
                listener.setConfig(config);
                listener.setParam((ListenSchemeParam)entry.getValue());
                listeners.add(listener);
            }
            listenTypes.addAll(listener.getListenTypes());
        }
        if (listeners.isEmpty()) {
            return listeners;
        }
        EntityTraceListener formServiceListener = EntityTraceDbInitializer.createFormServiceListenter();
        if (formServiceListener != null) {
            formServiceListener.setConfig(config);
            listeners.add(formServiceListener);
            listenTypes.addAll(formServiceListener.getListenTypes());
        }
        DefaultTraceListener defListener = new DefaultTraceListener();
        defListener.setConfig(config);
        defListener.addSkipTypes(listenTypes);
        listeners.add(defListener);
        return listeners;
    }

    private static List<EntityTraceWriter> createTraceWriters(EntityTraceConfig config) {
        ArrayList<EntityTraceWriter> writers = new ArrayList<EntityTraceWriter>(2);
        EntityTraceWriter writeLog = WriterFactory.createLogWriter();
        writeLog.setConfig(config);
        writers.add(writeLog);
        EntityTraceWriter writerCache = WriterFactory.createCacheWriter();
        writerCache.setConfig(config);
        writers.add(writerCache);
        return writers;
    }

    private static EntityTraceListener createFormServiceListenter() {
        String serviceListenerClass = "kd.bos.entity.trace.listener.FormServiceListener";
        return EntityTraceDbInitializer.createListener(serviceListenerClass);
    }

    private static EntityTraceListener createListener(String className) {
        try {
            return (EntityTraceListener)TypesContainer.createInstance((String)className);
        }
        catch (Exception exp) {
            LOG.error((Throwable)exp);
            return null;
        }
    }
}

