/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.listener;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceConfig;
import kd.bos.dataentity.trace.EntityTraceListener;
import kd.bos.dataentity.trace.EntityTraceSpanInfo;
import kd.bos.dataentity.trace.EntityTraceWriter;
import kd.bos.dataentity.trace.ListenSchemeParam;
import kd.bos.dataentity.trace.WriterManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.trace.listener.param.CallStockListenParam;

public class CallStockListener
implements EntityTraceListener {
    private EntityTraceConfig config;
    private WriterManager writerManager;
    private CallStockListenParam callStockParam = new CallStockListenParam();
    private SpanNode spanNode;
    private static final String BOS_ENTITY_TRACE = "bos-entity-trace";

    public void setConfig(EntityTraceConfig config) {
        this.config = config;
    }

    public void setParam(ListenSchemeParam param) {
        String paramStr = param.getParam();
        if (StringUtils.isNotBlank((CharSequence)paramStr)) {
            this.callStockParam = (CallStockListenParam)SerializationUtils.fromJsonString((String)paramStr, CallStockListenParam.class);
        }
    }

    public void setWriterManager(WriterManager writerManager) {
        this.writerManager = writerManager;
    }

    public Set<String> getListenTypes() {
        return new HashSet<String>(0);
    }

    public void create(EntityTraceSpanInfo span) {
        if (this.config.isSkipFormService()) {
            return;
        }
        this.spanNode = new SpanNode(span.getType(), span.getName(), this.spanNode);
    }

    public void event(EntityTraceSpanInfo span, String event) {
    }

    public void close(EntityTraceSpanInfo span) {
        if (this.spanNode == null) {
            return;
        }
        SpanNode currNode = this.spanNode;
        this.spanNode = currNode.getParent();
        currNode.setCost(span.getCost());
        if (this.isPrint(currNode)) {
            this.print(span, currNode);
            return;
        }
        if (span.isRootSpan()) {
            if (StringUtils.isBlank((CharSequence)this.callStockParam.getListenType()) && currNode.getCost() > (long)this.callStockParam.getWriteReportCost()) {
                this.print(span, currNode);
            }
        } else if (currNode.getCost() > (long)this.callStockParam.getMixSpanCost()) {
            if (currNode.getCost() > (long)this.callStockParam.getWriteTagCost()) {
                currNode.setOvertime(true);
                currNode.setTags(span.getTags());
            }
            if (currNode.getParent() != null) {
                currNode.getParent().addSpanNode(currNode);
            }
        }
    }

    private boolean isPrint(SpanNode spanNode) {
        if (StringUtils.isBlank((CharSequence)this.callStockParam.getListenType()) || !this.isListenSpan(spanNode)) {
            return false;
        }
        int count = 0;
        for (SpanNode parentNode = spanNode.getParent(); parentNode != null && count < 20; parentNode = parentNode.getParent(), ++count) {
            if (!this.isListenSpan(parentNode)) continue;
            return false;
        }
        return true;
    }

    private boolean isListenSpan(SpanNode spanNode) {
        return StringUtils.equals((CharSequence)spanNode.getType(), (CharSequence)this.callStockParam.getListenType()) && (StringUtils.isBlank((CharSequence)this.callStockParam.getListenName()) || StringUtils.equals((CharSequence)spanNode.getName(), (CharSequence)this.callStockParam.getListenName()));
    }

    private void print(EntityTraceSpanInfo span, SpanNode spanNode) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(ResManager.loadKDString((String)"\u4ee3\u7801\u8c03\u7528\u6027\u80fd\u6d88\u8017\u62a5\u544a\uff1a\r\n", (String)"CallStockListener_0", (String)BOS_ENTITY_TRACE, (Object[])new Object[0]));
        spanNode.setParent(null);
        spanNode.setOvertime(true);
        spanNode.setTags(span.getTags());
        spanNode.print(sBuilder);
        this.writerManager.write(span, sBuilder.toString(), EntityTraceWriter.InfoLevel.INFO);
    }

    public static class SpanNode {
        private static final int MAX_CHILD_COUNT = 10;
        private static final int MERGE_CHILD_COUNT = 5;
        private static final int MAX_TAG_STR_LENGTH = 50;
        private static final int MAX_REPORT_LENGTH = 50000;
        private static final String NEW_LINE = "\r\n";
        private String type;
        private String name;
        private Map<String, String> tags;
        private String tagString;
        private int count = 1;
        private long cost;
        private boolean writeTags = false;
        private SpanNode parent;
        private Map<String, SpanNode> childs = new LinkedHashMap<String, SpanNode>(4);

        public SpanNode(String type, String name, SpanNode parent) {
            this.type = type;
            this.name = name;
            this.parent = parent;
        }

        public String getKey() {
            return this.type + "." + this.name;
        }

        public int getLevel() {
            if (this.parent == null) {
                return 1;
            }
            return this.getParent().getLevel() + 1;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public void setTags(Map<String, String> tags) {
            this.tags = tags;
        }

        public String getTagString() {
            if (this.tagString != null) {
                return this.tagString;
            }
            if (this.getTags() == null || this.getTags().isEmpty()) {
                this.tagString = "";
            } else {
                StringBuilder sbTag = new StringBuilder();
                for (Map.Entry<String, String> entry : this.getTags().entrySet()) {
                    if (entry.getValue() != null && entry.getValue().length() > 50) {
                        sbTag.append("'").append(entry.getValue().substring(0, 47)).append("...',");
                        continue;
                    }
                    sbTag.append("'").append(entry.getValue()).append("',");
                }
                sbTag.setLength(sbTag.length() - 1);
                this.tagString = sbTag.toString();
            }
            return this.tagString;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public long getCost() {
            return this.cost;
        }

        public void setCost(long cost) {
            this.cost = cost;
        }

        public boolean isOvertime() {
            return this.writeTags;
        }

        public void setOvertime(boolean overtime) {
            this.writeTags = overtime;
        }

        public SpanNode getParent() {
            return this.parent;
        }

        public void setParent(SpanNode parent) {
            this.parent = parent;
        }

        public Map<String, SpanNode> getChilds() {
            return this.childs;
        }

        public void addSpanNode(SpanNode spanNode) {
            String key = spanNode.getKey() + "(" + spanNode.getTagString() + ")";
            SpanNode localNode = this.childs.get(key);
            if (localNode != null) {
                localNode.merge(spanNode);
                return;
            }
            if (this.childs.size() < 5 && spanNode.isOvertime()) {
                this.childs.put(key, spanNode);
                return;
            }
            key = spanNode.getKey();
            localNode = this.childs.get(key);
            if (localNode != null) {
                localNode.merge(spanNode);
                return;
            }
            if (this.childs.size() < 10) {
                this.childs.put(key, spanNode);
                return;
            }
        }

        public void merge(SpanNode other) {
            this.setCount(this.getCount() + other.getCount());
            this.setCost(this.getCost() + other.getCost());
            for (SpanNode child : other.getChilds().values()) {
                this.addSpanNode(child);
            }
            if (other.isOvertime()) {
                this.setOvertime(true);
                this.setTags(other.getTags());
            }
        }

        public void print(StringBuilder sb) {
            int level = this.getLevel();
            for (int i = 2; i < level; ++i) {
                sb.append("    ");
            }
            if (level > 1) {
                sb.append("|----");
            }
            sb.append(this.getType()).append(".").append(this.getName()).append("(");
            if (this.isOvertime()) {
                sb.append(this.getTagString());
            }
            sb.append("), ");
            if (this.getCount() > 1) {
                sb.append("run ").append(this.getCount()).append(" times, cost ").append(this.getCost()).append(" ms.");
            } else {
                sb.append("cost ").append(this.getCost()).append(" ms.");
            }
            sb.append(NEW_LINE);
            if (sb.length() > 50000) {
                return;
            }
            for (Map.Entry<String, SpanNode> entry : this.getChilds().entrySet()) {
                entry.getValue().print(sb);
                if (sb.length() <= 50000) continue;
                return;
            }
        }

        public SpanNode find(String listenType, String listenName) {
            if (StringUtils.equals((CharSequence)this.getType(), (CharSequence)listenType) && StringUtils.equals((CharSequence)this.getName(), (CharSequence)listenName)) {
                return this;
            }
            for (Map.Entry<String, SpanNode> child : this.getChilds().entrySet()) {
                SpanNode findNode = child.getValue().find(listenType, listenName);
                if (findNode == null) continue;
                return findNode;
            }
            return null;
        }
    }
}

