/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.listener;

import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.trace.EntityTraceSpanInfo;
import kd.bos.entity.trace.listener.AbstractEntityTraceListener;

public class FormServiceListener
extends AbstractEntityTraceListener {
    private static final Set<String> TYPES = new HashSet<String>(1);
    private static final Set<String> SKIP_ENTITY_NUMBERS = new HashSet<String>(1);
    private Long skipSpanId = null;

    public Set<String> getListenTypes() {
        return TYPES;
    }

    public void create(EntityTraceSpanInfo span) {
        String queryString;
        if (this.skipSpanId == null && this.getListenTypes().contains(span.getType()) && (queryString = RequestContext.get().getQueryString()) != null) {
            for (String entityNUmber : SKIP_ENTITY_NUMBERS) {
                if (queryString.indexOf(entityNUmber) <= -1) continue;
                this.getConfig().setSkipFormService(true);
                this.skipSpanId = span.getId();
                break;
            }
        }
    }

    @Override
    protected void doEvent(EntityTraceSpanInfo span, String event) {
    }

    @Override
    protected void doClose(EntityTraceSpanInfo span) {
        if (this.skipSpanId != null && Long.compare(this.skipSpanId, span.getId()) == 0) {
            this.skipSpanId = null;
            this.getConfig().setSkipFormService(false);
        }
    }

    static {
        TYPES.add("FormService");
        SKIP_ENTITY_NUMBERS.add("bos_entitytraceview");
    }
}

