/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.listener;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceConfig;
import kd.bos.dataentity.trace.EntityTraceListener;
import kd.bos.dataentity.trace.EntityTraceSpanInfo;
import kd.bos.dataentity.trace.EntityTraceWriter;
import kd.bos.dataentity.trace.ListenSchemeParam;
import kd.bos.dataentity.trace.WriterManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.trace.tagval.TagValue;

public class KDErrorListener
implements EntityTraceListener {
    private static final Set<String> TYPES = new HashSet<String>(1);
    private static final String SPAN_TYPE_FORMSERVICE = "FormService";
    private static final int MAX_SPAN_LEVEL = 50;
    private static final int MAX_TAG_LENGTH = 5000;
    private static final String BOS_ENTITY_TRACE = "bos-entity-trace";
    private WriterManager writerManager;
    private SpanNode errorSpanNode;

    public void setWriterManager(WriterManager writerManager) {
        this.writerManager = writerManager;
    }

    public void setConfig(EntityTraceConfig config) {
    }

    public void setParam(ListenSchemeParam param) {
    }

    public Set<String> getListenTypes() {
        return TYPES;
    }

    public void event(EntityTraceSpanInfo span, String event) {
    }

    public void throwException(EntityTraceSpanInfo span, String msg, Throwable e) {
        if (this.errorSpanNode == null) {
            this.createErrorSpan(span, msg, e);
        } else {
            SpanNode parentNode = this.errorSpanNode.find(span.getId());
            if (parentNode != null) {
                parentNode.setTags(span.getTags());
                parentNode.setLocaleTags(span.getLocaleTags());
            } else {
                this.createErrorSpan(span, msg, e);
            }
        }
    }

    public void ignoreException(EntityTraceSpanInfo span) {
        this.errorSpanNode = null;
    }

    public void error(EntityTraceSpanInfo span, String msg, Throwable e) {
        if (this.errorSpanNode == null) {
            this.createErrorSpan(span, msg, e);
        } else {
            SpanNode parentNode = this.errorSpanNode.find(span.getId());
            if (parentNode != null) {
                parentNode.setTags(span.getTags());
                parentNode.setLocaleTags(span.getLocaleTags());
            } else {
                this.createErrorSpan(span, msg, e);
            }
        }
        this.printErrorSpan(span);
    }

    public void close(EntityTraceSpanInfo span) {
        if (this.errorSpanNode == null) {
            return;
        }
        SpanNode parentNode = this.errorSpanNode.find(span.getId());
        if (parentNode != null) {
            parentNode.setTags(span.getTags());
            parentNode.setLocaleTags(span.getLocaleTags());
        }
    }

    private void createErrorSpan(EntityTraceSpanInfo span, String msg, Throwable e) {
        this.errorSpanNode = SpanNode.create(span);
        this.errorSpanNode.setErrMsg(msg);
        this.errorSpanNode.setException(e);
    }

    private void printErrorSpan(EntityTraceSpanInfo span) {
        Throwable e;
        if (this.errorSpanNode == null || this.errorSpanNode.isPrint()) {
            return;
        }
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(ResManager.loadKDString((String)"\u5b9e\u4f53\u8fd0\u884c\u76d1\u63a7\u6846\u67b6\uff0c\u76d1\u542c\u5230\u5f02\u5e38\u4e8b\u4ef6\uff0c\u5f02\u5e38\u4e0a\u4e0b\u6587\u4fe1\u606f\uff1a", (String)"KDErrorListener_0", (String)BOS_ENTITY_TRACE, (Object[])new Object[0]));
        String errMsg = this.errorSpanNode.getErrMsg();
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            sBuilder.append(System.lineSeparator()).append(errMsg);
        }
        if ((e = this.errorSpanNode.getException()) != null) {
            sBuilder.append(System.lineSeparator()).append(e.getClass().getName());
            if (StringUtils.isNotBlank((CharSequence)e.getMessage())) {
                sBuilder.append(": ").append(e.getMessage());
            }
        }
        int callLevel = 0;
        for (SpanNode spanNode = this.errorSpanNode; spanNode != null && callLevel < 50; spanNode = spanNode.getParent(), ++callLevel) {
            this.joinSpanInfo(spanNode, sBuilder);
        }
        this.writerManager.write(span, sBuilder.toString(), EntityTraceWriter.InfoLevel.IMPORTANT);
        this.errorSpanNode.setPrint(true);
    }

    private void joinSpanInfo(SpanNode span, StringBuilder sBuilder) {
        sBuilder.append(System.lineSeparator()).append("at ");
        sBuilder.append(span.getType()).append(".").append(span.getName()).append("()");
        for (Map.Entry<String, String> entry : span.getTags().entrySet()) {
            sBuilder.append(System.lineSeparator()).append("    ");
            sBuilder.append(entry.getKey()).append(": \"");
            sBuilder.append(TagValue.convToString(entry.getValue()));
            sBuilder.append("\" ");
        }
        for (Map.Entry<String, Object> entry : span.getLocaleTags().entrySet()) {
            sBuilder.append(System.lineSeparator()).append("    ");
            sBuilder.append(entry.getKey()).append(": \"");
            sBuilder.append(TagValue.convToString(entry.getValue(), 5000));
            sBuilder.append("\" ");
        }
    }

    static {
        TYPES.add(SPAN_TYPE_FORMSERVICE);
    }

    public static class SpanNode {
        private SpanNode parent;
        private long spanId;
        private String type;
        private String name;
        private Map<String, String> tags;
        private Map<String, Object> localeTags;
        private String errMsg;
        private Throwable exception;
        private boolean print;

        public static SpanNode create(EntityTraceSpanInfo span) {
            SpanNode spanNode = new SpanNode(span.getId(), span.getType(), span.getName(), span.getTags(), span.getLocaleTags());
            HashSet<Long> spanIds = new HashSet<Long>(16);
            spanIds.add(span.getId());
            SpanNode parentNode = spanNode;
            for (EntityTraceSpanInfo parentSpan = span.getParent(); parentSpan != null && spanIds.add(parentSpan.getId()); parentSpan = parentSpan.getParent()) {
                SpanNode tempNode = new SpanNode(parentSpan.getId(), parentSpan.getType(), parentSpan.getName(), parentSpan.getTags(), parentSpan.getLocaleTags());
                parentNode.setParent(tempNode);
                parentNode = tempNode;
            }
            return spanNode;
        }

        public SpanNode(long spanId, String type, String name, Map<String, String> tags, Map<String, Object> localeTags) {
            this.spanId = spanId;
            this.type = type;
            this.name = name;
            this.tags = tags;
            this.localeTags = localeTags;
        }

        public SpanNode getParent() {
            return this.parent;
        }

        public void setParent(SpanNode parent) {
            this.parent = parent;
        }

        public long getSpanId() {
            return this.spanId;
        }

        public void setSpanId(long spanId) {
            this.spanId = spanId;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public void setTags(Map<String, String> tags) {
            this.tags = tags;
        }

        public Map<String, Object> getLocaleTags() {
            return this.localeTags;
        }

        public void setLocaleTags(Map<String, Object> localeTags) {
            this.localeTags = localeTags;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }

        public Throwable getException() {
            return this.exception;
        }

        public void setException(Throwable exception) {
            this.exception = exception;
        }

        public boolean isPrint() {
            return this.print;
        }

        public void setPrint(boolean print) {
            this.print = print;
        }

        public SpanNode find(long spanId) {
            if (Long.compare(this.spanId, spanId) == 0) {
                return this;
            }
            if (this.parent == null) {
                return null;
            }
            return this.parent.find(spanId);
        }
    }
}

