/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.listener;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceConfig;
import kd.bos.dataentity.trace.EntityTraceListener;
import kd.bos.dataentity.trace.EntityTraceSpanInfo;
import kd.bos.dataentity.trace.EntityTraceWriter;
import kd.bos.dataentity.trace.ListenSchemeParam;
import kd.bos.dataentity.trace.WriterManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.trace.listener.param.MethodListenParam;
import kd.bos.entity.trace.tagval.TagValue;

public class MethodListener
implements EntityTraceListener {
    private EntityTraceConfig config;
    private WriterManager writerManager;
    private MethodListenParam methodRunParam = new MethodListenParam();

    public void setConfig(EntityTraceConfig config) {
        this.config = config;
    }

    public void setParam(ListenSchemeParam param) {
        String paramStr = param.getParam();
        if (StringUtils.isNotBlank((CharSequence)paramStr)) {
            this.methodRunParam = (MethodListenParam)SerializationUtils.fromJsonString((String)paramStr, MethodListenParam.class);
        }
    }

    public void setWriterManager(WriterManager writerManager) {
        this.writerManager = writerManager;
    }

    public Set<String> getListenTypes() {
        return new HashSet<String>(0);
    }

    public void create(EntityTraceSpanInfo span) {
    }

    public void event(EntityTraceSpanInfo span, String event) {
    }

    public void close(EntityTraceSpanInfo span) {
        if (this.config.isSkipFormService() || !this.methodRunParam.isListenMothed(span.getType(), span.getName())) {
            return;
        }
        this.print(span);
    }

    private void print(EntityTraceSpanInfo span) {
        StringBuilder sBuilder = new StringBuilder();
        for (Map.Entry entry : span.getTags().entrySet()) {
            sBuilder.append((String)entry.getKey()).append(": ");
            sBuilder.append(TagValue.convToString(entry.getValue(), this.methodRunParam.getMaxLengthTag()));
            sBuilder.append(" ").append(System.lineSeparator());
        }
        for (Map.Entry entry : span.getLocaleTags().entrySet()) {
            if (sBuilder.length() >= this.methodRunParam.getMaxLenghtReport()) continue;
            sBuilder.append((String)entry.getKey()).append(": ");
            sBuilder.append(TagValue.convToString(entry.getValue(), this.methodRunParam.getMaxLengthTag()));
            sBuilder.append(" ").append(System.lineSeparator());
        }
        boolean printStock = this.config.isPrintStackTrace();
        this.config.setPrintStackTrace(true);
        this.writerManager.write(span, sBuilder.toString(), EntityTraceWriter.InfoLevel.INFO);
        this.config.setPrintStackTrace(printStock);
    }
}

