/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.plugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.trace.listener.param.CallStockListenParam;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class CallStockListenPlugin
extends AbstractFormPlugin {
    private static final String KEY_MIX_COST = "mixspancost";
    private static final String KEY_WRITE_TAG = "writetagcost";
    private static final String KEY_WRITE_REPORT = "writereportcost";
    private static final String KEY_TYPE = "listentype";
    private static final String KEY_NAME = "listenname";
    private static final String KEY_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOK = (Button)this.getView().getControl(KEY_OK);
        if (btnOK != null) {
            btnOK.addClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.showParam();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_OK, (CharSequence)source.getKey())) {
            this.returnParam();
            this.getView().close();
        }
    }

    private void showParam() {
        CallStockListenParam param = this.getParam();
        this.getModel().setValue(KEY_MIX_COST, (Object)param.getMixSpanCost());
        this.getModel().setValue(KEY_WRITE_TAG, (Object)param.getWriteTagCost());
        this.getModel().setValue(KEY_WRITE_REPORT, (Object)param.getWriteReportCost());
        this.getModel().setValue(KEY_TYPE, (Object)param.getListenType());
        this.getModel().setValue(KEY_NAME, (Object)param.getListenName());
    }

    private boolean returnParam() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        CallStockListenParam param = new CallStockListenParam();
        param.setMixSpanCost(obj.getInt(KEY_MIX_COST));
        param.setWriteTagCost(obj.getInt(KEY_WRITE_TAG));
        param.setWriteReportCost(obj.getInt(KEY_WRITE_REPORT));
        param.setListenType(obj.getString(KEY_TYPE));
        param.setListenName(obj.getString(KEY_NAME));
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)param));
        return true;
    }

    private CallStockListenParam getParam() {
        String paramValue = (String)this.getView().getFormShowParameter().getCustomParam("schemeparam");
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            return new CallStockListenParam();
        }
        return (CallStockListenParam)SerializationUtils.fromJsonString((String)paramValue, CallStockListenParam.class);
    }
}

