/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.plugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.trace.listener.param.entryrow.EntryRowChangeListenEntity;
import kd.bos.entity.trace.listener.param.entryrow.EntryRowChangeParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class EntryRowChangePlugin
extends AbstractFormPlugin {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_ENTITY = "entity";
    private static final String KEY_ENTRYKEY = "entrykey";
    private static final String KEY_ENTRYOP = "entryop";
    private static final String KEY_OK = "btnok";

    public void registerListener(EventObject e) {
        TextEdit fieldEdit;
        super.registerListener(e);
        Button btnOK = (Button)this.getView().getControl(KEY_OK);
        if (btnOK != null) {
            btnOK.addClickListener((ClickListener)this);
        }
        if ((fieldEdit = (TextEdit)this.getView().getControl(KEY_ENTRYKEY)) != null) {
            fieldEdit.addButtonClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.showParam();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_OK, (CharSequence)source.getKey())) {
            this.returnParam();
            this.getView().close();
        } else if (StringUtils.equals((CharSequence)KEY_ENTRYKEY, (CharSequence)source.getKey())) {
            this.showForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)KEY_ENTRYKEY) && closedCallBackEvent.getReturnData() != null) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            this.getModel().setValue(KEY_ENTRYKEY, closedCallBackEvent.getReturnData(), rowIndex);
        }
    }

    private void showForm() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject entityObj = (DynamicObject)this.getModel().getValue(KEY_ENTITY, rowIndex);
        if (entityObj == null) {
            return;
        }
        String entityNumber = (String)entityObj.getPkValue();
        String selectFields = (String)this.getModel().getValue(KEY_ENTRYKEY, rowIndex);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_multientryselect");
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("selectedentrys", selectFields);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_ENTRYKEY));
        this.getView().showForm(showParameter);
    }

    private void showParam() {
        EntryRowChangeParam param = this.getParam();
        if (!param.getListenEntities().isEmpty()) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, param.getListenEntities().size());
            for (int i = 0; i < param.getListenEntities().size(); ++i) {
                EntryRowChangeListenEntity listenEntity = param.getListenEntities().get(i);
                this.getModel().setValue(KEY_ENTITY, (Object)listenEntity.getEntityNumber(), i);
                this.getModel().setValue(KEY_ENTRYKEY, (Object)StringUtils.join((Object[])listenEntity.getEntryKeys().toArray(), (String)","), i);
                this.getModel().setValue(KEY_ENTRYOP, (Object)StringUtils.join((Object[])listenEntity.getEntryOps().toArray(), (String)","), i);
            }
        }
    }

    private boolean returnParam() {
        EntryRowChangeParam param = new EntryRowChangeParam();
        DynamicObject obj = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = obj.getDynamicObjectCollection(KEY_ENTRYENTITY);
        for (DynamicObject row : rows) {
            DynamicObject entityObj = row.getDynamicObject(KEY_ENTITY);
            if (entityObj == null) continue;
            String entityNumber = (String)entityObj.getPkValue();
            String entryKeys = row.getString(KEY_ENTRYKEY);
            String entryOps = row.getString(KEY_ENTRYOP);
            param.addListenEntity(entityNumber, entryKeys, entryOps);
        }
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)param));
        return true;
    }

    private EntryRowChangeParam getParam() {
        String paramValue = (String)this.getView().getFormShowParameter().getCustomParam("schemeparam");
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            return new EntryRowChangeParam();
        }
        return (EntryRowChangeParam)SerializationUtils.fromJsonString((String)paramValue, EntryRowChangeParam.class);
    }
}

