/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.plugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.KDDateUtils;

public class FocusInfoPlugin
extends AbstractFormPlugin {
    public static final String CUST_PARAM_SELECTROW = "selectrow";
    public static final String FORMID_ENTITY_TRACE_VIEW = "bos_entitytraceview";
    public static final String FORMID_ENTITY_FOCUS = "bos_entitytracefocus";
    private static final String KEY_FOCUS = "tbnfocus";
    private static final String KEY_EXPAND = "tbnexpand";
    private static final String KEY_COLLAPSE = "tbncollapse";
    private static final String KEY_ENTRY = "entryentity";
    private static final String KEY_SEQ = "seq";
    private static final String KEY_SOURCE_SEQ = "sourceseq";
    private IFormView parentView = null;

    public void afterCreateNewData(EventObject e) {
        Object paramValue = this.getView().getFormShowParameter().getCustomParams().get(CUST_PARAM_SELECTROW);
        if (paramValue == null) {
            return;
        }
        int rowIndex = Integer.parseInt(paramValue.toString());
        IFormView parentView = this.getParentView();
        if (parentView == null) {
            return;
        }
        this.copyFromParent(parentView, rowIndex);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.doExpand();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmain");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "tbnexpand": {
                this.doExpand();
                break;
            }
            case "tbncollapse": {
                this.doCollapse();
                break;
            }
            case "tbnfocus": {
                this.doFocusInfo();
                break;
            }
        }
    }

    private void doExpand() {
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_ENTRY);
        grid.setCollapse(false);
    }

    private void doCollapse() {
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_ENTRY);
        grid.setCollapse(true);
    }

    private void doFocusInfo() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
        IFormView parentView = this.getParentView();
        if (parentView == null) {
            return;
        }
        int sourceRowSeq = (Integer)this.getModel().getValue(KEY_SOURCE_SEQ, rowIndex);
        this.getModel().beginInit();
        this.copyFromParent(parentView, sourceRowSeq - 1);
        this.getModel().endInit();
        this.getView().updateView(KEY_ENTRY);
        this.doExpand();
    }

    private void copyFromParent(IFormView parentView, int focusRow) {
        DynamicObject currObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection currRows = currObj.getDynamicObjectCollection(KEY_ENTRY);
        currRows.clear();
        IDataModel parentDataModel = parentView.getModel();
        DynamicObject obj = parentDataModel.getDataEntity(true);
        DynamicObjectCollection parentRows = obj.getDynamicObjectCollection(KEY_ENTRY);
        if (parentRows.size() <= focusRow) {
            return;
        }
        List<DynamicObject> parentSelectRows = this.searchParentSelectRows(parentRows, focusRow);
        int seq = 1;
        for (DynamicObject parentRow : parentSelectRows) {
            DynamicObject row = new DynamicObject(currRows.getDynamicObjectType());
            row.set(KEY_SEQ, (Object)seq);
            row.set(KEY_SOURCE_SEQ, parentRow.get(KEY_SEQ));
            this.copyRow(parentRow, row);
            currRows.add((Object)row);
            ++seq;
        }
    }

    protected List<DynamicObject> searchParentSelectRows(DynamicObjectCollection parentRows, int focusRow) {
        DynamicObject parentRow;
        Long downPId;
        DynamicObject parentFocusRow = (DynamicObject)parentRows.get(focusRow);
        Long parentFocusId = parentFocusRow.getLong("id");
        ArrayList<DynamicObject> parentSelectRows = new ArrayList<DynamicObject>(32);
        parentSelectRows.add(parentFocusRow);
        Long pid = parentFocusRow.getLong("pid");
        HashSet<Long> upPids = new HashSet<Long>(8);
        upPids.add(pid);
        if (Long.compare(0L, pid) != 0) {
            for (int rowIndex = focusRow - 1; rowIndex >= 0; --rowIndex) {
                DynamicObject parentRow2 = (DynamicObject)parentRows.get(rowIndex);
                if (Long.compare(pid, parentRow2.getLong("id")) != 0) continue;
                pid = parentRow2.getLong("pid");
                parentSelectRows.add(parentRow2);
                upPids.add(pid);
                if (Long.compare(0L, pid) == 0) break;
            }
        }
        Collections.reverse(parentSelectRows);
        HashSet<Long> downPIds = new HashSet<Long>();
        downPIds.add(parentFocusId);
        for (int rowIndex = focusRow + 1; rowIndex < parentRows.size() && !upPids.contains(downPId = Long.valueOf((parentRow = (DynamicObject)parentRows.get(rowIndex)).getLong("pid"))); ++rowIndex) {
            if (!downPIds.contains(downPId)) continue;
            parentSelectRows.add(parentRow);
            downPIds.add(parentRow.getLong("id"));
        }
        return parentSelectRows;
    }

    protected void copyRow(DynamicObject parentRow, DynamicObject row) {
        row.set("id", parentRow.get("id"));
        row.set("pid", parentRow.get("pid"));
        row.set("createtime", parentRow.get("createtime"));
        try {
            Object date = parentRow.get("createtime");
            if (date instanceof String) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dateFormat.setTimeZone(KDDateUtils.getUserTimeZone());
                Date createtime = dateFormat.parse((String)date);
                row.set("createtime1", (Object)createtime);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        row.set("level", parentRow.get("level"));
        row.set("type", parentRow.get("type"));
        row.set("message", parentRow.get("message"));
        row.set("trace", parentRow.get("trace"));
        row.set("cost", parentRow.get("cost"));
    }

    private IFormView getParentView() {
        if (this.parentView != null) {
            return this.parentView;
        }
        String parentViewPageId = this.getView().getFormShowParameter().getParentPageId();
        if (StringUtils.isBlank((CharSequence)parentViewPageId)) {
            return null;
        }
        this.parentView = this.getView().getViewNoPlugin(parentViewPageId);
        if (!StringUtils.equalsIgnoreCase((CharSequence)FORMID_ENTITY_TRACE_VIEW, (CharSequence)this.parentView.getFormShowParameter().getFormId())) {
            this.parentView = null;
        }
        return this.parentView;
    }
}

