/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.scheme;

import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceListener;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.trace.config.EntityTraceDbInitializer;
import kd.bos.entity.trace.listener.IListenerParamCheck;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ListenScheme {
    private static final Log log = LogFactory.getLog(EntityTraceDbInitializer.class);
    private static final String ENABLE = "enable";
    private static final String PARAM = "param";
    private String id;
    private LocaleString name;
    private LocaleString desc;
    private String name_LangResId;
    private String desc_LangResId;
    private String listenerClass;
    private String settingFormId;
    private boolean realtime;
    private boolean defSelected;
    private int seq;
    private String listenerParamMcName;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LocaleString getName() {
        return this.name;
    }

    public void setName(LocaleString name) {
        this.name = name;
    }

    public String getName_LangResId() {
        return this.name_LangResId;
    }

    public void setName_LangResId(String name_LangResId) {
        this.name_LangResId = name_LangResId;
    }

    public LocaleString getDesc() {
        return this.desc;
    }

    public void setDesc(LocaleString desc) {
        this.desc = desc;
    }

    public String getDesc_LangResId() {
        return this.desc_LangResId;
    }

    public void setDesc_LangResId(String desc_LangResId) {
        this.desc_LangResId = desc_LangResId;
    }

    public String getListenerClass() {
        return this.listenerClass;
    }

    public void setListenerClass(String listenerClass) {
        this.listenerClass = listenerClass;
    }

    public String getSettingFormId() {
        return this.settingFormId;
    }

    public void setSettingFormId(String settingFormId) {
        this.settingFormId = settingFormId;
    }

    public boolean isRealtime() {
        return this.realtime;
    }

    public void setRealtime(boolean realtime) {
        this.realtime = realtime;
    }

    public boolean isDefSelected() {
        return this.defSelected;
    }

    public void setDefSelected(boolean defSelected) {
        this.defSelected = defSelected;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public String getListenerParamMcName() {
        return this.listenerParamMcName;
    }

    public void setListenerParamMcName(String listenerParamMcName) {
        this.listenerParamMcName = listenerParamMcName;
    }

    public String getListenerParamByMC() {
        if (StringUtils.isEmpty((CharSequence)this.listenerParamMcName)) {
            return null;
        }
        String listenerParam = System.getProperty(this.listenerParamMcName);
        if (StringUtils.isEmpty((CharSequence)listenerParam)) {
            return null;
        }
        EntityTraceListener listener = this.createListener(this.listenerClass);
        if (listener == null) {
            return null;
        }
        if (listener instanceof IListenerParamCheck) {
            try {
                boolean enable;
                Map paramMap = (Map)SerializationUtils.fromJsonString((String)listenerParam, Map.class);
                boolean bl = enable = paramMap.get(ENABLE) == null ? false : (Boolean)paramMap.get(ENABLE);
                if (!enable || paramMap.get(PARAM) == null) {
                    return null;
                }
                String paramStr = SerializationUtils.toJsonString(paramMap.get(PARAM));
                if (StringUtils.isBlank((CharSequence)paramStr)) {
                    return null;
                }
                boolean checkResult = ((IListenerParamCheck)listener).checkListenerParamValid(paramStr);
                if (checkResult) {
                    return paramStr;
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        return null;
    }

    private EntityTraceListener createListener(String className) {
        try {
            return (EntityTraceListener)TypesContainer.createInstance((String)className);
        }
        catch (Exception exp) {
            log.error((Throwable)exp);
            return null;
        }
    }
}

