/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.tagval;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.trace.tagval.ArrayToString;
import kd.bos.entity.trace.tagval.DynamicObjectToString;
import kd.bos.entity.trace.tagval.EntityPropertyToString;
import kd.bos.entity.trace.tagval.EntityTypeToString;
import kd.bos.entity.trace.tagval.ListToString;
import kd.bos.entity.trace.tagval.MapToString;
import kd.bos.entity.trace.tagval.ObjectToString;
import kd.bos.entity.trace.tagval.StringToString;
import kd.bos.entity.trace.tagval.TagToString;
import kd.bos.entity.trace.tagval.ToStringOption;

public final class TagValue {
    private static final String CLASS_DYNAMICOBJECT = "DynamicObject";
    private static final String CLASS_DATAENTITYTYPE = "IDataEntityType";
    private static final String CLASS_DATAENTITYPROPERTY = "IDataEntityProperty";
    private static final String CLASS_ARRAY = "Array";
    private static final String CLASS_STRING = "String";
    private static final String CLASS_Map = "Map";
    private static final String CLASS_LIST = "List";
    private static Map<String, TagToString> toStrTools = new HashMap<String, TagToString>(8);
    private static TagToString otherToString = new ObjectToString();

    private TagValue() {
    }

    public static String convToString(Object obj) {
        return TagValue.convToString(obj, new ToStringOption());
    }

    public static String convToString(Object obj, int maxLength) {
        ToStringOption option = new ToStringOption();
        option.setMaxLength(maxLength);
        return TagValue.convToString(obj, new ToStringOption());
    }

    public static String convToString(Object obj, ToStringOption option) {
        if (obj == null) {
            return "null";
        }
        try {
            TagToString tool = TagValue.get(obj);
            String tagStr = tool.convToString(obj, option);
            if (tagStr.length() > option.getMaxLength()) {
                tagStr = tagStr.substring(0, option.getMaxLength() - 3) + "..." + tagStr.length();
            }
            return tagStr;
        }
        catch (RuntimeException exp) {
            return obj.getClass().getName();
        }
    }

    private static TagToString get(Object obj) {
        if (obj.getClass().isArray()) {
            return toStrTools.get(CLASS_ARRAY);
        }
        if (obj instanceof DynamicObject) {
            return toStrTools.get(CLASS_DYNAMICOBJECT);
        }
        if (obj instanceof IDataEntityType) {
            return toStrTools.get(CLASS_DATAENTITYTYPE);
        }
        if (obj instanceof IDataEntityProperty) {
            return toStrTools.get(CLASS_DATAENTITYPROPERTY);
        }
        if (obj instanceof String) {
            return toStrTools.get(CLASS_STRING);
        }
        if (obj instanceof Map) {
            return toStrTools.get(CLASS_Map);
        }
        if (obj instanceof List) {
            return toStrTools.get(CLASS_LIST);
        }
        return otherToString;
    }

    static {
        toStrTools.put(CLASS_DYNAMICOBJECT, new DynamicObjectToString());
        toStrTools.put(CLASS_DATAENTITYTYPE, new EntityTypeToString());
        toStrTools.put(CLASS_DATAENTITYPROPERTY, new EntityPropertyToString());
        toStrTools.put(CLASS_ARRAY, new ArrayToString());
        toStrTools.put(CLASS_STRING, new StringToString());
        toStrTools.put(CLASS_Map, new MapToString());
        toStrTools.put(CLASS_LIST, new ListToString());
    }
}

