/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.trace.writer;

import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.trace.EntityTraceSpanInfo;
import kd.bos.dataentity.trace.EntityTraceWriter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.trace.cache.ConfigCacheReader;
import kd.bos.entity.trace.cache.MessageCacheWriter;
import kd.bos.entity.trace.cache.MessagePackage;
import kd.bos.entity.trace.writer.AbstractEntityTraceWriter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

class EntityTraceWriteCache
extends AbstractEntityTraceWriter {
    private static final int MAX_MSG_ROWS = 500;
    private static final long MAX_TIME_SPAN = 450L;
    private static final String FILE_ENTITY_TRICE_SPANIMPL = "EntityTraceSpanImpl.java";
    private static final String TAG_TRACEID = "traceId: ";
    private static final Set<String> ROOT_TYPES = new HashSet<String>(10);
    private static final int MAX_MESSAGE_LENGTH = 5000;
    private MessagePackage messagePackage;

    EntityTraceWriteCache() {
    }

    public void write(EntityTraceSpanInfo span, String message, EntityTraceWriter.InfoLevel level) {
        if (!this.getConfig().isRealtime()) {
            return;
        }
        if (this.messagePackage == null) {
            this.messagePackage = new MessagePackage();
        }
        this.writeParentMessage(span.getParent());
        String printMessage = message;
        if (message.length() > 5000) {
            printMessage = message.substring(0, 5000);
        }
        long currTime = System.currentTimeMillis();
        if (span.isWriteTag()) {
            MessagePackage.Message messageInfo = this.messagePackage.findMessage(span.getId());
            if (messageInfo != null) {
                messageInfo.setMsg(printMessage);
                String stackTrace = this.getStackTrace(span);
                if (StringUtils.isNotBlank((CharSequence)stackTrace)) {
                    messageInfo.setTc(stackTrace);
                }
            } else {
                this.messagePackage.addMessage(DBServiceHelper.genGlobalLongId(), span.getId(), currTime, this.getSpanLevel(span) + 1, span.getType(), span.getName() + ".detail", printMessage, "");
            }
        } else {
            this.messagePackage.addMessage(span.getId(), span.getPId(), span.getStartTime(), this.getSpanLevel(span), span.getType(), span.getName(), printMessage, this.getStackTrace(span));
            span.setWriteTag(true);
        }
        if (this.messagePackage.getMessages().size() >= 500 || currTime - this.messagePackage.getCreateTime() >= 450L) {
            this.saveMessage();
            this.getConfig().setRealtime(ConfigCacheReader.isRealtime());
        }
    }

    @Override
    public void close(EntityTraceSpanInfo span) {
        super.close(span);
        if (!span.isWriteTag()) {
            return;
        }
        if (!this.getConfig().isRealtime()) {
            return;
        }
        if (this.messagePackage == null) {
            return;
        }
        MessagePackage.Message message = this.messagePackage.findMessage(span.getId());
        if (message != null) {
            message.setCt(span.getCost());
        } else {
            this.messagePackage.addCost(span.getId(), span.getCost());
        }
        if (span.isRootSpan()) {
            this.saveMessage();
        }
    }

    private void writeParentMessage(EntityTraceSpanInfo parent) {
        if (parent == null || parent.isWriteTag()) {
            return;
        }
        this.writeParentMessage(parent.getParent());
        String traceId = "";
        if (parent.isRootSpan()) {
            traceId = TAG_TRACEID + RequestContext.get().getTraceId();
        }
        this.messagePackage.addMessage(parent.getId(), parent.getPId(), parent.getStartTime(), this.getSpanLevel(parent), parent.getType(), parent.getName(), parent.buildSpanInfo(), traceId);
        parent.setWriteTag(true);
    }

    private void saveMessage() {
        MessageCacheWriter.put(this.messagePackage);
        this.messagePackage = null;
    }

    private String getStackTrace(EntityTraceSpanInfo span) {
        if (!SystemParamServiceHelper.isShowStackTrace() || !this.getConfig().isPrintStackTrace()) {
            if (!span.isRootSpan()) {
                return "";
            }
            if (ROOT_TYPES.contains(span.getType())) {
                return TAG_TRACEID + RequestContext.get().getTraceId();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TAG_TRACEID).append(RequestContext.get().getTraceId()).append(" ").append(System.lineSeparator());
        int traceIdLength = sb.length();
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            if (this.isEntityTraceSpan(trace[i])) {
                sb.setLength(traceIdLength);
                continue;
            }
            sb.append(System.lineSeparator()).append("\tat ").append(trace[i]);
            if (this.isActionFilter(trace[i])) break;
        }
        return sb.toString();
    }

    private boolean isEntityTraceSpan(StackTraceElement traceElement) {
        return StringUtils.equals((CharSequence)FILE_ENTITY_TRICE_SPANIMPL, (CharSequence)traceElement.getFileName());
    }

    private boolean isActionFilter(StackTraceElement traceElement) {
        return StringUtils.equals((CharSequence)traceElement.getFileName(), (CharSequence)"ActionFilter.java") && StringUtils.equals((CharSequence)traceElement.getMethodName(), (CharSequence)"doFilter");
    }

    private int getSpanLevel(EntityTraceSpanInfo span) {
        int level = 1;
        for (EntityTraceSpanInfo parent = span.getParent(); parent != null; parent = parent.getParent()) {
            ++level;
        }
        return level;
    }

    static {
        ROOT_TYPES.add("FormService");
    }
}

