/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PrivacyBlackFieldManagePlugin
extends AbstractFormPlugin {
    private static final String ENTITY_NAME = "entity_name";
    private static final String ISV = "isv";
    private static final String CONTROL_STRATEGY = "control_strategy";
    private static final String ENTRY_ENTITY = "blackfieldinfo";
    private static final String FIELD_IDEN = "field_iden";
    private static final String FIELD_NAME = "field_name";
    private static final String FIELD_TYPE = "field_type";
    private static final String FIELD_STRATEGY = "field_strategy";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String BOS_PRIVACY_PLUGIN = "bos-privacy-plugin";
    private static final String CALLBACK_ENTITY = "callBackEntity";
    private static final String CALLBACK_FIELD = "callBackFieldSelect";
    private static final String BTN_SAVE = "btn_save";
    private static final String CACHEKEY_ENTITY_NUMBER = "entityNumber";
    private static final String KEY_SELECTED_FIELDS = "selectedFields";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ENTITY_NAME, FIELD_IDEN, BTN_SAVE});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "entity_name": {
                this.showEntitySelector();
                break;
            }
            case "field_iden": {
                String entityNumber = this.getPageCache().get(CACHEKEY_ENTITY_NUMBER);
                this.showFieldSelector(entityNumber);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String isv = ISVServiceHelper.getISVInfo().getId();
        this.getModel().setValue(ISV, (Object)isv);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        Object source = args.getSource();
        if (source instanceof Save) {
            if (model.getEntryRowCount(ENTRY_ENTITY) == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u589e\u52a0\u4e00\u4e2a\u5b57\u6bb5\u3002", (String)"PrivacyBlackFieldManagePlugin_1", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            Object strategy = model.getValue(CONTROL_STRATEGY);
            int rowCount = model.getEntryRowCount(ENTRY_ENTITY);
            for (int i = 0; i < rowCount; ++i) {
                model.setValue(FIELD_STRATEGY, strategy, i);
            }
        } else if (source instanceof NewEntry && this.getPageCache().get(CACHEKEY_ENTITY_NUMBER) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b9e\u4f53\u201d\u3002", (String)"PrivacyBlackFieldManagePlugin_2", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof NewEntry) {
            String entityNumber = this.getPageCache().get(CACHEKEY_ENTITY_NUMBER);
            this.showFieldSelector(entityNumber);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (ENTITY_NAME.equalsIgnoreCase(e.getProperty().getName())) {
            this.getModel().deleteEntryData(ENTRY_ENTITY);
        }
    }

    private void showEntitySelector() {
        ListShowParameter param = this.createListShowParameter(BOS_FORMMETA, "bos_devp_formtreelistf7", ResManager.loadKDString((String)"\u5b9e\u4f53\u9009\u62e9", (String)"PrivacyBlackFieldManagePlugin_0", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), Boolean.FALSE, new CloseCallBack((IFormPlugin)this, CALLBACK_ENTITY));
        param.setCustomParam("onlyvisible", (Object)Boolean.FALSE);
        param.setCustomParam("onlydeployed", (Object)Boolean.FALSE);
        List qFilters = param.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "DynamicFormModel", "ReportFormModel")));
        this.getView().showForm((FormShowParameter)param);
    }

    private ListShowParameter createListShowParameter(String billFormId, String fromId, String caption, boolean isMultiSelect, CloseCallBack callBack) {
        ListShowParameter param = ShowFormHelper.createShowListForm((String)billFormId, (boolean)isMultiSelect);
        param.setCaption(caption);
        param.setFormId(fromId);
        param.setCloseCallBack(callBack);
        return param;
    }

    private void showFieldSelector(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b9e\u4f53\u201d\u3002", (String)"PrivacyBlackFieldManagePlugin_2", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam(CACHEKEY_ENTITY_NUMBER, (Object)entityNumber);
        HashSet<String> selectedFields = new HashSet<String>(16);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject row : rows) {
            selectedFields.add(row.getString(FIELD_IDEN));
        }
        showParameter.setCustomParam(KEY_SELECTED_FIELDS, (Object)SerializationUtils.toJsonString(selectedFields));
        showParameter.setFormId("privacy_black_fieldselect");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_FIELD));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        IDataModel model = this.getModel();
        if (CALLBACK_ENTITY.equalsIgnoreCase(actionId)) {
            if (event.getReturnData() == null) {
                return;
            }
            ListSelectedRowCollection data = (ListSelectedRowCollection)event.getReturnData();
            String entityNum = data.get(0).getNumber();
            String entityName = data.get(0).getName();
            QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)entityNum)};
            DynamicObject object = QueryServiceHelper.queryOne((String)BOS_FORMMETA, (String)"id,name,bizappid", (QFilter[])filters);
            Object entityId = object.get("id");
            Object bizappid = object.get("bizappid");
            this.getPageCache().put(CACHEKEY_ENTITY_NUMBER, entityNum);
            model.setValue(ENTITY_NAME, (Object)entityName);
            model.setValue("entity_basedata", entityId);
            model.setValue("app_basedata", bizappid);
        } else if (CALLBACK_FIELD.equalsIgnoreCase(actionId)) {
            int currentRowIndex = model.getEntryCurrentRowIndex(ENTRY_ENTITY);
            if (event.getReturnData() == null) {
                DynamicObject currentRow = model.getEntryRowEntity(ENTRY_ENTITY, currentRowIndex);
                if (StringUtils.isBlank((Object)currentRow.get(FIELD_IDEN))) {
                    model.deleteEntryRow(ENTRY_ENTITY, currentRowIndex);
                }
                return;
            }
            DynamicObjectCollection selectData = (DynamicObjectCollection)event.getReturnData();
            int newRowCount = selectData.size();
            if (newRowCount > 1) {
                model.batchCreateNewEntryRow(ENTRY_ENTITY, newRowCount - 1);
            }
            int rowIndex = currentRowIndex;
            for (DynamicObject row : selectData) {
                model.setValue(FIELD_NAME, row.get(FIELD_NAME), rowIndex);
                model.setValue(FIELD_IDEN, row.get(FIELD_IDEN), rowIndex);
                model.setValue(FIELD_TYPE, row.get(FIELD_TYPE), rowIndex);
                ++rowIndex;
            }
        }
    }
}

