/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.list.F7SelectedList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.privacy.plugin.PrivacyLabelFieldUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class PrivacyBlackListFieldSelectorPlugin
extends AbstractListPlugin
implements ClickListener,
RowClickEventListener,
SearchEnterListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIELD_NAME = "field_name";
    private static final String FIELD_IDEN = "field_iden";
    private static final String FIELD_TYPE = "field_type";
    private static final String ENTITY_NAME = "entity_name";
    private static final String SEARCH_AP = "searchap";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String KEY_SELECTED_FIELDS = "selectedFields";
    private static final String KEY_ENTITY_NUMBER = "entityNumber";

    public void registerListener(EventObject e) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_ENTITY);
        if (null != grid) {
            grid.addRowClickListener((RowClickEventListener)this);
        }
        Search search = (Search)this.getView().getControl(SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.renderFieldData();
    }

    private void renderFieldData() {
        QFilter[] filters;
        DynamicObject object;
        String fentityId;
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(KEY_ENTITY_NUMBER);
        Set selectedFields = (Set)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam(KEY_SELECTED_FIELDS)), Set.class);
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        HashSet<String> enableFields = new HashSet<String>(10);
        String fid = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        if (!fid.equals(fentityId = (object = QueryServiceHelper.queryOne((String)BOS_FORMMETA, (String)"basedatafield", (QFilter[])(filters = new QFilter[]{new QFilter("number", "=", (Object)entityNumber)}))).getString("basedatafield"))) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
        List items = entityMetadata.getItems();
        for (EntityItem item : items) {
            if (!(item instanceof Field) || PrivacyLabelFieldUtils.isFilterFieldType(item) || selectedFields.contains(item.getKey())) continue;
            enableFields.add(item.getKey());
        }
        if (enableFields.size() == 0) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map fields = entityType.getAllFields();
        if (fields.size() < 1) {
            return;
        }
        String entityName = entityType.getName();
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(ENTRY_ENTITY, enableFields.size());
        int index = 0;
        for (Map.Entry fieldEntry : fields.entrySet()) {
            IDataEntityProperty property = (IDataEntityProperty)fieldEntry.getValue();
            String fieldIden = property.getName();
            if (!enableFields.contains(fieldIden)) continue;
            LocaleString fieldName = property.getDisplayName();
            String fieldType = property.getPropertyType().getSimpleName();
            model.setValue(FIELD_NAME, (Object)fieldName, index);
            model.setValue(FIELD_IDEN, (Object)fieldIden, index);
            model.setValue(FIELD_TYPE, (Object)fieldType, index);
            model.setValue(ENTITY_NAME, (Object)entityName, index);
            ++index;
        }
        this.getView().getPageCache().put("entryData", SerializationUtils.toJsonString((Object)this.getModel().getEntryEntity(ENTRY_ENTITY)));
    }

    public void entryRowClick(RowClickEvent evt) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selRows = grid.getEntryState().getSelectedRows();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(selRows.length);
        for (int selRow : selRows) {
            DynamicObject row = (DynamicObject)entryEntity.get(selRow);
            String text = String.format("%s", row.getString(FIELD_NAME));
            valueTextItems.add(new ValueTextItem(text, text));
        }
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("f7selectedlistap");
        f7SelectedList.addItems(valueTextItems);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.returnData();
        }
    }

    private void returnData() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selRows = grid.getEntryState().getSelectedRows();
        if (selRows == null || selRows.length < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5!", (String)"PrivacyBlackListFieldSelectorPlugin_0", (String)"bos-privacy-plugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection selectData = new DynamicObjectCollection();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int selRow : selRows) {
            selectData.add(entryEntity.get(selRow));
        }
        this.getView().returnDataToParent((Object)selectData);
        this.getView().close();
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String searchText = evt.getText();
        if (!StringUtils.equals((CharSequence)SEARCH_AP, (CharSequence)search.getKey())) {
            return;
        }
        List data = (List)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("entryData"), List.class);
        if (CollectionUtils.isEmpty((Collection)data)) {
            return;
        }
        List<Map> newData = new ArrayList(data.size());
        if (StringUtils.isBlank((CharSequence)searchText)) {
            newData = data;
        } else {
            List fieldNames = evt.getFieldNames();
            for (Map row : data) {
                for (String fieldName : fieldNames) {
                    String field = row.getOrDefault(fieldName, "").toString();
                    if (!field.contains(searchText)) continue;
                    newData.add(row);
                }
            }
        }
        this.getModel().beginInit();
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (!CollectionUtils.isEmpty(newData)) {
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, newData.size());
            for (int i = 0; i < newData.size(); ++i) {
                Map row = (Map)newData.get(i);
                this.getModel().setValue(FIELD_IDEN, row.get(FIELD_IDEN), i);
                this.getModel().setValue(FIELD_NAME, row.get(FIELD_NAME), i);
                this.getModel().setValue(FIELD_TYPE, row.get(FIELD_TYPE), i);
                this.getModel().setValue(ENTITY_NAME, row.get(ENTITY_NAME), i);
            }
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }
}

