/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.privacy.plugin.PrivacyPluginUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import org.bouncycastle.util.Arrays;

public class PrivacyBlackManageListPlugin
extends AbstractListPlugin {
    private static final String EntityKey_Manage = "privacy_blackfield_manage";
    private static final String T_Privacy_BlackField = "t_privacy_blackfield";
    private static final String T_Privacy_BlackFieldInfo = "t_privacy_blackfieldinfo";
    private static final String BarItem_Del = "baritem_delete";
    private DBRoute sysRoute = DBRoute.of((String)"sys");
    private static final String BOS_PRIVACY_PLUGIN = "bos-privacy-plugin";
    private static final String ADDNEW = "ADDNEW";
    private static final String CallBackId_doDelete = "doDelete";

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String status = e.getParameter().getStatus().name();
        if (ADDNEW.equals(status)) {
            e.getParameter().setCaption(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u9ed1\u540d\u5355\u5b57\u6bb5\u3002", (String)"PrivacyBlackManageListPlugin_1", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Donothing op;
        String key;
        if (args.getSource() instanceof Donothing && (key = (op = (Donothing)args.getSource()).getOperateKey()).equalsIgnoreCase(BarItem_Del)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CallBackId_doDelete, (IFormPlugin)this);
            ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows();
            if (!selectedRows.isEmpty()) {
                String message = String.format(ResManager.loadKDString((String)"\u5df2\u9009\u4e2d%d\u6761\u8bb0\u5f55\uff0c\u786e\u8ba4\u8981\u5220\u9664\u8bb0\u5f55\u5417\uff1f", (String)"PrivacyBlackManageListPlugin_2", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), selectedRows.size());
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks);
            }
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (CallBackId_doDelete.equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.deleteByEntryRow();
        }
    }

    private void deleteByEntryRow() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        HashSet<Object> idSet = new HashSet<Object>(rows.size());
        HashSet<Object> entryIdSet = new HashSet<Object>(16);
        for (ListSelectedRow row : rows) {
            Object fid = row.getPrimaryKeyValue();
            if (!this.validateISV(fid)) continue;
            Object entryId = row.getEntryPrimaryKeyValue();
            idSet.add(fid);
            entryIdSet.add(entryId);
        }
        if (!idSet.isEmpty() && !entryIdSet.isEmpty()) {
            String deleteSql = this.getDeleteSql(idSet, entryIdSet);
            DB.execute((DBRoute)this.sysRoute, (String)deleteSql);
            this.syncRemoveData(idSet);
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"PrivacyBlackManageListPlugin_3", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"PrivacyBlackManageListPlugin_4", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]);
            this.addLog(msg);
        }
    }

    private void addLog(String msg) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        String formId = EntityKey_Manage;
        OpLogAppInfo logInfo = this.buildLogInfo(formId, msg);
        logService.addLog((AppLogInfo)logInfo);
    }

    private OpLogAppInfo buildLogInfo(String formId, String msg) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        logInfo.setBizAppID(BizAppServiceHelp.getAppIdByAppNumber((String)"privacy"));
        logInfo.setBizObjID(formId);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName("delete", ResManager.loadKDString((String)"\u5220\u9664", (String)"PrivacyBlackManageListPlugin_5", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
        logInfo.setStatus("1");
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    private void syncRemoveData(Set idSet) {
        String delStr;
        ArrayList deleteIds = new ArrayList(idSet);
        String entityName = EntityKey_Manage;
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)idSet)};
        Object[] objs = BusinessDataServiceHelper.load((String)entityName, (String)"id,blackfieldinfo.id", (QFilter[])qFilters);
        if (!Arrays.isNullOrEmpty((Object[])objs)) {
            for (Object obj : objs) {
                DynamicObjectCollection doc = (DynamicObjectCollection)obj.get(1);
                if (doc.size() <= 0) continue;
                deleteIds.remove(obj.get("id"));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(delStr = this.inConvert(deleteIds)))) {
            String delSql = String.format("delete from %s where fid in (%s)", T_Privacy_BlackField, delStr);
            DB.execute((DBRoute)this.sysRoute, (String)delSql);
        }
    }

    private String inConvert(Collection ids) {
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Object id : ids) {
            builder.append("'");
            builder.append(id);
            builder.append("',");
        }
        int len = builder.length();
        return len > 0 ? builder.substring(0, len - 1) : null;
    }

    private boolean validateISV(Object fid) {
        String selectFields = "system_preset,isv";
        QFilter filter = new QFilter("id", "=", fid);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject obj = QueryServiceHelper.queryOne((String)EntityKey_Manage, (String)selectFields, (QFilter[])filters);
        if (obj != null) {
            String currentISV;
            String isv;
            boolean preset = obj.getBoolean("system_preset");
            if (preset && !StringUtils.equals((CharSequence)(isv = obj.getString("isv")), (CharSequence)(currentISV = ISVServiceHelper.getISVInfo().getId()))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u5b57\u6bb5\u4e0d\u53ef\u5220\u9664\u3002", (String)"PrivacyBlackManageListPlugin_0", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private String getDeleteSql(Set idSet, Set entryIdSet) {
        StringBuilder ids = new StringBuilder();
        for (Object id : idSet) {
            ids.append("'");
            ids.append(id);
            ids.append("'");
            ids.append(",");
        }
        StringBuilder entryIds = new StringBuilder();
        for (Object entryId : entryIdSet) {
            entryIds.append("'");
            entryIds.append(entryId);
            entryIds.append("'");
            entryIds.append(",");
        }
        int iLen = ids.length();
        int eLen = entryIds.length();
        String sql = "delete from t_privacy_blackfieldinfo where fid in (" + ids.substring(0, iLen - 1) + ") and fentryid in (" + entryIds.substring(0, eLen - 1) + ")";
        return sql;
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc columnDesc = (ColumnDesc)e.getSource();
        String colKey = columnDesc.getKey();
        String dataKey = "";
        switch (colKey) {
            case "control_strategy_entry": {
                dataKey = "control_strategy";
                break;
            }
            case "system_preset_entry": {
                dataKey = "system_preset";
                break;
            }
            case "entity_basedata_entry.number": {
                dataKey = "entity_basedata.number";
                break;
            }
            case "entity_basedata_entry.name": {
                dataKey = "entity_basedata.name";
                break;
            }
            case "app_basedata_entry.number": {
                dataKey = "app_basedata.number";
                break;
            }
            case "app_basedata_entry.name": {
                dataKey = "app_basedata.name";
                break;
            }
            case "creater_entry.name": {
                dataKey = "creater.name";
                break;
            }
            case "createdate_entry": {
                dataKey = "createdate";
                break;
            }
            case "modifier_entry.name": {
                dataKey = "modifier.name";
                break;
            }
            case "modifydate_entry": {
                dataKey = "modifydate";
                break;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dataKey)) {
            e.setFormatValue(e.getRowData().get(dataKey));
        }
        super.packageData(e);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        LicenseCheckResult checkResult = PrivacyPluginUtil.getLicenseCheckResult();
        if (checkResult != null && !checkResult.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(checkResult.getMsg());
        }
    }
}

