/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.privacy.plugin.PrivacyLabelFieldUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class PrivacyLabelEntiryFieldPlugin
extends AbstractListPlugin
implements ListRowClickListener {
    private static final Log log = LogFactory.getLog(PrivacyLabelEntiryFieldPlugin.class);
    private List<Map<String, List<Object>>> fastFilterValues = null;
    private List<String> idList = new ArrayList<String>();
    private static String BOS_PRIVACY_PLUGIN = "bos-privacy-plugin";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok", "btreturn"});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List list = (List)formShowParameter.getCustomParam("list");
        DynamicObjectCollection appCollection = BizAppServiceHelp.getAllBizApps();
        if (list != null) {
            for (Map map : list) {
                this.idList.add((String)map.get("id"));
            }
        }
        for (DynamicObject app : appCollection) {
            if (!this.idList.contains(app.getString("masterid"))) continue;
            this.idList.add(app.getString("id"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u901a\u8fc7\u7269\u7406\u5b57\u6bb5\u540d/\u7269\u7406\u8868\u540d/\u5b57\u6bb5\u540d\u79f0\u8fdb\u884c\u641c\u7d22\u3002", (String)"PrivacyLabelEntiryFieldPlugin_3", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new PrivacyLabelEntiryFieldData(this.getView()));
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        this.fastFilterValues = args.getFastFilterValues();
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection listSelectedRows = evt.getListSelectedRowCollection();
        String listData = this.getView().getPageCache().get("listData");
        if (StringUtils.isNotBlank((CharSequence)listData)) {
            Map allDataMap = (Map)SerializationUtils.fromJsonString((String)listData, Map.class);
            for (ListSelectedRow row : listSelectedRows) {
                String primaryKeyValue = row.getPrimaryKeyValue().toString();
                String rowDataStr = (String)allDataMap.get(primaryKeyValue);
                if (!StringUtils.isNotBlank((CharSequence)rowDataStr)) continue;
                Map rowData = (Map)SerializationUtils.fromJsonString((String)rowDataStr, Map.class);
                row.setName((String)rowData.get("name"));
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        Control contrl = (Control)evt.getSource();
        switch (key = contrl.getKey()) {
            case "btnok": {
                this.returnData();
                break;
            }
            case "btreturn": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("privacy_cloud_select");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().close();
                this.getView().getParentView().showForm(formShowParameter);
                this.getView().sendFormAction(this.getView().getParentView());
            }
        }
    }

    private void returnData() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5\u3002", (String)"PrivacyLabelEntiryFieldPlugin_0", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
        } else {
            ArrayList<Map> dataList = new ArrayList<Map>();
            String listData = this.getView().getPageCache().get("listData");
            if (StringUtils.isNotBlank((CharSequence)listData)) {
                Map allDataMap = (Map)SerializationUtils.fromJsonString((String)listData, Map.class);
                for (ListSelectedRow row : selectedRows) {
                    String primaryKeyValue = row.getPrimaryKeyValue().toString();
                    String rowDataStr = (String)allDataMap.get(primaryKeyValue);
                    if (!StringUtils.isNotBlank((CharSequence)rowDataStr)) continue;
                    Map rowData = (Map)SerializationUtils.fromJsonString((String)rowDataStr, Map.class);
                    dataList.add(rowData);
                }
            }
            this.getView().returnDataToParent(dataList);
            this.getView().close();
        }
    }

    class PrivacyLabelEntiryFieldData
    extends ListDataProvider {
        private IFormView view;

        public IFormView getView() {
            return this.view;
        }

        public void setView(IFormView view) {
            this.view = view;
        }

        public PrivacyLabelEntiryFieldData(IFormView view) {
            this.view = view;
        }

        public int getMaxCount() {
            String dataCount = PrivacyLabelEntiryFieldPlugin.this.getPageCache().get("dataCount");
            if (StringUtils.isNotBlank((CharSequence)dataCount)) {
                return Integer.parseInt(dataCount);
            }
            return 0;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"privacy_label_entityfield");
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection((DynamicObjectType)dt, null);
            if (CollectionUtils.isEmpty((Collection)PrivacyLabelEntiryFieldPlugin.this.idList)) {
                return dynamicObjectCollection;
            }
            if (CollectionUtils.isEmpty((Collection)PrivacyLabelEntiryFieldPlugin.this.fastFilterValues)) {
                return dynamicObjectCollection;
            }
            StringBuilder rt = new StringBuilder();
            for (String id : PrivacyLabelEntiryFieldPlugin.this.idList) {
                rt.append('\'');
                rt.append(id);
                rt.append("',");
            }
            String sql = String.format("select fid,fnumber,fbizappid,fmodeltype from t_meta_entitydesign tme where fmodeltype in ('BillFormModel','BaseFormModel','DynamicFormModel','ReportFormModel', 'MobileFormModel')\nand  fbizappid in (%s)", rt.substring(0, rt.length() - 1));
            Map<String, String> allDataMap = new HashMap(16);
            try (DataSet dataSet = DB.queryDataSet((String)"PrivacyLabelEntiryFieldData.query", (DBRoute)DBRoute.meta, (String)sql);){
                IPageCache pageCache = this.getView().getPageCache();
                String listData = pageCache.get("listData");
                if (StringUtils.isNotBlank((CharSequence)listData)) {
                    allDataMap = (Map)SerializationUtils.fromJsonString((String)pageCache.get("listData"), Map.class);
                }
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    String fid = row.getString("fid");
                    String entityNumber = row.getString("fnumber");
                    String appid = row.getString("fbizappid");
                    String modelType = row.getString("fmodeltype");
                    DynamicObject cloudObject = BizCloudServiceHelp.getBizCloudByAppID((String)appid);
                    DynamicObject appObject = BizAppServiceHelp.getBizAppByID((String)appid);
                    ILocaleString appName = appObject.getLocaleString("name");
                    ILocaleString cloudName = cloudObject.getLocaleString("name");
                    String cloudNumber = (String)cloudObject.get("id");
                    if (StringUtils.isEmpty((CharSequence)fid) || StringUtils.isEmpty((CharSequence)entityNumber)) continue;
                    try {
                        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
                        LocaleString entityName = entityMetadata.getName();
                        Map<String, String> fieldStrategyMap = PrivacyLabelFieldUtils.getFieldStrategyMap(entityNumber);
                        Set<String> filteredFields = PrivacyLabelFieldUtils.getFilteredFields(entityMetadata, fieldStrategyMap);
                        if (CollectionUtils.isEmpty(filteredFields)) continue;
                        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                        HashMap allFields = new HashMap(mainType.getAllFields());
                        for (String filteredField : filteredFields) {
                            IDataEntityProperty field = (IDataEntityProperty)allFields.get(filteredField);
                            if (field == null) continue;
                            String tableName = field.getParent().getAlias();
                            String tableGroup = StringUtils.isEmpty((CharSequence)tableName) ? tableName : String.format("%s%s", tableName, StringUtils.isBlank((CharSequence)field.getTableGroup()) ? "" : "_" + field.getTableGroup());
                            String fieldName = field.getAlias();
                            if ("MobileFormModel".equals(modelType) && StringUtils.isBlank((CharSequence)fieldName)) {
                                fieldName = field.getName();
                            }
                            if (StringUtils.isNotEmpty((CharSequence)tableGroup)) {
                                tableGroup = tableGroup.toLowerCase(Locale.ENGLISH);
                            }
                            if (StringUtils.isNotEmpty((CharSequence)fieldName)) {
                                fieldName = fieldName.toLowerCase(Locale.ENGLISH);
                            }
                            DynamicObject dynamicObject = (DynamicObject)dt.createInstance();
                            dynamicObject.set("ffield_type", (Object)field.getPropertyType().getSimpleName());
                            dynamicObject.set("ftable_name", (Object)tableGroup);
                            dynamicObject.set("ffield_name", (Object)fieldName);
                            dynamicObject.set("ffield_desc", (Object)field.getDisplayName());
                            dynamicObject.set("ffield_ident", (Object)field.getName());
                            dynamicObject.set("fentity_name", (Object)entityName);
                            dynamicObject.set("fentity_number", (Object)entityNumber);
                            dynamicObject.set("fapp_name", (Object)appName);
                            dynamicObject.set("fapp_number", (Object)appid);
                            dynamicObject.set("fcloud_number", (Object)cloudNumber);
                            dynamicObject.set("fcloud_name", (Object)cloudName);
                            dynamicObject.set("appRoute", (Object)this.getDBRouteById(appid));
                            dynamicObject.set("name", (Object)String.format("%s(%s)", field.getDisplayName().toString(), entityName));
                            String key = entityNumber + "$" + field.getName();
                            dynamicObject.set("id", (Object)key);
                            if (!this.isEligibleRow(dynamicObject)) continue;
                            dynamicObjectCollection.add((Object)dynamicObject);
                            allDataMap.put(key, SerializationUtils.toJsonString((Object)dynamicObject));
                        }
                    }
                    catch (Exception e) {
                        log.warn("\u6807\u7b7e\u5b57\u6bb5\u641c\u7d22\u5b58\u5728\u95ee\u9898", (Throwable)e);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(allDataMap)) {
                this.getView().getPageCache().put("listData", SerializationUtils.toJsonString(allDataMap));
            }
            PrivacyLabelEntiryFieldPlugin.this.getPageCache().put("dataCount", String.valueOf(dynamicObjectCollection.size()));
            this.getQueryResult().setCollection(dynamicObjectCollection);
            return dynamicObjectCollection;
        }

        private boolean isEligibleRow(DynamicObject dynamicObject) {
            if (CollectionUtils.isEmpty((Collection)PrivacyLabelEntiryFieldPlugin.this.fastFilterValues)) {
                return true;
            }
            boolean eligibleRow = false;
            for (Map fastFilterValue : PrivacyLabelEntiryFieldPlugin.this.fastFilterValues) {
                List value;
                List fieldNames = (List)fastFilterValue.get("FieldName");
                eligibleRow = this.isEligibleRow(fieldNames, value = (List)fastFilterValue.get("Value"), dynamicObject);
                if (eligibleRow) continue;
                return false;
            }
            return eligibleRow;
        }

        private boolean isEligibleRow(List<Object> fieldNames, List<Object> value, DynamicObject dynamicObject) {
            if (fieldNames == null || value == null) {
                return true;
            }
            for (Object fieldName : fieldNames) {
                String field = dynamicObject.getString(fieldName.toString());
                for (Object searchValue : value) {
                    if (!field.contains(searchValue.toString())) continue;
                    return true;
                }
            }
            return false;
        }

        private Integer convertFieldType(String fieldType) {
            switch (fieldType) {
                case "Date": {
                    return 91;
                }
                case "BigDecimal": {
                    return 3;
                }
                case "Integer": {
                    return 4;
                }
                case "String": {
                    return 12;
                }
                case "ILocaleString": {
                    return 1112;
                }
                case "DynamicObject": {
                    return 1111;
                }
                case "Long": {
                    return -5;
                }
            }
            return 12;
        }

        private String getDBRouteById(String appId) {
            DynamicObject cloud = BusinessDataServiceHelper.loadSingleFromCache((Object)appId, (String)"bos_devportal_bizapp", (String)"dbroute");
            String bizCloudNumber = cloud == null ? "" : cloud.getString("dbroute");
            return bizCloudNumber;
        }
    }
}

