/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AddressField;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.CityField;
import kd.bos.metadata.entity.businessfield.CurrencyField;
import kd.bos.metadata.entity.businessfield.MaterielField;
import kd.bos.metadata.entity.businessfield.NameField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.businessfield.UnitField;
import kd.bos.metadata.entity.businessfield.UserField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.EmailField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.metadata.entity.commonfield.TelephoneField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.commonfield.TimeField;

public class PrivacyLabelFieldUtils {
    private static final String T_Privacy_BlackFieldInfo = "t_privacy_blackfieldinfo";
    private static final String T_Privacy_BlackField = "t_privacy_blackfield";
    private static final Log log = LogFactory.getLog(PrivacyLabelFieldUtils.class);

    protected static Map<String, String> getFieldStrategyMap(String entityNumber) {
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
        String sql = "select ffield_iden,ffield_strategy from t_privacy_blackfieldinfo where fid in (select fid from t_privacy_blackfield where fentity_id = '" + entityId + "')";
        return (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, null, rs -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            while (rs.next()) {
                String field_iden = rs.getString("ffield_iden");
                String field_strategy = rs.getString("ffield_strategy");
                map.put(field_iden, field_strategy);
            }
            return map;
        });
    }

    protected static Set<String> getFilteredFields(String entityNumber, Map<String, String> fieldStrategyMap) {
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        return PrivacyLabelFieldUtils.getFilteredFields(entityMetadata, fieldStrategyMap);
    }

    protected static Set<String> getFilteredFields(EntityMetadata entityMetadata, Map<String, String> fieldStrategyMap) {
        HashSet<String> filteredFields = new HashSet<String>(10);
        HashSet<String> noSets = new HashSet<String>(2);
        noSets.add(",nodes,noenc,");
        noSets.add(",noenc,nodes,");
        StringBuilder sb = new StringBuilder();
        List items = entityMetadata.getItems();
        for (EntityItem item : items) {
            if (!(item instanceof Field) || PrivacyLabelFieldUtils.isFilterFieldType(item)) continue;
            String fieldIden = item.getKey();
            if (!noSets.contains(fieldStrategyMap.get(fieldIden))) {
                filteredFields.add(fieldIden);
                continue;
            }
            LocaleString fieldName = item.getName();
            sb.append(String.format("%s(%s), ", fieldIden, fieldName));
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            String entityNumber = entityMetadata.getKey();
            LocaleString entityName = entityMetadata.getName();
            log.info(String.format(ResManager.loadKDString((String)"\u9690\u79c1\u4e2d\u5fc3-\u6570\u636e\u5b89\u5168\u6807\u7b7e-\u5b9e\u4f53\uff1a%1$s(%2$s)\uff0c\u8fc7\u6ee4\u4e0d\u5141\u8bb8\u8131\u654f\u4e0e\u52a0\u5bc6\u5b57\u6bb5\uff1a%3$s", (String)"PrivacyLabelFieldUtils_0", (String)"bos-privacy-plugin", (Object[])new Object[0]), entityNumber, entityName, sb.substring(0, sb.length() - 2)));
        }
        return filteredFields;
    }

    protected static boolean isFilterFieldType(EntityItem<?> item) {
        return (!(item instanceof TextField) || item.getClass().equals(LargeTextField.class)) && !item.getClass().equals(IntegerField.class) && !item.getClass().equals(DecimalField.class) && !item.getClass().equals(BigIntField.class) && !(item instanceof DateTimeField) && !(item instanceof TimeField) && !item.getClass().equals(ComboField.class) && !item.getClass().equals(BasedataField.class) && !item.getClass().equals(OrgField.class) && !item.getClass().equals(MaterielField.class) && !item.getClass().equals(CurrencyField.class) && !item.getClass().equals(CityField.class) && !item.getClass().equals(UnitField.class) && !(item instanceof UserField) && !item.getClass().equals(AddressField.class) && !item.getClass().equals(NameField.class) && !(item instanceof AmountField) && !item.getClass().equals(QtyField.class) && !item.getClass().equals(EmailField.class) && !item.getClass().equals(TelephoneField.class);
    }
}

