/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;

public class PrivacySchemeExportPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeBindDataListener {
    private static final String BOS_PRIVACY_PLUGIN = "bos-privacy-plugin";
    private static final String KEY_BTN_CLOSE = "button_close";
    private static final String KEY_BTN_EXPORT = "button_export";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTN_EXPORT, KEY_BTN_CLOSE});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addBeforeBindDataListener((BeforeBindDataListener)this);
    }

    public void beforeBindData(BeforeBindDataEvent evt) {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
                args.setListDataProvider((IListDataProvider)new BeforeListDataProvider());
                args.getListDataProvider().getQueryResult();
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        switch (button.getKey()) {
            case "button_export": {
                this.privacySchemeExport();
                break;
            }
            case "button_close": {
                this.getView().close();
            }
        }
    }

    private void privacySchemeExport() {
        StringBuilder sql = new StringBuilder();
        BillList billListAp = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billListAp.getSelectedRows();
        if (listSelectedRows.size() < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u65b9\u6848\u3002", (String)"PrivacySchemeExportPlugin_3", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            return;
        }
        for (ListSelectedRow row : listSelectedRows) {
            long fid = (Long)row.getPrimaryKeyValue();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)fid, (String)"t_privacy_scheme_config");
            String whereSql = "FID = " + fid;
            if (dynamicObject.get("fdatalabelid") == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6807\u7b7e\u6709\u95ee\u9898\uff0c\u65e0\u6cd5\u5bfc\u51fa\u3002", (String)"PrivacySchemeExportPlugin_4", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                return;
            }
            long tagfid = (Long)dynamicObject.getDynamicObject("fdatalabelid").get("id");
            String dataTagSql = "FID = " + tagfid;
            sql.append(this.getDataTagSQL(dataTagSql));
            sql.append(String.format("DELETE FROM t_privacy_data_tag_tpl_l WHERE FID = %s ;\n", tagfid));
            sql.append(this.getDataTagLSQL(dataTagSql));
            sql.append(this.getDataTagR3SQL(dataTagSql));
            sql.append(String.format("DELETE FROM t_privacy_data_field_tpl WHERE FID = %s ;\n", tagfid));
            sql.append(this.getTagFiledSQL(dataTagSql));
            String dataTagMulSql = String.format(" fentryid in (select fentryid from t_privacy_data_tag_fields where fid = %s )", tagfid);
            sql.append(String.format("DELETE FROM t_privacy_data_field_tpl_l WHERE %s ;\n", dataTagMulSql));
            sql.append(this.getTagFiledMulLangSQL(dataTagMulSql));
            sql.append(this.getSchemeConfigSQl(whereSql));
            sql.append(String.format("DELETE FROM t_privacy_config_tpl_l WHERE FID = %s ;\n", fid));
            sql.append(this.getSchemeConfigLSQl(whereSql));
            sql.append(this.getSchemeConfigR3SQl(whereSql));
            sql.append(String.format("DELETE FROM t_privacy_desen_tpl WHERE FID = %s ;\n", fid));
            sql.append(this.getSchemeDesenSQL(whereSql));
            String schemeDesenMulSql = String.format(" fentryid in (select fentryid from t_privacy_desen_tpl where fid = %s )", fid);
            sql.append(String.format("DELETE FROM t_privacy_desen_tpl_l WHERE %s ;\n", schemeDesenMulSql));
            sql.append(this.getSchemeDesenMulSQL(schemeDesenMulSql));
            sql.append(String.format("DELETE FROM t_privacy_encrypt_tpl WHERE FID = %s ;\n", fid));
            sql.append(this.getSchemeEncryptSQL(whereSql));
            String schemeEncryptMulSql = String.format(" fentryid in (select fentryid from t_privacy_encrypt_tpl where fid = %s )", fid);
            sql.append(String.format("DELETE FROM t_privacy_encrypt_tpl_l WHERE %s ;\n", schemeEncryptMulSql));
            sql.append(this.getSchemeEncryptMulSQL(schemeEncryptMulSql));
        }
        String sqlFileName = String.format("%s_%s.sql", "privacy_template_", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        try (ByteArrayInputStream ins = new ByteArrayInputStream(sql.toString().getBytes(StandardCharsets.UTF_8));){
            this.exportFile(ins, sqlFileName);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
        }
        this.getView().close();
    }

    private String getSchemeConfigSQl(String whereSql) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        List templatecoloum = DB.getColumnNames((DBRoute)DBRoute.of((String)"sys"), (String)"t_privacy_config_tpl");
        String selectColoum = org.apache.commons.lang.StringUtils.join((Collection)templatecoloum, (String)",");
        Map map = new HashMap();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)"sys"), "t_privacy_scheme_config", selectColoum, whereSql, "", "");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        String sql = (String)map.get("sql");
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            sql = sql.replace("t_privacy_scheme_config", "t_privacy_config_tpl");
        }
        return sql;
    }

    private String getSchemeConfigLSQl(String whereSql) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        List templatecoloum = DB.getColumnNames((DBRoute)DBRoute.of((String)"sys"), (String)"t_privacy_config_tpl_l");
        String selectColoum = org.apache.commons.lang.StringUtils.join((Collection)templatecoloum, (String)",");
        Map map = new HashMap();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)"sys"), "t_privacy_scheme_config_l", selectColoum, whereSql, "", "");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        String sql = (String)map.get("sql");
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            sql = sql.replace("t_privacy_scheme_config_l", "t_privacy_config_tpl_l");
        }
        return sql;
    }

    private String getSchemeConfigR3SQl(String whereSql) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        List templatecoloum = DB.getColumnNames((DBRoute)DBRoute.of((String)"sys"), (String)"t_privacy_config_tpl_r3");
        String selectColoum = org.apache.commons.lang.StringUtils.join((Collection)templatecoloum, (String)",");
        Map map = new HashMap();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)"sys"), "t_privacy_scheme_confi_r3", selectColoum, whereSql, "", "");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        String sql = (String)map.get("sql");
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            sql = sql.replace("t_privacy_scheme_confi_r3", "t_privacy_config_tpl_r3");
        }
        return sql;
    }

    private String getSchemeDesenSQL(String whereSql) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        List coloum = DB.getColumnNames((DBRoute)DBRoute.of((String)"sys"), (String)"t_privacy_desen_tpl");
        String selectColoum = org.apache.commons.lang.StringUtils.join((Collection)coloum, (String)",");
        Map map = new HashMap();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)"sys"), "t_privacy_scheme_desen", selectColoum, whereSql, "", "");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        String sql = (String)map.get("sql");
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            sql = sql.replace("t_privacy_scheme_desen", "t_privacy_desen_tpl");
        }
        return sql;
    }

    private String getSchemeEncryptSQL(String whereSql) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        List coloum = DB.getColumnNames((DBRoute)DBRoute.of((String)"sys"), (String)"t_privacy_encrypt_tpl");
        String selectColoum = org.apache.commons.lang.StringUtils.join((Collection)coloum, (String)",");
        Map map = new HashMap();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)"sys"), "t_privacy_scheme_encrypt", selectColoum, whereSql, "", "");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        String sql = (String)map.get("sql");
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            sql = sql.replace("t_privacy_scheme_encrypt", "t_privacy_encrypt_tpl");
        }
        return sql;
    }

    private String getDataTagSQL(String whereSql) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        List coloum = DB.getColumnNames((DBRoute)DBRoute.of((String)"sys"), (String)"t_privacy_data_tag_tpl");
        coloum.remove("ftype");
        String selectColoum = org.apache.commons.lang.StringUtils.join((Collection)coloum, (String)",");
        Map map = new HashMap();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)"sys"), "t_privacy_data_tag", selectColoum, whereSql, "", "");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        String sql = (String)map.get("sql");
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            sql = sql.replace("t_privacy_data_tag", "t_privacy_data_tag_tpl");
        }
        return sql;
    }

    private String getDataTagR3SQL(String whereSql) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        List coloum = DB.getColumnNames((DBRoute)DBRoute.of((String)"sys"), (String)"t_privacy_data_tag_tpl_r3");
        String selectColoum = org.apache.commons.lang.StringUtils.join((Collection)coloum, (String)",");
        Map map = new HashMap();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)"sys"), "t_privacy_data_tag_r3", selectColoum, whereSql, "", "");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        String sql = (String)map.get("sql");
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            sql = sql.replace("t_privacy_data_tag_r3", "t_privacy_data_tag_tpl_r3");
        }
        return sql;
    }

    private String getDataTagLSQL(String whereSql) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        List coloum = DB.getColumnNames((DBRoute)DBRoute.of((String)"sys"), (String)"t_privacy_data_tag_tpl_l");
        String selectColoum = org.apache.commons.lang.StringUtils.join((Collection)coloum, (String)",");
        Map map = new HashMap();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)"sys"), "t_privacy_data_tag_l", selectColoum, whereSql, "", "");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        String sql = (String)map.get("sql");
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            sql = sql.replace("t_privacy_data_tag_l", "t_privacy_data_tag_tpl_l");
        }
        return sql;
    }

    private String getTagFiledSQL(String whereSql) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        List coloum = DB.getColumnNames((DBRoute)DBRoute.of((String)"sys"), (String)"t_privacy_data_field_tpl");
        String selectColoum = org.apache.commons.lang.StringUtils.join((Collection)coloum, (String)",");
        Map map = new HashMap();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)"sys"), "t_privacy_data_tag_fields", selectColoum, whereSql, "", "");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        String sql = (String)map.get("sql");
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            sql = sql.replace("t_privacy_data_tag_fields", "t_privacy_data_field_tpl");
        }
        return sql;
    }

    private String getTagFiledMulLangSQL(String whereSql) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        List coloum = DB.getColumnNames((DBRoute)DBRoute.of((String)"sys"), (String)"t_privacy_data_field_tpl_l");
        String selectColoum = org.apache.commons.lang.StringUtils.join((Collection)coloum, (String)",");
        Map map = new HashMap();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)"sys"), "t_privacy_data_tag_fields_l", selectColoum, whereSql, "", "");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        String sql = (String)map.get("sql");
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            sql = sql.replace("t_privacy_data_tag_fields_l", "t_privacy_data_field_tpl_l");
        }
        return sql;
    }

    private String getSchemeDesenMulSQL(String whereSql) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        List coloum = DB.getColumnNames((DBRoute)DBRoute.of((String)"sys"), (String)"t_privacy_desen_tpl_l");
        String selectColoum = org.apache.commons.lang.StringUtils.join((Collection)coloum, (String)",");
        Map map = new HashMap();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)"sys"), "t_privacy_scheme_desen_l", selectColoum, whereSql, "", "");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        String sql = (String)map.get("sql");
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            sql = sql.replace("t_privacy_scheme_desen_l", "t_privacy_desen_tpl_l");
        }
        return sql;
    }

    private String getSchemeEncryptMulSQL(String whereSql) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        List coloum = DB.getColumnNames((DBRoute)DBRoute.of((String)"sys"), (String)"t_privacy_encrypt_tpl_l");
        String selectColoum = org.apache.commons.lang.StringUtils.join((Collection)coloum, (String)",");
        Map map = new HashMap();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)"sys"), "t_privacy_scheme_encrypt_l", selectColoum, whereSql, "", "");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
        String sql = (String)map.get("sql");
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            sql = sql.replace("t_privacy_scheme_encrypt_l", "t_privacy_encrypt_tpl_l");
        }
        return sql;
    }

    private void exportFile(InputStream ins, String sqlFileName) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, ins, 5000);
        this.getView().openUrl(url);
    }

    static class BeforeListDataProvider
    extends ListDataProvider {
        BeforeListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection list = super.getData(start, limit);
            HashSet<Object> idSets = new HashSet<Object>(list.size());
            for (DynamicObject row : list) {
                idSets.add(row.getPkValue());
            }
            Set schemeIds = new HashSet(1);
            if (list.isEmpty()) {
                return list;
            }
            String sql = String.format("select fid from t_privacy_scheme_encrypt where fid in (%s) and fencrypt_status != '%s'", StringUtils.join((Object[])idSets.toArray(), (String)","), Character.valueOf('1'));
            try {
                schemeIds = (Set)DB.query((DBRoute)new DBRoute("sys"), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                    public Set<Long> handle(ResultSet rs) throws SQLException {
                        HashSet<Long> schemeIds = new HashSet<Long>(6);
                        while (rs.next()) {
                            schemeIds.add(rs.getLong(1));
                        }
                        return schemeIds;
                    }
                });
            }
            catch (Exception e) {
                String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
            }
            for (DynamicObject object : list) {
                if (schemeIds == null || !schemeIds.contains(object.get("id"))) {
                    object.set(5, (Object)ResManager.loadKDString((String)"\u5df2\u53d1\u5e03", (String)"PrivacySchemeExportPlugin_0", (String)PrivacySchemeExportPlugin.BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                    continue;
                }
                object.set(5, (Object)ResManager.loadKDString((String)"\u53d1\u5e03\u4e2d", (String)"PrivacySchemeExportPlugin_1", (String)PrivacySchemeExportPlugin.BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
            }
            this.getQueryResult().setCollection(list);
            this.getQueryResult().setDataCount(list.size());
            return list;
        }
    }
}

